# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IpamIpamResourceDiscoveryArgs', 'IpamIpamResourceDiscovery']

@pulumi.input_type
class IpamIpamResourceDiscoveryArgs:
    def __init__(__self__, *,
                 operating_region_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 ipam_resource_discovery_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_resource_discovery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a IpamIpamResourceDiscovery resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: The list of operating regions for resource discovery.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_description: The description of resource discovery.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_name: The name of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label list information.
        """
        pulumi.set(__self__, "operating_region_lists", operating_region_lists)
        if ipam_resource_discovery_description is not None:
            pulumi.set(__self__, "ipam_resource_discovery_description", ipam_resource_discovery_description)
        if ipam_resource_discovery_name is not None:
            pulumi.set(__self__, "ipam_resource_discovery_name", ipam_resource_discovery_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of operating regions for resource discovery.
        """
        return pulumi.get(self, "operating_region_lists")

    @operating_region_lists.setter
    def operating_region_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "operating_region_lists", value)

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryDescription")
    def ipam_resource_discovery_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of resource discovery.
        """
        return pulumi.get(self, "ipam_resource_discovery_description")

    @ipam_resource_discovery_description.setter
    def ipam_resource_discovery_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_resource_discovery_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryName")
    def ipam_resource_discovery_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "ipam_resource_discovery_name")

    @ipam_resource_discovery_name.setter
    def ipam_resource_discovery_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_resource_discovery_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label list information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _IpamIpamResourceDiscoveryState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_resource_discovery_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_resource_discovery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering IpamIpamResourceDiscovery resources.
        :param pulumi.Input[_builtins.str] create_time: The time when the resource discovery was created.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_description: The description of resource discovery.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: The list of operating regions for resource discovery.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource discovery instance. Value:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label list information.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ipam_resource_discovery_description is not None:
            pulumi.set(__self__, "ipam_resource_discovery_description", ipam_resource_discovery_description)
        if ipam_resource_discovery_name is not None:
            pulumi.set(__self__, "ipam_resource_discovery_name", ipam_resource_discovery_name)
        if operating_region_lists is not None:
            pulumi.set(__self__, "operating_region_lists", operating_region_lists)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time when the resource discovery was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryDescription")
    def ipam_resource_discovery_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of resource discovery.
        """
        return pulumi.get(self, "ipam_resource_discovery_description")

    @ipam_resource_discovery_description.setter
    def ipam_resource_discovery_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_resource_discovery_description", value)

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryName")
    def ipam_resource_discovery_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "ipam_resource_discovery_name")

    @ipam_resource_discovery_name.setter
    def ipam_resource_discovery_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipam_resource_discovery_name", value)

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of operating regions for resource discovery.
        """
        return pulumi.get(self, "operating_region_lists")

    @operating_region_lists.setter
    def operating_region_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "operating_region_lists", value)

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource discovery instance. Value:
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label list information.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("alicloud:vpc/ipamIpamResourceDiscovery:IpamIpamResourceDiscovery")
class IpamIpamResourceDiscovery(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_resource_discovery_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_resource_discovery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Provides a Vpc Ipam Ipam Resource Discovery resource.

        IP Address Management Resource Discovery.

        For information about Vpc Ipam Ipam Resource Discovery and how to use it, see [What is Ipam Resource Discovery](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamResourceDiscovery).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_ipam_ipam_resource_discovery = alicloud.vpc.IpamIpamResourceDiscovery("default",
            operating_region_lists=["cn-hangzhou"],
            ipam_resource_discovery_description="This is a custom IPAM resource discovery.",
            ipam_resource_discovery_name="example_resource_discovery")
        ```

        ## Import

        Vpc Ipam Ipam Resource Discovery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamResourceDiscovery:IpamIpamResourceDiscovery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_description: The description of resource discovery.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: The list of operating regions for resource discovery.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label list information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpamIpamResourceDiscoveryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Vpc Ipam Ipam Resource Discovery resource.

        IP Address Management Resource Discovery.

        For information about Vpc Ipam Ipam Resource Discovery and how to use it, see [What is Ipam Resource Discovery](https://next.api.alibabacloud.com/document/VpcIpam/2023-02-28/CreateIpamResourceDiscovery).

        > **NOTE:** Available since v1.243.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_ipam_ipam_resource_discovery = alicloud.vpc.IpamIpamResourceDiscovery("default",
            operating_region_lists=["cn-hangzhou"],
            ipam_resource_discovery_description="This is a custom IPAM resource discovery.",
            ipam_resource_discovery_name="example_resource_discovery")
        ```

        ## Import

        Vpc Ipam Ipam Resource Discovery can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipamIpamResourceDiscovery:IpamIpamResourceDiscovery example <id>
        ```

        :param str resource_name: The name of the resource.
        :param IpamIpamResourceDiscoveryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpamIpamResourceDiscoveryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ipam_resource_discovery_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipam_resource_discovery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpamIpamResourceDiscoveryArgs.__new__(IpamIpamResourceDiscoveryArgs)

            __props__.__dict__["ipam_resource_discovery_description"] = ipam_resource_discovery_description
            __props__.__dict__["ipam_resource_discovery_name"] = ipam_resource_discovery_name
            if operating_region_lists is None and not opts.urn:
                raise TypeError("Missing required property 'operating_region_lists'")
            __props__.__dict__["operating_region_lists"] = operating_region_lists
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["create_time"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["status"] = None
        super(IpamIpamResourceDiscovery, __self__).__init__(
            'alicloud:vpc/ipamIpamResourceDiscovery:IpamIpamResourceDiscovery',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_resource_discovery_description: Optional[pulumi.Input[_builtins.str]] = None,
            ipam_resource_discovery_name: Optional[pulumi.Input[_builtins.str]] = None,
            operating_region_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'IpamIpamResourceDiscovery':
        """
        Get an existing IpamIpamResourceDiscovery resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_time: The time when the resource discovery was created.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_description: The description of resource discovery.
        :param pulumi.Input[_builtins.str] ipam_resource_discovery_name: The name of the resource
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] operating_region_lists: The list of operating regions for resource discovery.
        :param pulumi.Input[_builtins.str] region_id: The region ID of the resource
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group
        :param pulumi.Input[_builtins.str] status: The status of the resource discovery instance. Value:
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label list information.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpamIpamResourceDiscoveryState.__new__(_IpamIpamResourceDiscoveryState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ipam_resource_discovery_description"] = ipam_resource_discovery_description
        __props__.__dict__["ipam_resource_discovery_name"] = ipam_resource_discovery_name
        __props__.__dict__["operating_region_lists"] = operating_region_lists
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return IpamIpamResourceDiscovery(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The time when the resource discovery was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryDescription")
    def ipam_resource_discovery_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of resource discovery.
        """
        return pulumi.get(self, "ipam_resource_discovery_description")

    @_builtins.property
    @pulumi.getter(name="ipamResourceDiscoveryName")
    def ipam_resource_discovery_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the resource
        """
        return pulumi.get(self, "ipam_resource_discovery_name")

    @_builtins.property
    @pulumi.getter(name="operatingRegionLists")
    def operating_region_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of operating regions for resource discovery.
        """
        return pulumi.get(self, "operating_region_lists")

    @_builtins.property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[_builtins.str]:
        """
        The region ID of the resource
        """
        return pulumi.get(self, "region_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource discovery instance. Value:
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Label list information.
        """
        return pulumi.get(self, "tags")

