# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['Ipv6AddressArgs', 'Ipv6Address']

@pulumi.input_type
class Ipv6AddressArgs:
    def __init__(__self__, *,
                 vswitch_id: pulumi.Input[_builtins.str],
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ipv6Address resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitchId of the IPv6 address.
        :param pulumi.Input[_builtins.str] address_type: The type of the IPv6 address. Value:
               - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
               - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        :param pulumi.Input[_builtins.str] ipv6_address: IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_description: The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_address_name: The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        """
        pulumi.set(__self__, "vswitch_id", vswitch_id)
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_description is not None:
            pulumi.set(__self__, "ipv6_address_description", ipv6_address_description)
        if ipv6_address_name is not None:
            pulumi.set(__self__, "ipv6_address_name", ipv6_address_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VSwitchId of the IPv6 address.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vswitch_id", value)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the IPv6 address. Value:
        - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
        - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressDescription")
    def ipv6_address_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_description")

    @ipv6_address_description.setter
    def ipv6_address_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_description", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressName")
    def ipv6_address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_name")

    @ipv6_address_name.setter
    def ipv6_address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _Ipv6AddressState:
    def __init__(__self__, *,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Ipv6Address resources.
        :param pulumi.Input[_builtins.str] address_type: The type of the IPv6 address. Value:
               - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
               - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ipv6_address: IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_description: The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_address_name: The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] status: The status of the resource.  Available, Pending and Deleting.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitchId of the IPv6 address.
        """
        if address_type is not None:
            pulumi.set(__self__, "address_type", address_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if ipv6_address_description is not None:
            pulumi.set(__self__, "ipv6_address_description", ipv6_address_description)
        if ipv6_address_name is not None:
            pulumi.set(__self__, "ipv6_address_name", ipv6_address_name)
        if resource_group_id is not None:
            pulumi.set(__self__, "resource_group_id", resource_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the IPv6 address. Value:
        - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
        - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        """
        return pulumi.get(self, "address_type")

    @address_type.setter
    def address_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "address_type", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressDescription")
    def ipv6_address_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_description")

    @ipv6_address_description.setter
    def ipv6_address_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_description", value)

    @_builtins.property
    @pulumi.getter(name="ipv6AddressName")
    def ipv6_address_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_name")

    @ipv6_address_name.setter
    def ipv6_address_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ipv6_address_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @resource_group_id.setter
    def resource_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the resource.  Available, Pending and Deleting.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VSwitchId of the IPv6 address.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:vpc/ipv6Address:Ipv6Address")
class Ipv6Address(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a VPC Ipv6 Address resource.

        For information about VPC Ipv6 Address and how to use it, see [What is Ipv6 Address](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AllocateIpv6Address).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        vpc = alicloud.vpc.Network("vpc",
            ipv6_isp="BGP",
            cidr_block="172.168.0.0/16",
            enable_ipv6=True,
            vpc_name=name)
        vswich = alicloud.vpc.Switch("vswich",
            vpc_id=vpc.id,
            cidr_block="172.168.0.0/24",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=name,
            ipv6_cidr_block_mask=1)
        default_ipv6_address = alicloud.vpc.Ipv6Address("default",
            resource_group_id=default.ids[0],
            vswitch_id=vswich.id,
            ipv6_address_description="create_description",
            ipv6_address_name=name)
        ```

        ## Import

        VPC Ipv6 Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6Address:Ipv6Address example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: The type of the IPv6 address. Value:
               - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
               - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        :param pulumi.Input[_builtins.str] ipv6_address: IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_description: The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_address_name: The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitchId of the IPv6 address.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Ipv6AddressArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a VPC Ipv6 Address resource.

        For information about VPC Ipv6 Address and how to use it, see [What is Ipv6 Address](https://next.api.alibabacloud.com/document/Vpc/2016-04-28/AllocateIpv6Address).

        > **NOTE:** Available since v1.216.0.

        ## Example Usage

        Basic Usage

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "terraform-example"
        default = alicloud.resourcemanager.get_resource_groups()
        default_get_zones = alicloud.get_zones(available_resource_creation="VSwitch")
        vpc = alicloud.vpc.Network("vpc",
            ipv6_isp="BGP",
            cidr_block="172.168.0.0/16",
            enable_ipv6=True,
            vpc_name=name)
        vswich = alicloud.vpc.Switch("vswich",
            vpc_id=vpc.id,
            cidr_block="172.168.0.0/24",
            zone_id=default_get_zones.zones[0].id,
            vswitch_name=name,
            ipv6_cidr_block_mask=1)
        default_ipv6_address = alicloud.vpc.Ipv6Address("default",
            resource_group_id=default.ids[0],
            vswitch_id=vswich.id,
            ipv6_address_description="create_description",
            ipv6_address_name=name)
        ```

        ## Import

        VPC Ipv6 Address can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/ipv6Address:Ipv6Address example <id>
        ```

        :param str resource_name: The name of the resource.
        :param Ipv6AddressArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(Ipv6AddressArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_type: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_description: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_address_name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = Ipv6AddressArgs.__new__(Ipv6AddressArgs)

            __props__.__dict__["address_type"] = address_type
            __props__.__dict__["ipv6_address"] = ipv6_address
            __props__.__dict__["ipv6_address_description"] = ipv6_address_description
            __props__.__dict__["ipv6_address_name"] = ipv6_address_name
            __props__.__dict__["resource_group_id"] = resource_group_id
            __props__.__dict__["tags"] = tags
            if vswitch_id is None and not opts.urn:
                raise TypeError("Missing required property 'vswitch_id'")
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["status"] = None
        super(Ipv6Address, __self__).__init__(
            'alicloud:vpc/ipv6Address:Ipv6Address',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_type: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address_description: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_address_name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Ipv6Address':
        """
        Get an existing Ipv6Address resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] address_type: The type of the IPv6 address. Value:
               - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
               - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        :param pulumi.Input[_builtins.str] create_time: The creation time of the resource.
        :param pulumi.Input[_builtins.str] ipv6_address: IPv6 address
        :param pulumi.Input[_builtins.str] ipv6_address_description: The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] ipv6_address_name: The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        :param pulumi.Input[_builtins.str] resource_group_id: The ID of the resource group to which the instance belongs.
        :param pulumi.Input[_builtins.str] status: The status of the resource.  Available, Pending and Deleting.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags for the resource.
        :param pulumi.Input[_builtins.str] vswitch_id: The VSwitchId of the IPv6 address.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _Ipv6AddressState.__new__(_Ipv6AddressState)

        __props__.__dict__["address_type"] = address_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["ipv6_address_description"] = ipv6_address_description
        __props__.__dict__["ipv6_address_name"] = ipv6_address_name
        __props__.__dict__["resource_group_id"] = resource_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vswitch_id"] = vswitch_id
        return Ipv6Address(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="addressType")
    def address_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the IPv6 address. Value:
        - `IPv6Address` (default): indicates that the current instance is a single IPv6 address.
        - `IPv6Prefix`: indicates that the current instance is a contiguous block of IPv6 addresses.
        """
        return pulumi.get(self, "address_type")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the resource.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[_builtins.str]:
        """
        IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressDescription")
    def ipv6_address_description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the IPv6 Address. The description must be 2 to 256 characters in length. It cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_description")

    @_builtins.property
    @pulumi.getter(name="ipv6AddressName")
    def ipv6_address_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the IPv6 Address. The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (_), and hyphens (-). The name must start with a letter but cannot start with http:// or https://.
        """
        return pulumi.get(self, "ipv6_address_name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupId")
    def resource_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the resource group to which the instance belongs.
        """
        return pulumi.get(self, "resource_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the resource.  Available, Pending and Deleting.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags for the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VSwitchId of the IPv6 address.
        """
        return pulumi.get(self, "vswitch_id")

