# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NatGatewayArgs', 'NatGateway']

@pulumi.input_type
class NatGatewayArgs:
    def __init__(__self__, *,
                 vpc_id: pulumi.Input[_builtins.str],
                 access_mode: Optional[pulumi.Input['NatGatewayAccessModeArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip_bind_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_reply_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NatGateway resource.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input['NatGatewayAccessModeArgs'] access_mode: The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] eip_bind_mode: The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
               - `MULTI_BINDED`: Multi EIP network card visible mode.
               - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully delete the NAT gateway.
        :param pulumi.Input[_builtins.bool] icmp_reply_enabled: Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        :param pulumi.Input[_builtins.str] nat_gateway_name: Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.str] nat_type: The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        :param pulumi.Input[_builtins.str] network_type: Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] private_link_enabled: Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] specification: The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of NAT gateway.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if eip_bind_mode is not None:
            pulumi.set(__self__, "eip_bind_mode", eip_bind_mode)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if icmp_reply_enabled is not None:
            pulumi.set(__self__, "icmp_reply_enabled", icmp_reply_enabled)
        if instance_charge_type is not None:
            warnings.warn("""Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway_name is not None:
            pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if private_link_enabled is not None:
            pulumi.set(__self__, "private_link_enabled", private_link_enabled)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input['NatGatewayAccessModeArgs']]:
        """
        The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input['NatGatewayAccessModeArgs']]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="eipBindMode")
    def eip_bind_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
        - `MULTI_BINDED`: Multi EIP network card visible mode.
        - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        """
        return pulumi.get(self, "eip_bind_mode")

    @eip_bind_mode.setter
    def eip_bind_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_bind_mode", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the NAT gateway.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="icmpReplyEnabled")
    def icmp_reply_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "icmp_reply_enabled")

    @icmp_reply_enabled.setter
    def icmp_reply_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_reply_enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "nat_gateway_name")

    @nat_gateway_name.setter
    def nat_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkEnabled")
    def private_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "private_link_enabled")

    @private_link_enabled.setter
    def private_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_enabled", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.input_type
class _NatGatewayState:
    def __init__(__self__, *,
                 access_mode: Optional[pulumi.Input['NatGatewayAccessModeArgs']] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip_bind_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 forward_table_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 icmp_reply_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 snat_table_ids: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NatGateway resources.
        :param pulumi.Input['NatGatewayAccessModeArgs'] access_mode: The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] eip_bind_mode: The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
               - `MULTI_BINDED`: Multi EIP network card visible mode.
               - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully delete the NAT gateway.
        :param pulumi.Input[_builtins.str] forward_table_ids: The nat gateway will auto create a forward item.
        :param pulumi.Input[_builtins.bool] icmp_reply_enabled: Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        :param pulumi.Input[_builtins.str] nat_gateway_name: Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.str] nat_type: The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        :param pulumi.Input[_builtins.str] network_type: Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] private_link_enabled: Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] snat_table_ids: The nat gateway will auto create a snat item.
        :param pulumi.Input[_builtins.str] specification: The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        :param pulumi.Input[_builtins.str] status: (Available since v1.121.0) The status of NAT gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of NAT gateway.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        if access_mode is not None:
            pulumi.set(__self__, "access_mode", access_mode)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dry_run is not None:
            pulumi.set(__self__, "dry_run", dry_run)
        if eip_bind_mode is not None:
            pulumi.set(__self__, "eip_bind_mode", eip_bind_mode)
        if force is not None:
            pulumi.set(__self__, "force", force)
        if forward_table_ids is not None:
            pulumi.set(__self__, "forward_table_ids", forward_table_ids)
        if icmp_reply_enabled is not None:
            pulumi.set(__self__, "icmp_reply_enabled", icmp_reply_enabled)
        if instance_charge_type is not None:
            warnings.warn("""Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""", DeprecationWarning)
            pulumi.log.warn("""instance_charge_type is deprecated: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""")
        if instance_charge_type is not None:
            pulumi.set(__self__, "instance_charge_type", instance_charge_type)
        if internet_charge_type is not None:
            pulumi.set(__self__, "internet_charge_type", internet_charge_type)
        if name is not None:
            warnings.warn("""Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""", DeprecationWarning)
            pulumi.log.warn("""name is deprecated: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""")
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nat_gateway_name is not None:
            pulumi.set(__self__, "nat_gateway_name", nat_gateway_name)
        if nat_type is not None:
            pulumi.set(__self__, "nat_type", nat_type)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if payment_type is not None:
            pulumi.set(__self__, "payment_type", payment_type)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if private_link_enabled is not None:
            pulumi.set(__self__, "private_link_enabled", private_link_enabled)
        if snat_table_ids is not None:
            pulumi.set(__self__, "snat_table_ids", snat_table_ids)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vswitch_id is not None:
            pulumi.set(__self__, "vswitch_id", vswitch_id)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> Optional[pulumi.Input['NatGatewayAccessModeArgs']]:
        """
        The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        """
        return pulumi.get(self, "access_mode")

    @access_mode.setter
    def access_mode(self, value: Optional[pulumi.Input['NatGatewayAccessModeArgs']]):
        pulumi.set(self, "access_mode", value)

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletion_protection", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @dry_run.setter
    def dry_run(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dry_run", value)

    @_builtins.property
    @pulumi.getter(name="eipBindMode")
    def eip_bind_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
        - `MULTI_BINDED`: Multi EIP network card visible mode.
        - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        """
        return pulumi.get(self, "eip_bind_mode")

    @eip_bind_mode.setter
    def eip_bind_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_bind_mode", value)

    @_builtins.property
    @pulumi.getter
    def force(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the NAT gateway.
        """
        return pulumi.get(self, "force")

    @force.setter
    def force(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force", value)

    @_builtins.property
    @pulumi.getter(name="forwardTableIds")
    def forward_table_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nat gateway will auto create a forward item.
        """
        return pulumi.get(self, "forward_table_ids")

    @forward_table_ids.setter
    def forward_table_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "forward_table_ids", value)

    @_builtins.property
    @pulumi.getter(name="icmpReplyEnabled")
    def icmp_reply_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "icmp_reply_enabled")

    @icmp_reply_enabled.setter
    def icmp_reply_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "icmp_reply_enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""")
    def instance_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @instance_charge_type.setter
    def instance_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_charge_type", value)

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        """
        return pulumi.get(self, "internet_charge_type")

    @internet_charge_type.setter
    def internet_charge_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "internet_charge_type", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""")
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "nat_gateway_name")

    @nat_gateway_name.setter
    def nat_gateway_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_gateway_name", value)

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        """
        return pulumi.get(self, "nat_type")

    @nat_type.setter
    def nat_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nat_type", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @payment_type.setter
    def payment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "payment_type", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="privateLinkEnabled")
    def private_link_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "private_link_enabled")

    @private_link_enabled.setter
    def private_link_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_link_enabled", value)

    @_builtins.property
    @pulumi.getter(name="snatTableIds")
    def snat_table_ids(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The nat gateway will auto create a snat item.
        """
        return pulumi.get(self, "snat_table_ids")

    @snat_table_ids.setter
    def snat_table_ids(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snat_table_ids", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Available since v1.121.0) The status of NAT gateway.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

    @vswitch_id.setter
    def vswitch_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vswitch_id", value)


@pulumi.type_token("alicloud:vpc/natGateway:NatGateway")
class NatGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[Union['NatGatewayAccessModeArgs', 'NatGatewayAccessModeArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip_bind_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_reply_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a resource to create a VPC NAT Gateway.

        > **NOTE:** Resource bandwidth packages will not be supported since 00:00 on November 4, 2017, and public IP can be replaced be elastic IPs.
        If a Nat Gateway has already bought some bandwidth packages, it can not bind elastic IP and you have to submit the [work order](https://selfservice.console.aliyun.com/ticket/createIndex) to solve.
        If you want to add public IP, you can use resource 'alicloud_eip_association' to bind several elastic IPs for one Nat Gateway.

        > **NOTE:** From version 1.7.1, this resource has deprecated bandwidth packages.
        But, in order to manage stock bandwidth packages, version 1.13.0 re-support configuring 'bandwidth_packages'.

        > **NOTE:** When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see Service-linked roles.

        > **NOTE:** After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.

        > **NOTE:** Available since v1.37.0.

        ## Example Usage

        Basic usage

        - create enhanced nat gateway

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.vpc.get_enhanced_nat_available_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            zone_id=default.zones[0].zone_id,
            cidr_block="10.10.0.0/20",
            vpc_id=default_network.id)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        ```

        - transform nat from Normal to Enhanced
        > **NOTE:** You must set `nat_type` to `Enhanced` and set `vswitch_id`.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpc.get_enhanced_nat_available_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            zone_id=default.zones[0].zone_id,
            cidr_block="10.10.0.0/20",
            vpc_id=default_network.id)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        ```

        ## Import

        Nat gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/natGateway:NatGateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NatGatewayAccessModeArgs', 'NatGatewayAccessModeArgsDict']] access_mode: The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] eip_bind_mode: The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
               - `MULTI_BINDED`: Multi EIP network card visible mode.
               - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully delete the NAT gateway.
        :param pulumi.Input[_builtins.bool] icmp_reply_enabled: Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        :param pulumi.Input[_builtins.str] nat_gateway_name: Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.str] nat_type: The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        :param pulumi.Input[_builtins.str] network_type: Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] private_link_enabled: Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] specification: The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of NAT gateway.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NatGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to create a VPC NAT Gateway.

        > **NOTE:** Resource bandwidth packages will not be supported since 00:00 on November 4, 2017, and public IP can be replaced be elastic IPs.
        If a Nat Gateway has already bought some bandwidth packages, it can not bind elastic IP and you have to submit the [work order](https://selfservice.console.aliyun.com/ticket/createIndex) to solve.
        If you want to add public IP, you can use resource 'alicloud_eip_association' to bind several elastic IPs for one Nat Gateway.

        > **NOTE:** From version 1.7.1, this resource has deprecated bandwidth packages.
        But, in order to manage stock bandwidth packages, version 1.13.0 re-support configuring 'bandwidth_packages'.

        > **NOTE:** When you create an enhanced NAT gateway for the first time, the system automatically creates the service-linked role AliyunServiceRoleForNatgw. Then, the system attaches the permission policy AliyunServiceRolePolicyForNatgw to the role. This allows the NAT gateway to access other resources on Alibaba Cloud. For more information, see Service-linked roles.

        > **NOTE:** After you create an enhanced Internet NAT gateway, a route entry is automatically added to the route table of the VPC. The destination CIDR block of the route entry is 0.0.0.0/0 and the next hop is the NAT gateway. This ensures that traffic is routed to the NAT gateway.

        > **NOTE:** Available since v1.37.0.

        ## Example Usage

        Basic usage

        - create enhanced nat gateway

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf_example"
        default = alicloud.vpc.get_enhanced_nat_available_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            zone_id=default.zones[0].zone_id,
            cidr_block="10.10.0.0/20",
            vpc_id=default_network.id)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            payment_type="PayAsYouGo",
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        ```

        - transform nat from Normal to Enhanced
        > **NOTE:** You must set `nat_type` to `Enhanced` and set `vswitch_id`.

        ```python
        import pulumi
        import pulumi_alicloud as alicloud

        config = pulumi.Config()
        name = config.get("name")
        if name is None:
            name = "tf-example"
        default = alicloud.vpc.get_enhanced_nat_available_zones()
        default_network = alicloud.vpc.Network("default",
            vpc_name=name,
            cidr_block="10.0.0.0/8")
        default_switch = alicloud.vpc.Switch("default",
            vswitch_name=name,
            zone_id=default.zones[0].zone_id,
            cidr_block="10.10.0.0/20",
            vpc_id=default_network.id)
        default_nat_gateway = alicloud.vpc.NatGateway("default",
            vpc_id=default_network.id,
            nat_gateway_name=name,
            vswitch_id=default_switch.id,
            nat_type="Enhanced")
        ```

        ## Import

        Nat gateway can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/natGateway:NatGateway example <id>
        ```

        :param str resource_name: The name of the resource.
        :param NatGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NatGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_mode: Optional[pulumi.Input[Union['NatGatewayAccessModeArgs', 'NatGatewayAccessModeArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
                 eip_bind_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 force: Optional[pulumi.Input[_builtins.bool]] = None,
                 icmp_reply_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
                 nat_type: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 payment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 private_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vswitch_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NatGatewayArgs.__new__(NatGatewayArgs)

            __props__.__dict__["access_mode"] = access_mode
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["dry_run"] = dry_run
            __props__.__dict__["eip_bind_mode"] = eip_bind_mode
            __props__.__dict__["force"] = force
            __props__.__dict__["icmp_reply_enabled"] = icmp_reply_enabled
            __props__.__dict__["instance_charge_type"] = instance_charge_type
            __props__.__dict__["internet_charge_type"] = internet_charge_type
            __props__.__dict__["name"] = name
            __props__.__dict__["nat_gateway_name"] = nat_gateway_name
            __props__.__dict__["nat_type"] = nat_type
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["payment_type"] = payment_type
            __props__.__dict__["period"] = period
            __props__.__dict__["private_link_enabled"] = private_link_enabled
            __props__.__dict__["specification"] = specification
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vswitch_id"] = vswitch_id
            __props__.__dict__["forward_table_ids"] = None
            __props__.__dict__["snat_table_ids"] = None
            __props__.__dict__["status"] = None
        super(NatGateway, __self__).__init__(
            'alicloud:vpc/natGateway:NatGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_mode: Optional[pulumi.Input[Union['NatGatewayAccessModeArgs', 'NatGatewayAccessModeArgsDict']]] = None,
            deletion_protection: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dry_run: Optional[pulumi.Input[_builtins.bool]] = None,
            eip_bind_mode: Optional[pulumi.Input[_builtins.str]] = None,
            force: Optional[pulumi.Input[_builtins.bool]] = None,
            forward_table_ids: Optional[pulumi.Input[_builtins.str]] = None,
            icmp_reply_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            internet_charge_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_gateway_name: Optional[pulumi.Input[_builtins.str]] = None,
            nat_type: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            payment_type: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            private_link_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            snat_table_ids: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vswitch_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NatGateway':
        """
        Get an existing NatGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['NatGatewayAccessModeArgs', 'NatGatewayAccessModeArgsDict']] access_mode: The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        :param pulumi.Input[_builtins.bool] deletion_protection: Whether enable the deletion protection or not. Default value: `false`.
               - true: Enable deletion protection.
               - false: Disable deletion protection.
        :param pulumi.Input[_builtins.str] description: Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.bool] dry_run: Specifies whether to only precheck this request. Default value: `false`.
        :param pulumi.Input[_builtins.str] eip_bind_mode: The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
               - `MULTI_BINDED`: Multi EIP network card visible mode.
               - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        :param pulumi.Input[_builtins.bool] force: Specifies whether to forcefully delete the NAT gateway.
        :param pulumi.Input[_builtins.str] forward_table_ids: The nat gateway will auto create a forward item.
        :param pulumi.Input[_builtins.bool] icmp_reply_enabled: Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        :param pulumi.Input[_builtins.str] instance_charge_type: Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        :param pulumi.Input[_builtins.str] internet_charge_type: The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        :param pulumi.Input[_builtins.str] name: Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        :param pulumi.Input[_builtins.str] nat_gateway_name: Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        :param pulumi.Input[_builtins.str] nat_type: The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        :param pulumi.Input[_builtins.str] network_type: Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        :param pulumi.Input[_builtins.str] payment_type: The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        :param pulumi.Input[_builtins.int] period: The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
               > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        :param pulumi.Input[_builtins.bool] private_link_enabled: Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        :param pulumi.Input[_builtins.str] snat_table_ids: The nat gateway will auto create a snat item.
        :param pulumi.Input[_builtins.str] specification: The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        :param pulumi.Input[_builtins.str] status: (Available since v1.121.0) The status of NAT gateway.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The tags of NAT gateway.
        :param pulumi.Input[_builtins.str] vpc_id: The VPC ID.
        :param pulumi.Input[_builtins.str] vswitch_id: The id of VSwitch.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NatGatewayState.__new__(_NatGatewayState)

        __props__.__dict__["access_mode"] = access_mode
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["dry_run"] = dry_run
        __props__.__dict__["eip_bind_mode"] = eip_bind_mode
        __props__.__dict__["force"] = force
        __props__.__dict__["forward_table_ids"] = forward_table_ids
        __props__.__dict__["icmp_reply_enabled"] = icmp_reply_enabled
        __props__.__dict__["instance_charge_type"] = instance_charge_type
        __props__.__dict__["internet_charge_type"] = internet_charge_type
        __props__.__dict__["name"] = name
        __props__.__dict__["nat_gateway_name"] = nat_gateway_name
        __props__.__dict__["nat_type"] = nat_type
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["payment_type"] = payment_type
        __props__.__dict__["period"] = period
        __props__.__dict__["private_link_enabled"] = private_link_enabled
        __props__.__dict__["snat_table_ids"] = snat_table_ids
        __props__.__dict__["specification"] = specification
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vswitch_id"] = vswitch_id
        return NatGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> pulumi.Output['outputs.NatGatewayAccessMode']:
        """
        The access mode for reverse access to the VPC NAT gateway. See `access_mode` below.
        """
        return pulumi.get(self, "access_mode")

    @_builtins.property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether enable the deletion protection or not. Default value: `false`.
        - true: Enable deletion protection.
        - false: Disable deletion protection.
        """
        return pulumi.get(self, "deletion_protection")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description of the nat gateway, This description can have a string of 2 to 256 characters, It cannot begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dryRun")
    def dry_run(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to only precheck this request. Default value: `false`.
        """
        return pulumi.get(self, "dry_run")

    @_builtins.property
    @pulumi.getter(name="eipBindMode")
    def eip_bind_mode(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP binding mode of the NAT gateway. Default value: `MULTI_BINDED`. Valid values:
        - `MULTI_BINDED`: Multi EIP network card visible mode.
        - `NAT`: EIP normal mode, compatible with IPv4 gateway.
        """
        return pulumi.get(self, "eip_bind_mode")

    @_builtins.property
    @pulumi.getter
    def force(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcefully delete the NAT gateway.
        """
        return pulumi.get(self, "force")

    @_builtins.property
    @pulumi.getter(name="forwardTableIds")
    def forward_table_ids(self) -> pulumi.Output[_builtins.str]:
        """
        The nat gateway will auto create a forward item.
        """
        return pulumi.get(self, "forward_table_ids")

    @_builtins.property
    @pulumi.getter(name="icmpReplyEnabled")
    def icmp_reply_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable ICMP retrieval. Default value: `true`. Valid values:
        """
        return pulumi.get(self, "icmp_reply_enabled")

    @_builtins.property
    @pulumi.getter(name="instanceChargeType")
    @_utilities.deprecated("""Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.""")
    def instance_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        Field `instance_charge_type` has been deprecated from provider version 1.121.0. New field `payment_type` instead.
        """
        return pulumi.get(self, "instance_charge_type")

    @_builtins.property
    @pulumi.getter(name="internetChargeType")
    def internet_charge_type(self) -> pulumi.Output[_builtins.str]:
        """
        The internet charge type. Valid values `PayByLcu`. The `PayByLcu` is only support enhanced NAT. **NOTE:** From version 1.137.0, `internet_charge_type` cannot be set to `PayBySpec`.
        """
        return pulumi.get(self, "internet_charge_type")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.""")
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Field `name` has been deprecated from provider version 1.121.0. New field `nat_gateway_name` instead.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="natGatewayName")
    def nat_gateway_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the nat gateway. The value can have a string of 2 to 128 characters, must contain only alphanumeric characters or hyphens, such as "-",".","_", and must not begin or end with a hyphen, and must not begin with http:// or https://. Defaults to null.
        """
        return pulumi.get(self, "nat_gateway_name")

    @_builtins.property
    @pulumi.getter(name="natType")
    def nat_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of NAT gateway. Valid values: `Enhanced`. **NOTE:** From version 1.137.0, `nat_type` cannot be set to `Normal`.
        """
        return pulumi.get(self, "nat_type")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the type of the created NAT gateway. Valid values `internet` and `intranet`. `internet`: Internet NAT Gateway. `intranet`: VPC NAT Gateway.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter(name="paymentType")
    def payment_type(self) -> pulumi.Output[_builtins.str]:
        """
        The billing method of the NAT gateway. Valid values are `PayAsYouGo`. Default to `PayAsYouGo`.
        """
        return pulumi.get(self, "payment_type")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The duration that you will buy the resource, in month. It is valid when `payment_type` is `Subscription`. Valid values: [1-9, 12, 24, 36]. At present, the provider does not support modify "period" and you can do that via web console. **NOTE:** International station only supports `Subscription`.
        > **NOTE:** The attribute `period` is only used to create Subscription instance or modify the PayAsYouGo instance to Subscription. Once effect, it will not be modified that means running `pulumi up` will not effect the resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="privateLinkEnabled")
    def private_link_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable PrivateLink. Default value: `false`. Valid values:
        """
        return pulumi.get(self, "private_link_enabled")

    @_builtins.property
    @pulumi.getter(name="snatTableIds")
    def snat_table_ids(self) -> pulumi.Output[_builtins.str]:
        """
        The nat gateway will auto create a snat item.
        """
        return pulumi.get(self, "snat_table_ids")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[_builtins.str]:
        """
        The specification of the nat gateway. Valid values are `Small`, `Middle` and `Large`. Effective when `internet_charge_type` is `PayBySpec` and `network_type` is `internet`. Details refer to [Nat Gateway Specification](https://help.aliyun.com/document_detail/203500.html).
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (Available since v1.121.0) The status of NAT gateway.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The tags of NAT gateway.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The VPC ID.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vswitchId")
    def vswitch_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The id of VSwitch.
        """
        return pulumi.get(self, "vswitch_id")

