# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkInterfaceAttachmentArgs', 'NetworkInterfaceAttachment']

@pulumi.input_type
class NetworkInterfaceAttachmentArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 network_interface_id: pulumi.Input[_builtins.str],
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 trunk_network_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_network_configuration_ready: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a NetworkInterfaceAttachment resource.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID to attach.
        :param pulumi.Input[_builtins.str] network_interface_id: The ENI ID to attach.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if trunk_network_instance_id is not None:
            pulumi.set(__self__, "trunk_network_instance_id", trunk_network_instance_id)
        if wait_for_network_configuration_ready is not None:
            pulumi.set(__self__, "wait_for_network_configuration_ready", wait_for_network_configuration_ready)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter(name="trunkNetworkInstanceId")
    def trunk_network_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "trunk_network_instance_id")

    @trunk_network_instance_id.setter
    def trunk_network_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trunk_network_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="waitForNetworkConfigurationReady")
    def wait_for_network_configuration_ready(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "wait_for_network_configuration_ready")

    @wait_for_network_configuration_ready.setter
    def wait_for_network_configuration_ready(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_network_configuration_ready", value)


@pulumi.input_type
class _NetworkInterfaceAttachmentState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trunk_network_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_network_configuration_ready: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering NetworkInterfaceAttachment resources.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID to attach.
        :param pulumi.Input[_builtins.str] network_interface_id: The ENI ID to attach.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if network_card_index is not None:
            pulumi.set(__self__, "network_card_index", network_card_index)
        if network_interface_id is not None:
            pulumi.set(__self__, "network_interface_id", network_interface_id)
        if trunk_network_instance_id is not None:
            pulumi.set(__self__, "trunk_network_instance_id", trunk_network_instance_id)
        if wait_for_network_configuration_ready is not None:
            pulumi.set(__self__, "wait_for_network_configuration_ready", wait_for_network_configuration_ready)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "network_card_index")

    @network_card_index.setter
    def network_card_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "network_card_index", value)

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @network_interface_id.setter
    def network_interface_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_interface_id", value)

    @_builtins.property
    @pulumi.getter(name="trunkNetworkInstanceId")
    def trunk_network_instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "trunk_network_instance_id")

    @trunk_network_instance_id.setter
    def trunk_network_instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "trunk_network_instance_id", value)

    @_builtins.property
    @pulumi.getter(name="waitForNetworkConfigurationReady")
    def wait_for_network_configuration_ready(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "wait_for_network_configuration_ready")

    @wait_for_network_configuration_ready.setter
    def wait_for_network_configuration_ready(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "wait_for_network_configuration_ready", value)


@pulumi.type_token("alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment")
class NetworkInterfaceAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trunk_network_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_network_configuration_ready: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.EcsNetworkInterfaceAttachment from version 1.123.1.

        Provides an Alicloud ECS Elastic Network Interface Attachment as a resource to attach ENI to or detach ENI from ECS Instances.

        For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).

        ## Import

        Network Interfaces Attachment resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment eni eni-abc123456789000:i-abc123456789000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID to attach.
        :param pulumi.Input[_builtins.str] network_interface_id: The ENI ID to attach.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkInterfaceAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **DEPRECATED:** This resource has been renamed to ecs.EcsNetworkInterfaceAttachment from version 1.123.1.

        Provides an Alicloud ECS Elastic Network Interface Attachment as a resource to attach ENI to or detach ENI from ECS Instances.

        For information about Elastic Network Interface and how to use it, see [Elastic Network Interface](https://www.alibabacloud.com/help/doc-detail/58496.html).

        ## Import

        Network Interfaces Attachment resource can be imported using the id, e.g.

        ```sh
        $ pulumi import alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment eni eni-abc123456789000:i-abc123456789000
        ```

        :param str resource_name: The name of the resource.
        :param NetworkInterfaceAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkInterfaceAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
                 network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
                 trunk_network_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 wait_for_network_configuration_ready: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkInterfaceAttachmentArgs.__new__(NetworkInterfaceAttachmentArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["network_card_index"] = network_card_index
            if network_interface_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_interface_id'")
            __props__.__dict__["network_interface_id"] = network_interface_id
            __props__.__dict__["trunk_network_instance_id"] = trunk_network_instance_id
            __props__.__dict__["wait_for_network_configuration_ready"] = wait_for_network_configuration_ready
        super(NetworkInterfaceAttachment, __self__).__init__(
            'alicloud:vpc/networkInterfaceAttachment:NetworkInterfaceAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            network_card_index: Optional[pulumi.Input[_builtins.int]] = None,
            network_interface_id: Optional[pulumi.Input[_builtins.str]] = None,
            trunk_network_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            wait_for_network_configuration_ready: Optional[pulumi.Input[_builtins.bool]] = None) -> 'NetworkInterfaceAttachment':
        """
        Get an existing NetworkInterfaceAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: The instance ID to attach.
        :param pulumi.Input[_builtins.str] network_interface_id: The ENI ID to attach.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkInterfaceAttachmentState.__new__(_NetworkInterfaceAttachmentState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["network_card_index"] = network_card_index
        __props__.__dict__["network_interface_id"] = network_interface_id
        __props__.__dict__["trunk_network_instance_id"] = trunk_network_instance_id
        __props__.__dict__["wait_for_network_configuration_ready"] = wait_for_network_configuration_ready
        return NetworkInterfaceAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The instance ID to attach.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="networkCardIndex")
    def network_card_index(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "network_card_index")

    @_builtins.property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ENI ID to attach.
        """
        return pulumi.get(self, "network_interface_id")

    @_builtins.property
    @pulumi.getter(name="trunkNetworkInstanceId")
    def trunk_network_instance_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "trunk_network_instance_id")

    @_builtins.property
    @pulumi.getter(name="waitForNetworkConfigurationReady")
    def wait_for_network_configuration_ready(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "wait_for_network_configuration_ready")

