"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_cdk_lib_1 = require("aws-cdk-lib");
const secrets_manager = require("aws-cdk-lib/aws-secretsmanager");
const custom_resources = require("aws-cdk-lib/custom-resources");
const auth_1 = require("./auth");
const github_custom_resource_1 = require("./github-custom-resource");
// https://github.com/octokit/authentication-strategies.js/#the-authoptionsfactory-pattern
// export REPO=
// yarn bundle:custom-resource-provider/handler.lambda
// npx cdk deploy --app 'npx ts-node -P tsconfig.json --prefer-ts-exts ./src/integ.default.ts' --require-approval never --no-rollback
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, "GithubCustomResource");
const repo = process.env.REPO ?? "cdk-github";
const secret = secrets_manager.Secret.fromSecretNameV2(stack, "Auth", "cdk-github/test");
new github_custom_resource_1.GithubCustomResource(stack, "GithubRepo", {
    onCreate: {
        // https://octokit.github.io/rest.js/v19/#repos-create-in-org
        endpoint: "repos",
        method: "createInOrg",
        parameters: {
            org: "pepperize",
            name: repo,
        },
        outputPaths: ["id", "full_name"],
        physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
        ignoreErrorCodesMatching: "name already exists on this account",
    },
    onUpdate: {
        // https://octokit.github.io/rest.js/v19#repos-get
        endpoint: "repos",
        method: "get",
        parameters: {
            owner: "pepperize",
            repo,
        },
        outputPaths: ["id", "full_name"],
        physicalResourceId: custom_resources.PhysicalResourceId.fromResponse("full_name"),
    },
    onDelete: {
        // https://octokit.github.io/rest.js/v19#repos-delete
        endpoint: "repos",
        method: "get",
        parameters: {
            owner: "pepperize",
            repo,
        },
        outputPaths: [],
    },
    authOptions: auth_1.AuthOptions.appAuth(secret),
});
//# sourceMappingURL=data:application/json;base64,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