# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict, Union
from typing_extensions import Literal, Required, TypeAlias, TypedDict

__all__ = ["DefendSubmitEventParams", "ModelInput"]


class DefendSubmitEventParams(TypedDict, total=False):
    model_input: Required[ModelInput]
    """A dictionary of inputs sent to the LLM to generate output.

    This must contain a `user_prompt` field and an optional `context` field.
    Additional properties are allowed.
    """

    model_output: Required[str]
    """Output generated by the LLM to be evaluated."""

    model_used: Required[str]
    """Model ID used to generate the output, like `gpt-4o` or `o3`."""

    nametag: Required[str]
    """An optional, user-defined tag for the event."""

    run_mode: Required[Literal["precision_plus", "precision", "smart", "economy"]]
    """Run mode for the workflow event.

    The run mode allows the user to optimize for speed, accuracy, and cost by
    determining which models are used to evaluate the event. Available run modes
    include `precision_plus`, `precision`, `smart`, and `economy`. Defaults to
    `smart`.
    """


class ModelInputTyped(TypedDict, total=False):
    user_prompt: Required[str]

    context: str


ModelInput: TypeAlias = Union[ModelInputTyped, Dict[str, object]]
