# Release workflow

## PyPI

1. Draft a new release on github with a new tag (create on publish) in the style `vMajor.Minor.Patch`, where `Major`, `Minor`, and `Patch` are integers according to semnatic versioning
1. Use the autogenerated changelog to update `CHANGELOG.md` in main
   * helpful regex: `in (https://github.com/pymeasure/pyleco/pull/)(\d+)` to `([#$2]($1$2))`
1. Update the version and release date in `CITATION.cff`
1. Commit the aforementioned changes
1. Copy the modified changelog from the file to the github release draft
1. Release the new version on github
1. Approve the release run in the actions tab
1. Verify that the upload to PyPI succeeded


## Conda-forge

1. Do the PyPI release first
1. Rebase the `conda-forge-release` branch on the latest release
1. Ensure correct `pyproject.toml`:
   * State the version explicitly (e.g. `version = "1.2.3"` instead of `dynamic = ["version"]`) 
   * Comment out the `openrpc` dependency
   * Comment out the section (including header!) `[tool.setuptools_scm]`
1. Create a tag with `vMajor.Minor.Patch-cf` at the head of that branch
1. Update the conda-forge repository with the version and checksum of the tar.gz archive of that tag:
   * On windows use `certUtil -hashfile pyleco-1.2.3-cf.tar.gz SHA256` (adjust the version) to generate the SHA256 hash
