# Generated by Django 5.2 on 2025-08-27 10:15

import django.core.files.storage
import django.db.models.deletion
import django_ragamuffin.models
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Assistant",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=255)),
                ("instructions", models.TextField(blank=True, null=True)),
                (
                    "assistant_id",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("json_field", models.JSONField(blank=True, default=dict, null=True)),
                ("temperature", models.FloatField(blank=True, null=True)),
                ("clear_threads", models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name="OpenAIFile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("date", models.DateTimeField(auto_now=True)),
                ("checksum", models.CharField(blank=True, max_length=255)),
                ("name", models.CharField(blank=True, max_length=255)),
                ("path", models.CharField(blank=True, max_length=255)),
                ("file_ids", models.JSONField(blank=True, default=list, null=True)),
                (
                    "file",
                    models.FileField(
                        max_length=512,
                        storage=django.core.files.storage.FileSystemStorage(
                            "/subdomain-data/query", base_url="/media/"
                        ),
                        upload_to=django_ragamuffin.models.hashed_upload_to,
                        validators=[django_ragamuffin.models.validate_file_extension],
                    ),
                ),
                ("ntokens", models.IntegerField(blank=True, default=0, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="QUser",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("username", models.CharField(blank=True, max_length=255)),
                ("is_staff", models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name="RemoteVectorStore",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("checksum", models.CharField(blank=True, max_length=255, unique=True)),
                ("vector_store_id", models.CharField(blank=True, max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="Thread",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("date", models.DateTimeField(auto_now=True)),
                ("thread_id", models.CharField(blank=True, max_length=255)),
                ("messages", models.JSONField(blank=True, default=dict, null=True)),
                ("max_tokens", models.IntegerField(blank=True, null=True)),
                ("clear", models.BooleanField(default=False)),
                (
                    "assistant",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="threads",
                        to="django_ragamuffin.assistant",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="django_ragamuffin.quser",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="VectorStore",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("checksum", models.CharField(blank=True, max_length=255)),
                ("vsid", models.CharField(blank=True, max_length=255)),
                ("name", models.CharField(max_length=255)),
                (
                    "files",
                    models.ManyToManyField(
                        related_name="vector_stores", to="django_ragamuffin.openaifile"
                    ),
                ),
                (
                    "remote_vector_store",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="vector_stores",
                        to="django_ragamuffin.remotevectorstore",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="assistant",
            name="vector_stores",
            field=models.ManyToManyField(
                blank=True,
                related_name="assistants",
                to="django_ragamuffin.vectorstore",
            ),
        ),
    ]
