from setuptools import setup, find_packages
setup(
    name='django_ragamuffin',  
    version='1.102.0.2',
    packages=find_packages(),
    include_package_data=True,  # Important for static files/migrations
    license='MIT License',  # Choose your license
    description='A Django app for ...',
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    url='https://github.com/opentaproject/django_ragamuffin',
    author='Stellan Östlund',
    author_email='stellan.ostlund@gmail.com',
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 5.2',  # Update as appropriate
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3',
    ],
    install_requires=[
        'Django>=5.1',  # Specify Django version requirements
        'openai==1.102.0',
        "annotated-types==0.7.0",
        "anyio==4.9.0",
        "asgiref==3.8.1",
        "backports.tarfile==1.2.0",
        "build==1.2.2.post1",
        "certifi==2025.6.15",
        "charset-normalizer==3.4.1",
        "distro==1.9.0",
        "Django==5.2",
        "django-grappelli==4.0.2",
        "django-pytest==0.2.0",
        "djhtml==3.0.8",
        "docutils==0.21.2",
        "h11==0.16.0",
        "httpcore==1.0.9",
        "httpx==0.28.1",
        "id==1.5.0",
        "idna==3.10",
        "importlib_metadata==8.7.0",
        "iniconfig==2.1.0",
        "jaraco.classes==3.4.0",
        "jaraco.context==6.0.1",
        "jaraco.functools==4.1.0",
        "jiter==0.10.0",
        "keyring==25.6.0",
        "Markdown==3.8",
        "markdown-it-py==3.0.0",
        "markdown2==2.5.3",
        "mdurl==0.1.2",
        "more-itertools==10.7.0",
        "nh3==0.2.21",
        "packaging==25.0",
        "pip-autoremove==0.10.0",
        "pluggy==1.5.0",
        "psycopg2==2.9.10",
        "psycopg2-binary==2.9.10",
        "pydantic==2.11.7",
        "pydantic_core==2.33.2",
        "Pygments==2.19.1",
        "pypandoc==1.15",
        "pyproject_hooks==1.2.0",
        "pytest==8.3.5",
        "readme_renderer==44.0",
        "regex==2024.11.6",
        "requests==2.32.3",
        "requests-toolbelt==1.0.0",
        "rfc3986==2.0.0",
        "rich==14.0.0",
        "sniffio==1.3.1",
        "sqlparse==0.5.3",
        "tiktoken==0.9.0",
        "tqdm==4.67.1",
        "twine==6.1.0",
        "typing-inspection==0.4.1",
        "typing_extensions==4.14.0",
        "urllib3==2.4.0",
        "zipp==3.23.0",
    ],
    python_requires='>=3.11',  # Adjust as needed
)
