# coding: utf-8

"""
    Identity and Access Managment (IAM) (Alpha)

 

    OpenAPI spec version: v2024.14.0
     
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from  src.client.api.api_client import ApiClient


class PersonApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
     
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_person(self, id, **kwargs):  # noqa: E501
        """Get person  # noqa: E501

        Retrieve user details for the specified user ID.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted include_deleted: Whether to include all or some of the nested deleted objects.
        :param str uuid:
        :param str workspace_id:
        :param bool include_privileges: Include the user's maximal privileges and authorization roles
        :return: PersonReadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_person_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_person_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_person_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get person  # noqa: E501

        Retrieve user details for the specified user ID.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_person_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str fields: Semi-colons-separated list of fields
        :param str embed: Comma-separated list of objects to pull in as part of the response. See [Embedding Resources](#section/Overview/Embedding-Resources) for more information.
        :param IncludeDeleted include_deleted: Whether to include all or some of the nested deleted objects.
        :param str uuid:
        :param str workspace_id:
        :param bool include_privileges: Include the user's maximal privileges and authorization roles
        :return: PersonReadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'fields', 'embed', 'include_deleted', 'uuid', 'workspace_id', 'include_privileges']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_person" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_person`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'embed' in params:
            query_params.append(('embed', params['embed']))  # noqa: E501
        if 'include_deleted' in params:
            query_params.append(('includeDeleted', params['include_deleted']))  # noqa: E501
        if 'uuid' in params:
            query_params.append(('uuid', params['uuid']))  # noqa: E501
        if 'workspace_id' in params:
            query_params.append(('workspaceId', params['workspace_id']))  # noqa: E501
        if 'include_privileges' in params:
            query_params.append(('includePrivileges', params['include_privileges']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/iam/v1/people/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonReadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workspace_admins(self, workspace_id, **kwargs):  # noqa: E501
        """List workspace admins  # noqa: E501

        Retrieve a list of admins for the specified workspace, including their details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspace_admins(workspace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workspace_id: (required)
        :param str account_id: Account ID, enabling account admins to use this api
        :param str fields: Comma-Separated list of fields to return
        :param str include_status: include admins with one or both statuses of \"new\" and \"suspended\"
        :return: PersonList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workspace_admins_with_http_info(workspace_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workspace_admins_with_http_info(workspace_id, **kwargs)  # noqa: E501
            return data

    def list_workspace_admins_with_http_info(self, workspace_id, **kwargs):  # noqa: E501
        """List workspace admins  # noqa: E501

        Retrieve a list of admins for the specified workspace, including their details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspace_admins_with_http_info(workspace_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workspace_id: (required)
        :param str account_id: Account ID, enabling account admins to use this api
        :param str fields: Comma-Separated list of fields to return
        :param str include_status: include admins with one or both statuses of \"new\" and \"suspended\"
        :return: PersonList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'account_id', 'fields', 'include_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspace_admins" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params or
                params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `list_workspace_admins`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']  # noqa: E501

        query_params = []
        if 'account_id' in params:
            query_params.append(('accountId', params['account_id']))  # noqa: E501
        if 'fields' in params:
            query_params.append(('fields', params['fields']))  # noqa: E501
        if 'include_status' in params:
            query_params.append(('includeStatus', params['include_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/iam/v1/workspaces/{workspaceId}/admins', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
