# coding: utf-8

"""
    Identity and Access Managment (IAM) (Alpha)

 

    OpenAPI spec version: v2024.14.0
     
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from  src.client.api.api_client import ApiClient


class WorkspaceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
     
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_configuration_for_workspace(self, id, **kwargs):  # noqa: E501
        """Get workspace configuration  # noqa: E501

        Retrieve the configuration for the specified workspace.  Settings set to `null` use the default configuration.  You can filter the configuration by a specific key using the `key` query parameter:  ``` /v4/workspaces/:id/configuration?key=outputFormats.JSON [{ \"key\": \"outputFormats.JSON\", \"value\": true }] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_for_workspace(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str key:
        :return: GenericJsonResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_configuration_for_workspace_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_configuration_for_workspace_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_configuration_for_workspace_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get workspace configuration  # noqa: E501

        Retrieve the configuration for the specified workspace.  Settings set to `null` use the default configuration.  You can filter the configuration by a specific key using the `key` query parameter:  ``` /v4/workspaces/:id/configuration?key=outputFormats.JSON [{ \"key\": \"outputFormats.JSON\", \"value\": true }] ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_configuration_for_workspace_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param str key:
        :return: GenericJsonResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'key']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_configuration_for_workspace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_configuration_for_workspace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'key' in params:
            query_params.append(('key', params['key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/iam/v1/workspaces/{id}/configuration', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GenericJsonResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workspace_users(self, id, **kwargs):  # noqa: E501
        """List workspace users  # noqa: E501

        Retrieve a list of users for the specified workspace, including their details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspace_users(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Status status: Status values to filter the list
        :param bool include_privileges: Include the user's maximal privileges and authorization roles
        :param Roles roles: Roles values to filter the list
        :param ExcludingRoles excluding_roles: Excluded roles to filter the list
        :param int limit: Maximum number of objects to fetch.
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :param str account_id: Account ID, enabling account admins to use this api
        :return: PersonReadResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_workspace_users_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_workspace_users_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def list_workspace_users_with_http_info(self, id, **kwargs):  # noqa: E501
        """List workspace users  # noqa: E501

        Retrieve a list of users for the specified workspace, including their details.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workspace_users_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: (required)
        :param Status status: Status values to filter the list
        :param bool include_privileges: Include the user's maximal privileges and authorization roles
        :param Roles roles: Roles values to filter the list
        :param ExcludingRoles excluding_roles: Excluded roles to filter the list
        :param int limit: Maximum number of objects to fetch.
        :param int offset: Offset after which to start returning objects. For use with `limit`.
        :param str filter_type: Defined the filter type, one of [\"fuzzy\", \"contains\", \"exact\", \"exactIgnoreCase\"]. For use with `filter`.
        :param str sort: Defines sort order for returned objects
        :param str filter_fields: comma-separated list of fields to match the `filter` parameter against.
        :param str filter: Value for filtering objects. See `filterFields`.
        :param bool include_count: If includeCount is true, it will include the total number of objects as a count object in the response
        :param str account_id: Account ID, enabling account admins to use this api
        :return: PersonReadResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'status', 'include_privileges', 'roles', 'excluding_roles', 'limit', 'offset', 'filter_type', 'sort', 'filter_fields', 'filter', 'include_count', 'account_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workspace_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `list_workspace_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'include_privileges' in params:
            query_params.append(('includePrivileges', params['include_privileges']))  # noqa: E501
        if 'roles' in params:
            query_params.append(('roles', params['roles']))  # noqa: E501
        if 'excluding_roles' in params:
            query_params.append(('excludingRoles', params['excluding_roles']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'filter_type' in params:
            query_params.append(('filterType', params['filter_type']))  # noqa: E501
        if 'sort' in params:
            query_params.append(('sort', params['sort']))  # noqa: E501
        if 'filter_fields' in params:
            query_params.append(('filterFields', params['filter_fields']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'include_count' in params:
            query_params.append(('includeCount', params['include_count']))  # noqa: E501
        if 'account_id' in params:
            query_params.append(('accountId', params['account_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/iam/v1/workspaces/{id}/people', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PersonReadResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read_current_workspace(self, **kwargs):  # noqa: E501
        """Read current workspace  # noqa: E501

        Get information about the current workspace.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_current_workspace(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.read_current_workspace_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.read_current_workspace_with_http_info(**kwargs)  # noqa: E501
            return data

    def read_current_workspace_with_http_info(self, **kwargs):  # noqa: E501
        """Read current workspace  # noqa: E501

        Get information about the current workspace.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_current_workspace_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read_current_workspace" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/iam/v1/workspaces/current', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workspace',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
