from .meta_column import MetaColumn as MetaColumn
from .meta_foreign import MetaForeignColumn as MetaForeignColumn
from .meta_init_file import MetaInitFile as MetaInitFile
from dataclasses import dataclass
from sqlalchemy import inspect as inspect

@dataclass
class MetaTable:
    enum_fields = ...
    inspector = ...
    schema_name = ...
    support_schema = ...
    table_or_view_name = ...
    file_name = ...
    class_name = ...
    child_columns: list[MetaForeignColumn] = ...
    parent_columns: list[MetaForeignColumn] = ...
    base_columns: list[MetaColumn] = ...
    database_columns: list[MetaColumn] = ...
    response_columns: list[MetaColumn] = ...
    comment: str = ...
    generated_date: str = ...
    entity_imports: list[str] = ...
    init_file = ...
    table_args: str = ...
    def __init__(
        self,
        *,
        inspector: inspect,
        table_or_view_name,
        schema_name,
        default_schema_name,
        support_schema,
        table_foreign_keys,
        enum_fields,
    ) -> None: ...
    def get_database_columns(self) -> list[MetaColumn]: ...
    def get_base_columns(self) -> list[MetaColumn]: ...
    def get_response_columns(self) -> list[MetaColumn]: ...
    def get_columns(self) -> list[MetaColumn]: ...
    @staticmethod
    def get_sa_type(column_type, is_primary: bool) -> str:
        """根据 column_type 类型获取 sql_type 对应的 SQLAlchemy 作为sa_type 给SQLModel"""
    def get_comment(self): ...
    def get_import_shudaodao_core(self) -> str: ...
    def get_import_sqlmodel(self): ...
