#!/usr/bin/env python3
# -*- coding:utf-8 -*-
# @License  ：(C)Copyright 2025, 数道智融科技
# @Author   ：Shudaodao Auto Generator
# @Software ：PyCharm
# @Desc     ：SQLModel classes for shudaodao_meta.gen_table

from datetime import datetime
from typing import TYPE_CHECKING, Optional

from sqlalchemy import BigInteger, Text, Boolean

from shudaodao_core import Field, get_primary_id, Relationship
from shudaodao_core import SQLModel, BaseResponse
from ... import RegistryModel, get_table_schema, get_foreign_schema

if TYPE_CHECKING:
    from .gen_schema import GenSchema
    from .gen_column import GenColumn
    from .gen_relationship import GenRelationship


class GenTable(RegistryModel, table=True):
    """ 数据库对象模型 """
    __tablename__ = "gen_table"
    __table_args__ = {"schema": get_table_schema(), "comment": "表元数据"}
    # 非数据库字段：仅用于内部处理
    __database_schema__ = "shudaodao_meta"
    # 数据库字段
    table_id: int = Field(
        default_factory=get_primary_id, primary_key=True, sa_type=BigInteger, description="内码"
    )
    schema_id: int = Field(
        sa_type=BigInteger, description="架构内码", foreign_key=f"{get_foreign_schema()}gen_schema.schema_id"
    )
    table_name: str = Field(max_length=255, description="表名字")
    comment: Optional[str] = Field(default=None, nullable=True, sa_type=Text, description="备注")
    class_name: Optional[str] = Field(default=None, max_length=50, nullable=True, description="类名")
    is_active: bool = Field(sa_type=Boolean, description="启用状态")
    sort_order: int = Field(default=10, description="排序权重")
    description: Optional[str] = Field(default=None, max_length=500, nullable=True, description="描述")
    create_by: Optional[str] = Field(default=None, max_length=50, nullable=True, description="创建人")
    create_at: Optional[datetime] = Field(
        default_factory=lambda: datetime.now().replace(microsecond=0), nullable=True, description="创建日期"
    )
    update_by: Optional[str] = Field(default=None, max_length=50, nullable=True, description="修改人")
    update_at: Optional[datetime] = Field(
        default_factory=lambda: datetime.now().replace(microsecond=0), nullable=True, description="修改日期"
    )
    # 反向关系 -> 父对象
    Schema: "GenSchema" = Relationship(back_populates="GenTables")
    # 正向关系 -> 子对象
    GenColumns: list["GenColumn"] = Relationship(
        back_populates="Table", sa_relationship_kwargs={
            "order_by": "GenColumn.sort_order.asc()"
        }
    )
    GenRelationships: list["GenRelationship"] = Relationship(
        back_populates="Table", sa_relationship_kwargs={
            "order_by": "GenRelationship.sort_order.asc()"
        }
    )


class GenTableBase(SQLModel):
    """ 创建、更新模型 共用字段 """
    schema_id: int = Field(sa_type=BigInteger, description="架构内码")
    table_name: str = Field(max_length=255, description="表名字")
    comment: Optional[str] = Field(default=None, description="备注")
    class_name: Optional[str] = Field(default=None, max_length=50, description="类名")
    is_active: bool = Field(description="启用状态")
    sort_order: int = Field(default=10, description="排序权重")
    description: Optional[str] = Field(default=None, max_length=500, description="描述")


class GenTableCreate(GenTableBase):
    """ 前端创建模型 - 用于接口请求 """
    ...


class GenTableUpdate(GenTableBase):
    """ 前端更新模型 - 用于接口请求 """
    ...


class GenTableResponse(BaseResponse):
    """ 前端响应模型 - 用于接口响应 """
    __database_schema__ = "shudaodao_meta"  # 仅用于内部处理

    table_id: int = Field(description="内码", sa_type=BigInteger)
    schema_id: int = Field(description="架构内码", sa_type=BigInteger)
    table_name: str = Field(description="表名字")
    comment: Optional[str] = Field(description="备注", default=None)
    class_name: Optional[str] = Field(description="类名", default=None)
    is_active: bool = Field(description="启用状态")
    sort_order: int = Field(description="排序权重")
    description: Optional[str] = Field(description="描述", default=None)
    create_by: Optional[str] = Field(description="创建人", default=None)
    create_at: Optional[datetime] = Field(description="创建日期", default=None)
    update_by: Optional[str] = Field(description="修改人", default=None)
    update_at: Optional[datetime] = Field(description="修改日期", default=None)
