from http import HTTPStatus
from typing import Any, Optional, Union, cast

import httpx

from ...client import AuthenticatedClient, Client
from ...types import Response, UNSET
from ... import errors

from ...models.batch_upsert_result import BatchUpsertResult
from ...models.http_validation_problem_details import HttpValidationProblemDetails
from ...models.upsert_records_by_external_uri_command import UpsertRecordsByExternalUriCommand
from typing import cast



def _get_kwargs(
    *,
    body: UpsertRecordsByExternalUriCommand,

) -> dict[str, Any]:
    headers: dict[str, Any] = {}


    

    

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": "/api/Records/external/batch",
    }

    _kwargs["json"] = body.to_dict()


    headers["Content-Type"] = "application/json"

    _kwargs["headers"] = headers
    return _kwargs



def _parse_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Optional[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    if response.status_code == 202:
        response_202 = BatchUpsertResult.from_dict(response.json())



        return response_202

    if response.status_code == 400:
        response_400 = HttpValidationProblemDetails.from_dict(response.json())



        return response_400

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Response[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    body: UpsertRecordsByExternalUriCommand,

) -> Response[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    """ 
    Args:
        body (UpsertRecordsByExternalUriCommand):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[BatchUpsertResult, HttpValidationProblemDetails]]
     """


    kwargs = _get_kwargs(
        body=body,

    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)

def sync(
    *,
    client: Union[AuthenticatedClient, Client],
    body: UpsertRecordsByExternalUriCommand,

) -> Optional[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    """ 
    Args:
        body (UpsertRecordsByExternalUriCommand):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[BatchUpsertResult, HttpValidationProblemDetails]
     """


    return sync_detailed(
        client=client,
body=body,

    ).parsed

async def asyncio_detailed(
    *,
    client: Union[AuthenticatedClient, Client],
    body: UpsertRecordsByExternalUriCommand,

) -> Response[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    """ 
    Args:
        body (UpsertRecordsByExternalUriCommand):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[BatchUpsertResult, HttpValidationProblemDetails]]
     """


    kwargs = _get_kwargs(
        body=body,

    )

    response = await client.get_async_httpx_client().request(
        **kwargs
    )

    return _build_response(client=client, response=response)

async def asyncio(
    *,
    client: Union[AuthenticatedClient, Client],
    body: UpsertRecordsByExternalUriCommand,

) -> Optional[Union[BatchUpsertResult, HttpValidationProblemDetails]]:
    """ 
    Args:
        body (UpsertRecordsByExternalUriCommand):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[BatchUpsertResult, HttpValidationProblemDetails]
     """


    return (await asyncio_detailed(
        client=client,
body=body,

    )).parsed
