from http import HTTPStatus
from typing import Any, Optional, Union, cast

import httpx

from ...client import AuthenticatedClient, Client
from ...types import Response, UNSET
from ... import errors

from ...models.http_validation_problem_details import HttpValidationProblemDetails
from typing import cast



def _get_kwargs(
    user_id: str,
    mini_id: int,

) -> dict[str, Any]:
    

    

    

    _kwargs: dict[str, Any] = {
        "method": "post",
        "url": "/api/Users/{user_id}/minis/{mini_id}".format(user_id=user_id,mini_id=mini_id,),
    }


    return _kwargs



def _parse_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Optional[Union[Any, HttpValidationProblemDetails]]:
    if response.status_code == 204:
        response_204 = cast(Any, None)
        return response_204

    if response.status_code == 400:
        response_400 = HttpValidationProblemDetails.from_dict(response.json())



        return response_400

    if response.status_code == 404:
        response_404 = cast(Any, None)
        return response_404

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Union[AuthenticatedClient, Client], response: httpx.Response) -> Response[Union[Any, HttpValidationProblemDetails]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_id: str,
    mini_id: int,
    *,
    client: Union[AuthenticatedClient, Client],

) -> Response[Union[Any, HttpValidationProblemDetails]]:
    """ 
    Args:
        user_id (str):
        mini_id (int):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, HttpValidationProblemDetails]]
     """


    kwargs = _get_kwargs(
        user_id=user_id,
mini_id=mini_id,

    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)

def sync(
    user_id: str,
    mini_id: int,
    *,
    client: Union[AuthenticatedClient, Client],

) -> Optional[Union[Any, HttpValidationProblemDetails]]:
    """ 
    Args:
        user_id (str):
        mini_id (int):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, HttpValidationProblemDetails]
     """


    return sync_detailed(
        user_id=user_id,
mini_id=mini_id,
client=client,

    ).parsed

async def asyncio_detailed(
    user_id: str,
    mini_id: int,
    *,
    client: Union[AuthenticatedClient, Client],

) -> Response[Union[Any, HttpValidationProblemDetails]]:
    """ 
    Args:
        user_id (str):
        mini_id (int):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, HttpValidationProblemDetails]]
     """


    kwargs = _get_kwargs(
        user_id=user_id,
mini_id=mini_id,

    )

    response = await client.get_async_httpx_client().request(
        **kwargs
    )

    return _build_response(client=client, response=response)

async def asyncio(
    user_id: str,
    mini_id: int,
    *,
    client: Union[AuthenticatedClient, Client],

) -> Optional[Union[Any, HttpValidationProblemDetails]]:
    """ 
    Args:
        user_id (str):
        mini_id (int):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, HttpValidationProblemDetails]
     """


    return (await asyncio_detailed(
        user_id=user_id,
mini_id=mini_id,
client=client,

    )).parsed
