"""Change Asset.with_consent to Asset.consent_status

Revision ID: 3b0f4905378c
Revises: 641f6bcd424f
Create Date: 2025-07-01 15:17:32.542511

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "3b0f4905378c"
down_revision = "641f6bcd424f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute(
        "create type consentstatus as enum ('with_consent', 'without_consent', 'exempt', 'unknown')"
    )
    op.add_column(
        "asset",
        sa.Column(
            "consent_status",
            sa.Enum(
                name="consentstatus",
            ),
            server_default="unknown",
            nullable=False,
        ),
    )
    op.drop_column("asset", "with_consent")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "asset",
        sa.Column("with_consent", sa.BOOLEAN(), autoincrement=False, nullable=False),
    )
    op.drop_column("asset", "consent_status")
    op.execute("drop type if exists consentstatus")
    # ### end Alembic commands ###
