"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromServiceAtrributes = void 0;
const core_1 = require("@aws-cdk/core");
function fromServiceAtrributes(scope, id, attrs) {
    if ((attrs.serviceArn && attrs.serviceName) || (!attrs.serviceArn && !attrs.serviceName)) {
        throw new Error('You can only specify either serviceArn or serviceName.');
    }
    const stack = core_1.Stack.of(scope);
    let name;
    let arn;
    if (attrs.serviceName) {
        name = attrs.serviceName;
        arn = stack.formatArn({
            partition: stack.partition,
            service: 'ecs',
            region: stack.region,
            account: stack.account,
            resource: 'service',
            resourceName: name,
        });
    }
    else {
        arn = attrs.serviceArn;
        name = stack.parseArn(arn).resourceName;
    }
    class Import extends core_1.Resource {
        constructor() {
            super(...arguments);
            this.serviceArn = arn;
            this.serviceName = name;
            this.cluster = attrs.cluster;
        }
    }
    return new Import(scope, id);
}
exports.fromServiceAtrributes = fromServiceAtrributes;
//# sourceMappingURL=data:application/json;base64,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