"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TaskDefinition = void 0;
const core_1 = require("@aws-cdk/core");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.taskDefinitionArn = ec2TaskDefinitionArn;
                this.compatibility = task_definition_1.Compatibility.EC2;
                this.isEc2Compatible = true;
                this.isFargateCompatible = false;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
//# sourceMappingURL=data:application/json;base64,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