"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssetImage = void 0;
const aws_ecr_assets_1 = require("@aws-cdk/aws-ecr-assets");
const container_image_1 = require("../container-image");
/**
 * An image that will be built from a local directory with a Dockerfile
 */
class AssetImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the AssetImage class.
     *
     * @param directory The directory containing the Dockerfile
     */
    constructor(directory, props = {}) {
        super();
        this.directory = directory;
        this.props = props;
    }
    bind(scope, containerDefinition) {
        const asset = new aws_ecr_assets_1.DockerImageAsset(scope, 'AssetImage', {
            directory: this.directory,
            ...this.props,
        });
        asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: asset.imageUri,
        };
    }
}
exports.AssetImage = AssetImage;
//# sourceMappingURL=data:application/json;base64,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