"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLogDriver = void 0;
const logs = require("@aws-cdk/aws-logs");
const core_1 = require("@aws-cdk/core");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to CloudWatch Logs.
 */
class AwsLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the AwsLogDriver class.
     *
     * @param props the awslogs log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.logGroup && props.logRetention) {
            throw new Error('Cannot specify both `logGroup` and `logRetentionDays`.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(scope, containerDefinition) {
        this.logGroup = this.props.logGroup || new logs.LogGroup(scope, 'LogGroup', {
            retention: this.props.logRetention || Infinity,
        });
        this.logGroup.grantWrite(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            logDriver: 'awslogs',
            options: utils_1.removeEmpty({
                'awslogs-group': this.logGroup.logGroupName,
                'awslogs-stream-prefix': this.props.streamPrefix,
                'awslogs-region': core_1.Stack.of(containerDefinition).region,
                'awslogs-datetime-format': this.props.datetimeFormat,
                'awslogs-multiline-pattern': this.props.multilinePattern,
            }),
        };
    }
}
exports.AwsLogDriver = AwsLogDriver;
//# sourceMappingURL=data:application/json;base64,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