"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentdLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
//# sourceMappingURL=data:application/json;base64,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