"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileLogDriver = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
//# sourceMappingURL=data:application/json;base64,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