"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDriver = void 0;
const aws_log_driver_1 = require("./aws-log-driver");
/**
 * The base class for log drivers.
 */
class LogDriver {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        return new aws_log_driver_1.AwsLogDriver(props);
    }
}
exports.LogDriver = LogDriver;
//# sourceMappingURL=data:application/json;base64,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