"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SplunkLogDriver = exports.SplunkLogFormat = void 0;
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * Log Message Format
 */
var SplunkLogFormat;
(function (SplunkLogFormat) {
    SplunkLogFormat["INLINE"] = "inline";
    SplunkLogFormat["JSON"] = "json";
    SplunkLogFormat["RAW"] = "raw";
})(SplunkLogFormat = exports.SplunkLogFormat || (exports.SplunkLogFormat = {}));
/**
 * A log driver that sends log information to splunk Logs.
 */
class SplunkLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SplunkLogDriver class.
     *
     * @param props the splunk log driver configuration options.
     */
    constructor(props) {
        super();
        this.props = props;
        if (props.gzipLevel) {
            utils_1.ensureInRange(props.gzipLevel, -1, 9);
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        return {
            logDriver: 'splunk',
            options: utils_1.stringifyOptions({
                'splunk-token': this.props.token,
                'splunk-url': this.props.url,
                'splunk-source': this.props.source,
                'splunk-sourcetype': this.props.sourceType,
                'splunk-index': this.props.index,
                'splunk-capath': this.props.caPath,
                'splunk-caname': this.props.caName,
                'splunk-insecureskipverify': this.props.insecureSkipVerify,
                'splunk-format': this.props.format,
                'splunk-verify-connection': this.props.verifyConnection,
                'splunk-gzip': this.props.gzip,
                'splunk-gzip-level': this.props.gzipLevel,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SplunkLogDriver = SplunkLogDriver;
//# sourceMappingURL=data:application/json;base64,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