"use strict";
const assert_1 = require("@aws-cdk/assert");
const ec2 = require("@aws-cdk/aws-ec2");
const elbv2 = require("@aws-cdk/aws-elasticloadbalancingv2");
const core_1 = require("@aws-cdk/core");
const ecs = require("../../lib");
// Test various cross-stack Cluster/Service/ALB scenario's
let app;
let stack1;
let stack2;
let cluster;
let service;
function expectIngress(stack) {
    assert_1.expect(stack).to(assert_1.haveResource('AWS::EC2::SecurityGroupIngress', {
        FromPort: 32768,
        ToPort: 65535,
        GroupId: { 'Fn::ImportValue': 'Stack1:ExportsOutputFnGetAttClusterDefaultAutoScalingGroupInstanceSecurityGroup1D15236AGroupIdEAB9C5E1' },
    }));
}
module.exports = {
    'setUp'(cb) {
        app = new core_1.App();
        stack1 = new core_1.Stack(app, 'Stack1');
        const vpc = new ec2.Vpc(stack1, 'Vpc');
        cluster = new ecs.Cluster(stack1, 'Cluster', {
            vpc,
            capacity: { instanceType: new ec2.InstanceType('t2.micro') },
        });
        stack2 = new core_1.Stack(app, 'Stack2');
        const taskDefinition = new ecs.Ec2TaskDefinition(stack2, 'TD');
        const container = taskDefinition.addContainer('Main', {
            image: ecs.ContainerImage.fromRegistry('asdf'),
            memoryLimitMiB: 512,
        });
        container.addPortMappings({ containerPort: 8000 });
        service = new ecs.Ec2Service(stack2, 'Service', {
            cluster,
            taskDefinition,
        });
        cb();
    },
    'ALB next to Service'(test) {
        // WHEN
        const lb = new elbv2.ApplicationLoadBalancer(stack2, 'ALB', { vpc: cluster.vpc });
        const listener = lb.addListener('listener', { port: 80 });
        listener.addTargets('target', {
            port: 80,
            targets: [service],
        });
        // THEN: it shouldn't throw due to cyclic dependencies
        assert_1.expect(stack2).to(assert_1.haveResource('AWS::ECS::Service'));
        expectIngress(stack2);
        test.done();
    },
    'ALB next to Cluster'(test) {
        // WHEN
        const lb = new elbv2.ApplicationLoadBalancer(stack1, 'ALB', { vpc: cluster.vpc });
        const listener = lb.addListener('listener', { port: 80 });
        listener.addTargets('target', {
            port: 80,
            targets: [service],
        });
        // THEN: it shouldn't throw due to cyclic dependencies
        assert_1.expect(stack2).to(assert_1.haveResource('AWS::ECS::Service'));
        expectIngress(stack2);
        test.done();
    },
    'ALB in its own stack'(test) {
        // WHEN
        const stack3 = new core_1.Stack(app, 'Stack3');
        const lb = new elbv2.ApplicationLoadBalancer(stack3, 'ALB', { vpc: cluster.vpc });
        const listener = lb.addListener('listener', { port: 80 });
        listener.addTargets('target', {
            port: 80,
            targets: [service],
        });
        // THEN: it shouldn't throw due to cyclic dependencies
        assert_1.expect(stack2).to(assert_1.haveResource('AWS::ECS::Service'));
        expectIngress(stack2);
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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