import { Test } from 'nodeunit';
declare const _default: {
    'When creating an EC2 Service': {
        'with only required properties set, it correctly sets default properties'(test: Test): void;
        'with custom cloudmap namespace'(test: Test): void;
        'with all properties set'(test: Test): void;
        'with multiple security groups, it correctly updates the cfn template'(test: Test): void;
        'throws when both securityGroup and securityGroups are supplied'(test: Test): void;
        'throws when task definition is not EC2 compatible'(test: Test): void;
        'ignore task definition and launch type if deployment controller is set to be EXTERNAL'(test: Test): void;
        'errors if daemon and desiredCount both specified'(test: Test): void;
        'errors if daemon and maximumPercent not 100'(test: Test): void;
        'errors if minimum not less than maximum'(test: Test): void;
        'Output does not contain DesiredCount if daemon mode is set'(test: Test): void;
        'errors if no container definitions'(test: Test): void;
        'sets daemon scheduling strategy'(test: Test): void;
        'with a TaskDefinition with Bridge network mode': {
            'it errors if vpcSubnets is specified'(test: Test): void;
            'it errors if assignPublicIp is true'(test: Test): void;
            'it errors if vpc subnets is provided'(test: Test): void;
            'it errors if security group is provided'(test: Test): void;
            'it errors if multiple security groups is provided'(test: Test): void;
        };
        'with a TaskDefinition with AwsVpc network mode': {
            'it creates a security group for the service'(test: Test): void;
            'it allows vpcSubnets'(test: Test): void;
        };
        'with distinctInstance placement constraint'(test: Test): void;
        'with memberOf placement constraints'(test: Test): void;
        'with spreadAcross container instances strategy'(test: Test): void;
        'with spreadAcross placement strategy'(test: Test): void;
        'can turn PlacementStrategy into json format'(test: Test): void;
        'can turn PlacementConstraints into json format'(test: Test): void;
        'errors when spreadAcross with no input'(test: Test): void;
        'errors with spreadAcross placement strategy if daemon specified'(test: Test): void;
        'with no placement constraints'(test: Test): void;
        'with both propagateTags and propagateTaskTagsFrom defined'(test: Test): void;
        'with no placement strategy if daemon specified'(test: Test): void;
        'with random placement strategy'(test: Test): void;
        'errors with random placement strategy if daemon specified'(test: Test): void;
        'with packedbyCpu placement strategy'(test: Test): void;
        'with packedbyMemory placement strategy'(test: Test): void;
        'with packedBy placement strategy'(test: Test): void;
        'errors with packedBy placement strategy if daemon specified'(test: Test): void;
    };
    attachToClassicLB: {
        'allows network mode of task definition to be host'(test: Test): void;
        'allows network mode of task definition to be bridge'(test: Test): void;
        'throws when network mode of task definition is AwsVpc'(test: Test): void;
        'throws when network mode of task definition is none'(test: Test): void;
    };
    attachToApplicationTargetGroup: {
        'allows network mode of task definition to be other than none'(test: Test): void;
        'throws when network mode of task definition is none'(test: Test): void;
        'correctly setting ingress and egress port': {
            'with bridge/NAT network mode and 0 host port'(test: Test): void;
            'with bridge/NAT network mode and host port other than 0'(test: Test): void;
            'with host network mode'(test: Test): void;
            'with aws_vpc network mode'(test: Test): void;
        };
    };
    attachToNetworkTargetGroup: {
        'allows network mode of task definition to be other than none'(test: Test): void;
        'throws when network mode of task definition is none'(test: Test): void;
    };
    'classic ELB': {
        'can attach to classic ELB'(test: Test): void;
        'can attach any container and port as a target'(test: Test): void;
    };
    'When enabling service discovery': {
        'throws if namespace has not been added to cluster'(test: Test): void;
        'throws if network mode is none'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with bridge network mode'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with host network mode'(test: Test): void;
        'throws if wrong DNS record type specified with bridge network mode'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with AwsVpc network mode'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with AwsVpc network mode with SRV records'(test: Test): void;
    };
    Metric(test: Test): void;
    'When import an EC2 Service': {
        'with serviceArn'(test: Test): void;
        'with serviceName'(test: Test): void;
        'throws an exception if both serviceArn and serviceName were provided for fromEc2ServiceAttributes'(test: Test): void;
        'throws an exception if neither serviceArn nor serviceName were provided for fromEc2ServiceAttributes'(test: Test): void;
    };
};
export = _default;
