import { Test } from 'nodeunit';
declare const _default: {
    'When creating a Fargate Service': {
        'with only required properties set, it correctly sets default properties'(test: Test): void;
        'can create service with default settings if VPC only has public subnets'(test: Test): void;
        'with custom cloudmap namespace'(test: Test): void;
        'with all properties set'(test: Test): void;
        'throws when task definition is not Fargate compatible'(test: Test): void;
        'ignore task definition and launch type if deployment controller is set to be EXTERNAL'(test: Test): void;
        'errors when no container specified on task definition'(test: Test): void;
        'allows specifying assignPublicIP as enabled'(test: Test): void;
        'allows specifying 0 for minimumHealthyPercent'(test: Test): void;
        'throws when securityGroup and securityGroups are supplied'(test: Test): void;
        'with multiple securty groups, it correctly updates cloudformation template'(test: Test): void;
    };
    'When setting up a health check': {
        'grace period is respected'(test: Test): void;
    };
    'When adding an app load balancer': {
        'allows auto scaling by ALB request per target'(test: Test): void;
        'allows auto scaling by ALB with new service arn format'(test: Test): void;
        'allows specify any existing container name and port in a service': {
            'with default setting'(test: Test): void;
            'with TCP protocol'(test: Test): void;
            'with UDP protocol'(test: Test): void;
            'throws when protocol does not match'(test: Test): void;
            'throws when port does not match'(test: Test): void;
            'throws when container does not exist'(test: Test): void;
        };
        'allows load balancing to any container and port of service': {
            'with application load balancers': {
                'with default target group port and protocol'(test: Test): void;
                'with default target group port and HTTP protocol'(test: Test): void;
                'with default target group port and HTTPS protocol'(test: Test): void;
                'with any target group port and protocol'(test: Test): void;
            };
            'with network load balancers': {
                'with default target group port'(test: Test): void;
                'with any target group port'(test: Test): void;
            };
        };
    };
    'allows scaling on a specified scheduled time'(test: Test): void;
    'allows scaling on a specified metric value'(test: Test): void;
    'allows scaling on a target CPU utilization'(test: Test): void;
    'allows scaling on memory utilization'(test: Test): void;
    'allows scaling on custom CloudWatch metric'(test: Test): void;
    'When enabling service discovery': {
        'throws if namespace has not been added to cluster'(test: Test): void;
        'creates cloud map service for Private DNS namespace'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with SRV records with proper defaults'(test: Test): void;
        'creates AWS Cloud Map service for Private DNS namespace with SRV records with overriden defaults'(test: Test): void;
    };
    Metric(test: Test): void;
    'When import a Fargate Service': {
        'with serviceArn'(test: Test): void;
        'with serviceName'(test: Test): void;
        'throws an exception if both serviceArn and serviceName were provided for fromEc2ServiceAttributes'(test: Test): void;
        'throws an exception if neither serviceArn nor serviceName were provided for fromEc2ServiceAttributes'(test: Test): void;
    };
};
export = _default;
