import { Test } from 'nodeunit';
declare const _default: {
    'When creating a Task Definition': {
        'add a container using default props'(test: Test): void;
        'add a container using all props'(test: Test): void;
        'throws when MemoryLimit is less than MemoryReservationLimit'(test: Test): void;
        'With network mode AwsVpc': {
            'throws when Host port is different from container port'(test: Test): void;
            'Host port is the same as container port'(test: Test): void;
            'Host port can be empty '(test: Test): void;
        };
        'With network mode Host ': {
            'throws when Host port is different from container port'(test: Test): void;
            'when host port is the same as container port'(test: Test): void;
            'Host port can be empty '(test: Test): void;
            'errors when adding links'(test: Test): void;
        };
        'With network mode Bridge': {
            'when Host port is empty '(test: Test): void;
            'when Host port is not empty '(test: Test): void;
            'allows adding links'(test: Test): void;
        };
        'With network mode NAT': {
            'produces undefined CF networkMode property'(test: Test): void;
        };
    };
    'Container Port': {
        'should return the first container port in PortMappings'(test: Test): void;
        'throws when calling containerPort with no PortMappings'(test: Test): void;
    };
    'Ingress Port': {
        'With network mode AwsVpc': {
            'Ingress port should be the same as container port'(test: Test): void;
            'throws when calling ingressPort with no PortMappings'(test: Test): void;
        };
        'With network mode Host ': {
            'Ingress port should be the same as container port'(test: Test): void;
        };
        'With network mode Bridge': {
            'Ingress port should be the same as host port if supplied'(test: Test): void;
            'Ingress port should be 0 if not supplied'(test: Test): void;
        };
    };
    'can add environment variables to the container definition'(test: Test): void;
    'Given GPU count parameter': {
        'will add resource requirements to container definition'(test: Test): void;
    };
    'can add secret environment variables to the container definition'(test: Test): void;
    'use a specific secret JSON key as environment variable'(test: Test): void;
    'throws when using a specific secret JSON field as environment variable for a Fargate task'(test: Test): void;
    'can add AWS logging to container definition'(test: Test): void;
    'can set Health Check with defaults'(test: Test): void;
    'throws when setting Health Check with no commands'(test: Test): void;
    'can specify Health Check values in shell form'(test: Test): void;
    'can specify Health Check values in array form starting with CMD-SHELL'(test: Test): void;
    'can specify Health Check values in array form starting with CMD'(test: Test): void;
    'can specify private registry credentials'(test: Test): void;
    '_linkContainer works properly': {
        'when the props passed in is an essential container'(test: Test): void;
        'when the props passed in is not an essential container'(test: Test): void;
    };
    'Can specify linux parameters': {
        'with only required properties set, it correctly sets default properties'(test: Test): void;
        'before calling addContainer'(test: Test): void;
        'after calling addContainer'(test: Test): void;
        'with one or more host devices'(test: Test): void;
        'with the tmpfs mount for a container'(test: Test): void;
    };
    'can use a DockerImageAsset directly for a container image'(test: Test): void;
    'docker image asset options can be used when using container image'(test: Test): void;
};
export = _default;
