"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const ecs = require("../lib");
let stack;
let td;
const image = ecs.ContainerImage.fromRegistry('test-image');
module.exports = {
    'setUp'(cb) {
        stack = new cdk.Stack();
        td = new ecs.Ec2TaskDefinition(stack, 'TaskDefinition');
        cb();
    },
    'create a fluentd log driver with options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver({
                tag: 'hello',
            }),
            memoryLimitMiB: 128,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                        Options: {
                            tag: 'hello',
                        },
                    },
                },
            ],
        }));
        test.done();
    },
    'create a fluentd log driver without options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver(),
            memoryLimitMiB: 128,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                    },
                },
            ],
        }));
        test.done();
    },
    'create a fluentd log driver with all possible options'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: new ecs.FluentdLogDriver({
                address: 'localhost:24224',
                asyncConnect: true,
                bufferLimit: 128,
                retryWait: cdk.Duration.seconds(1),
                maxRetries: 4294967295,
                subSecondPrecision: false,
                tag: 'my-tag',
                labels: [
                    'one',
                    'two',
                    'three',
                ],
                env: [
                    'one',
                    'two',
                    'three',
                ],
                envRegex: '[0-9]{1}',
            }),
            memoryLimitMiB: 128,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                        Options: {
                            'fluentd-address': 'localhost:24224',
                            'fluentd-async-connect': 'true',
                            'fluentd-buffer-limit': '128',
                            'fluentd-retry-wait': '1',
                            'fluentd-max-retries': '4294967295',
                            'fluentd-sub-second-precision': 'false',
                            'tag': 'my-tag',
                            'labels': 'one,two,three',
                            'env': 'one,two,three',
                            'env-regex': '[0-9]{1}',
                        },
                    },
                },
            ],
        }));
        test.done();
    },
    'create a fluentd log driver using fluentd'(test) {
        // WHEN
        td.addContainer('Container', {
            image,
            logging: ecs.LogDrivers.fluentd(),
            memoryLimitMiB: 128,
        });
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::ECS::TaskDefinition', {
            ContainerDefinitions: [
                {
                    LogConfiguration: {
                        LogDriver: 'fluentd',
                    },
                },
            ],
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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