"""first migration.

Revision ID: 03a1d239e06e
Revises:
Create Date: 2024-01-10 20:08:09.823754

"""

from typing import Sequence, Union

import fastapi_users_db_sqlalchemy.generics
import sqlalchemy as sa
from alembic import op

import whombat.models.base

# revision identifiers, used by Alembic.
revision: str = "03a1d239e06e"
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "annotation_project",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column("annotation_instructions", sa.String(), nullable=True),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_annotation_project")),
        sa.UniqueConstraint("name", name=op.f("uq_annotation_project_name")),
        sa.UniqueConstraint("uuid", name=op.f("uq_annotation_project_uuid")),
    )
    op.create_table(
        "dataset",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("audio_dir", whombat.models.base.PathType(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_dataset")),
        sa.UniqueConstraint("audio_dir", name=op.f("uq_dataset_audio_dir")),
        sa.UniqueConstraint("name", name=op.f("uq_dataset_name")),
        sa.UniqueConstraint("uuid", name=op.f("uq_dataset_uuid")),
    )
    op.create_table(
        "evaluation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("task", sa.String(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_evaluation")),
        sa.UniqueConstraint("uuid", name=op.f("uq_evaluation_uuid")),
    )
    op.create_table(
        "evaluation_set",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column("task", sa.String(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_evaluation_set")),
        sa.UniqueConstraint("name", name=op.f("uq_evaluation_set_name")),
        sa.UniqueConstraint("uuid", name=op.f("uq_evaluation_set_uuid")),
    )
    op.create_table(
        "feature_name",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_feature_name")),
        sa.UniqueConstraint("name", name=op.f("uq_feature_name_name")),
    )
    op.create_table(
        "model_run",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("name", sa.String(), nullable=False),
        sa.Column("version", sa.String(), nullable=False),
        sa.Column("description", sa.String(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_model_run")),
        sa.UniqueConstraint("name", "version", name=op.f("uq_model_run_name")),
        sa.UniqueConstraint("uuid", name=op.f("uq_model_run_uuid")),
    )
    op.create_table(
        "recording",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("hash", sa.String(), nullable=False),
        sa.Column("path", whombat.models.base.PathType(), nullable=False),
        sa.Column("duration", sa.Float(), nullable=False),
        sa.Column("samplerate", sa.Integer(), nullable=False),
        sa.Column("channels", sa.Integer(), nullable=False),
        sa.Column("date", sa.Date(), nullable=True),
        sa.Column("time", sa.Time(), nullable=True),
        sa.Column("latitude", sa.Float(), nullable=True),
        sa.Column("longitude", sa.Float(), nullable=True),
        sa.Column("time_expansion", sa.Float(), nullable=False),
        sa.Column("rights", sa.String(), nullable=True),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_recording")),
        sa.UniqueConstraint("uuid", name=op.f("uq_recording_uuid")),
    )
    op.create_index(
        op.f("ix_recording_hash"), "recording", ["hash"], unique=True
    )
    op.create_index(
        op.f("ix_recording_path"), "recording", ["path"], unique=True
    )
    op.create_table(
        "tag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("key", sa.String(), nullable=False),
        sa.Column("value", sa.String(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_tag")),
        sa.UniqueConstraint("key", "value", name=op.f("uq_tag_key")),
    )
    op.create_table(
        "user",
        sa.Column("email", sa.String(length=320), nullable=False),
        sa.Column("hashed_password", sa.String(length=1024), nullable=False),
        sa.Column("username", sa.String(), nullable=False),
        sa.Column(
            "id", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("name", sa.String(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("is_superuser", sa.Boolean(), nullable=False),
        sa.Column("is_verified", sa.Boolean(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_user")),
        sa.UniqueConstraint("username", name=op.f("uq_user_username")),
    )
    op.create_index(op.f("ix_user_email"), "user", ["email"], unique=True)
    op.create_table(
        "accesstoken",
        sa.Column("token", sa.String(length=43), nullable=False),
        sa.Column(
            "user_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=False,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name=op.f("fk_accesstoken_user_id_user"),
            ondelete="cascade",
        ),
        sa.PrimaryKeyConstraint("token", name=op.f("pk_accesstoken")),
    )
    op.create_table(
        "annotation_project_tag",
        sa.Column("annotation_project_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["annotation_project_id"],
            ["annotation_project.id"],
            name=op.f(
                "fk_annotation_project_tag_annotation_project_id_annotation_project"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_annotation_project_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint(
            "annotation_project_id",
            "tag_id",
            name=op.f("pk_annotation_project_tag"),
        ),
        sa.UniqueConstraint(
            "annotation_project_id",
            "tag_id",
            name=op.f("uq_annotation_project_tag_annotation_project_id"),
        ),
    )
    op.create_table(
        "clip",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("start_time", sa.Float(), nullable=False),
        sa.Column("end_time", sa.Float(), nullable=False),
        sa.Column("score", sa.Float(), nullable=True),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_clip_recording_id_recording"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip")),
        sa.UniqueConstraint(
            "recording_id",
            "start_time",
            "end_time",
            name=op.f("uq_clip_recording_id"),
        ),
        sa.UniqueConstraint("uuid", name=op.f("uq_clip_uuid")),
    )
    op.create_table(
        "dataset_recording",
        sa.Column("dataset_id", sa.Integer(), nullable=False),
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("path", whombat.models.base.PathType(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["dataset_id"],
            ["dataset.id"],
            name=op.f("fk_dataset_recording_dataset_id_dataset"),
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_dataset_recording_recording_id_recording"),
        ),
        sa.PrimaryKeyConstraint(
            "dataset_id", "recording_id", name=op.f("pk_dataset_recording")
        ),
        sa.UniqueConstraint(
            "dataset_id",
            "recording_id",
            "path",
            name=op.f("uq_dataset_recording_dataset_id"),
        ),
    )
    op.create_table(
        "evaluation_metric",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("evaluation_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_id"],
            ["evaluation.id"],
            name=op.f("fk_evaluation_metric_evaluation_id_evaluation"),
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f("fk_evaluation_metric_feature_name_id_feature_name"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_evaluation_metric")),
        sa.UniqueConstraint(
            "evaluation_id",
            "feature_name_id",
            name=op.f("uq_evaluation_metric_evaluation_id"),
        ),
    )
    op.create_table(
        "evaluation_set_model_run",
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("model_run_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_evaluation_set_model_run_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["model_run_id"],
            ["model_run.id"],
            name=op.f("fk_evaluation_set_model_run_model_run_id_model_run"),
        ),
        sa.PrimaryKeyConstraint(
            "evaluation_set_id",
            "model_run_id",
            name=op.f("pk_evaluation_set_model_run"),
        ),
        sa.UniqueConstraint(
            "evaluation_set_id",
            "model_run_id",
            name=op.f("uq_evaluation_set_model_run_evaluation_set_id"),
        ),
    )
    op.create_table(
        "evaluation_set_tag",
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_evaluation_set_tag_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_evaluation_set_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint(
            "evaluation_set_id", "tag_id", name=op.f("pk_evaluation_set_tag")
        ),
        sa.UniqueConstraint(
            "evaluation_set_id",
            "tag_id",
            name=op.f("uq_evaluation_set_tag_evaluation_set_id"),
        ),
    )
    op.create_table(
        "model_run_evaluation",
        sa.Column("model_run_id", sa.Integer(), nullable=False),
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("evaluation_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_id"],
            ["evaluation.id"],
            name=op.f("fk_model_run_evaluation_evaluation_id_evaluation"),
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_model_run_evaluation_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["model_run_id"],
            ["model_run.id"],
            name=op.f("fk_model_run_evaluation_model_run_id_model_run"),
        ),
        sa.PrimaryKeyConstraint(
            "model_run_id",
            "evaluation_set_id",
            "evaluation_id",
            name=op.f("pk_model_run_evaluation"),
        ),
        sa.UniqueConstraint(
            "model_run_id",
            "evaluation_set_id",
            name=op.f("uq_model_run_evaluation_model_run_id"),
        ),
    )
    op.create_table(
        "note",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("message", sa.String(), nullable=False),
        sa.Column(
            "created_by_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=True,
        ),
        sa.Column("is_issue", sa.Boolean(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name=op.f("fk_note_created_by_id_user"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_note")),
        sa.UniqueConstraint("uuid", name=op.f("uq_note_uuid")),
    )
    op.create_table(
        "recording_feature",
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f("fk_recording_feature_feature_name_id_feature_name"),
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_recording_feature_recording_id_recording"),
        ),
        sa.PrimaryKeyConstraint(
            "recording_id",
            "feature_name_id",
            name=op.f("pk_recording_feature"),
        ),
        sa.UniqueConstraint(
            "recording_id",
            "feature_name_id",
            name=op.f("uq_recording_feature_recording_id"),
        ),
    )
    op.create_table(
        "recording_owner",
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column(
            "user_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=False,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_recording_owner_recording_id_recording"),
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name=op.f("fk_recording_owner_user_id_user"),
        ),
        sa.PrimaryKeyConstraint(
            "recording_id", "user_id", name=op.f("pk_recording_owner")
        ),
        sa.UniqueConstraint(
            "recording_id",
            "user_id",
            name=op.f("uq_recording_owner_recording_id"),
        ),
    )
    op.create_table(
        "recording_tag",
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_recording_tag_recording_id_recording"),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"], ["tag.id"], name=op.f("fk_recording_tag_tag_id_tag")
        ),
        sa.PrimaryKeyConstraint(
            "recording_id", "tag_id", name=op.f("pk_recording_tag")
        ),
        sa.UniqueConstraint(
            "recording_id",
            "tag_id",
            name=op.f("uq_recording_tag_recording_id"),
        ),
    )
    op.create_table(
        "sound_event",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("geometry_type", sa.String(), nullable=False),
        sa.Column(
            "geometry", whombat.models.base.GeometryType(), nullable=False
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_sound_event_recording_id_recording"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_sound_event")),
    )
    op.create_table(
        "user_run",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column(
            "user_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=False,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["user_id"], ["user.id"], name=op.f("fk_user_run_user_id_user")
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_user_run")),
        sa.UniqueConstraint("uuid", name=op.f("uq_user_run_uuid")),
    )
    op.create_table(
        "clip_annotation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("clip_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_id"],
            ["clip.id"],
            name=op.f("fk_clip_annotation_clip_id_clip"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_annotation")),
        sa.UniqueConstraint("uuid", name=op.f("uq_clip_annotation_uuid")),
    )
    op.create_table(
        "clip_feature",
        sa.Column("clip_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_id"], ["clip.id"], name=op.f("fk_clip_feature_clip_id_clip")
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f("fk_clip_feature_feature_name_id_feature_name"),
        ),
        sa.PrimaryKeyConstraint(
            "clip_id", "feature_name_id", name=op.f("pk_clip_feature")
        ),
        sa.UniqueConstraint(
            "clip_id", "feature_name_id", name=op.f("uq_clip_feature_clip_id")
        ),
    )
    op.create_table(
        "clip_prediction",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("clip_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_id"],
            ["clip.id"],
            name=op.f("fk_clip_prediction_clip_id_clip"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_prediction")),
        sa.UniqueConstraint("uuid", name=op.f("uq_clip_prediction_uuid")),
    )
    op.create_table(
        "evaluation_set_user_run",
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("user_run_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_evaluation_set_user_run_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["user_run_id"],
            ["user_run.id"],
            name=op.f("fk_evaluation_set_user_run_user_run_id_user_run"),
        ),
        sa.PrimaryKeyConstraint(
            "evaluation_set_id",
            "user_run_id",
            name=op.f("pk_evaluation_set_user_run"),
        ),
        sa.UniqueConstraint(
            "evaluation_set_id",
            "user_run_id",
            name=op.f("uq_evaluation_set_user_run_evaluation_set_id"),
        ),
    )
    op.create_table(
        "recording_note",
        sa.Column("recording_id", sa.Integer(), nullable=False),
        sa.Column("note_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["note_id"],
            ["note.id"],
            name=op.f("fk_recording_note_note_id_note"),
        ),
        sa.ForeignKeyConstraint(
            ["recording_id"],
            ["recording.id"],
            name=op.f("fk_recording_note_recording_id_recording"),
        ),
        sa.PrimaryKeyConstraint(
            "recording_id", "note_id", name=op.f("pk_recording_note")
        ),
        sa.UniqueConstraint(
            "recording_id",
            "note_id",
            name=op.f("uq_recording_note_recording_id"),
        ),
    )
    op.create_table(
        "sound_event_feature",
        sa.Column("sound_event_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f("fk_sound_event_feature_feature_name_id_feature_name"),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_id"],
            ["sound_event.id"],
            name=op.f("fk_sound_event_feature_sound_event_id_sound_event"),
        ),
        sa.PrimaryKeyConstraint(
            "sound_event_id",
            "feature_name_id",
            name=op.f("pk_sound_event_feature"),
        ),
        sa.UniqueConstraint(
            "sound_event_id",
            "feature_name_id",
            name=op.f("uq_sound_event_feature_sound_event_id"),
        ),
    )
    op.create_table(
        "user_run_evaluation",
        sa.Column("user_run_id", sa.Integer(), nullable=False),
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("evaluation_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_id"],
            ["evaluation.id"],
            name=op.f("fk_user_run_evaluation_evaluation_id_evaluation"),
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_user_run_evaluation_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["user_run_id"],
            ["user_run.id"],
            name=op.f("fk_user_run_evaluation_user_run_id_user_run"),
        ),
        sa.PrimaryKeyConstraint(
            "user_run_id",
            "evaluation_set_id",
            "evaluation_id",
            name=op.f("pk_user_run_evaluation"),
        ),
        sa.UniqueConstraint(
            "user_run_id",
            "evaluation_set_id",
            name=op.f("uq_user_run_evaluation_user_run_id"),
        ),
    )
    op.create_table(
        "annotation_task",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("annotation_project_id", sa.Integer(), nullable=False),
        sa.Column("clip_id", sa.Integer(), nullable=False),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=True),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["annotation_project_id"],
            ["annotation_project.id"],
            name=op.f(
                "fk_annotation_task_annotation_project_id_annotation_project"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f("fk_annotation_task_clip_annotation_id_clip_annotation"),
        ),
        sa.ForeignKeyConstraint(
            ["clip_id"],
            ["clip.id"],
            name=op.f("fk_annotation_task_clip_id_clip"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_annotation_task")),
        sa.UniqueConstraint(
            "annotation_project_id",
            "clip_id",
            name=op.f("uq_annotation_task_annotation_project_id"),
        ),
        sa.UniqueConstraint("uuid", name=op.f("uq_annotation_task_uuid")),
    )
    op.create_table(
        "clip_annotation_note",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=False),
        sa.Column("note_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f(
                "fk_clip_annotation_note_clip_annotation_id_clip_annotation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["note_id"],
            ["note.id"],
            name=op.f("fk_clip_annotation_note_note_id_note"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_annotation_note")),
        sa.UniqueConstraint(
            "clip_annotation_id",
            "note_id",
            name=op.f("uq_clip_annotation_note_clip_annotation_id"),
        ),
    )
    op.create_table(
        "clip_annotation_tag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_by_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=True,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f(
                "fk_clip_annotation_tag_clip_annotation_id_clip_annotation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name=op.f("fk_clip_annotation_tag_created_by_id_user"),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_clip_annotation_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_annotation_tag")),
        sa.UniqueConstraint(
            "clip_annotation_id",
            "tag_id",
            "created_by_id",
            name=op.f("uq_clip_annotation_tag_clip_annotation_id"),
        ),
    )
    op.create_table(
        "clip_evaluation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("evaluation_id", sa.Integer(), nullable=False),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=False),
        sa.Column("clip_prediction_id", sa.Integer(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f("fk_clip_evaluation_clip_annotation_id_clip_annotation"),
        ),
        sa.ForeignKeyConstraint(
            ["clip_prediction_id"],
            ["clip_prediction.id"],
            name=op.f("fk_clip_evaluation_clip_prediction_id_clip_prediction"),
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_id"],
            ["evaluation.id"],
            name=op.f("fk_clip_evaluation_evaluation_id_evaluation"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_evaluation")),
        sa.UniqueConstraint(
            "clip_annotation_id",
            "clip_prediction_id",
            "evaluation_id",
            name=op.f("uq_clip_evaluation_clip_annotation_id"),
        ),
        sa.UniqueConstraint("uuid", name=op.f("uq_clip_evaluation_uuid")),
    )
    op.create_table(
        "clip_prediction_tag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("clip_prediction_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_prediction_id"],
            ["clip_prediction.id"],
            name=op.f(
                "fk_clip_prediction_tag_clip_prediction_id_clip_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_clip_prediction_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint(
            "id",
            "clip_prediction_id",
            "tag_id",
            name=op.f("pk_clip_prediction_tag"),
        ),
        sa.UniqueConstraint(
            "clip_prediction_id",
            "tag_id",
            name=op.f("uq_clip_prediction_tag_clip_prediction_id"),
        ),
    )
    op.create_table(
        "evaluation_set_annotation",
        sa.Column("evaluation_set_id", sa.Integer(), nullable=False),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f(
                "fk_evaluation_set_annotation_clip_annotation_id_clip_annotation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["evaluation_set_id"],
            ["evaluation_set.id"],
            name=op.f(
                "fk_evaluation_set_annotation_evaluation_set_id_evaluation_set"
            ),
        ),
        sa.PrimaryKeyConstraint(
            "evaluation_set_id",
            "clip_annotation_id",
            name=op.f("pk_evaluation_set_annotation"),
        ),
        sa.UniqueConstraint(
            "evaluation_set_id",
            "clip_annotation_id",
            name=op.f("uq_evaluation_set_annotation_evaluation_set_id"),
        ),
    )
    op.create_table(
        "model_run_prediction",
        sa.Column("model_run_id", sa.Integer(), nullable=False),
        sa.Column("clip_prediction_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_prediction_id"],
            ["clip_prediction.id"],
            name=op.f(
                "fk_model_run_prediction_clip_prediction_id_clip_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["model_run_id"],
            ["model_run.id"],
            name=op.f("fk_model_run_prediction_model_run_id_model_run"),
        ),
        sa.PrimaryKeyConstraint(
            "model_run_id",
            "clip_prediction_id",
            name=op.f("pk_model_run_prediction"),
        ),
        sa.UniqueConstraint(
            "model_run_id",
            "clip_prediction_id",
            name=op.f("uq_model_run_prediction_model_run_id"),
        ),
    )
    op.create_table(
        "sound_event_annotation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("clip_annotation_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_by_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=True,
        ),
        sa.Column("sound_event_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_annotation_id"],
            ["clip_annotation.id"],
            name=op.f(
                "fk_sound_event_annotation_clip_annotation_id_clip_annotation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name=op.f("fk_sound_event_annotation_created_by_id_user"),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_id"],
            ["sound_event.id"],
            name=op.f("fk_sound_event_annotation_sound_event_id_sound_event"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_sound_event_annotation")),
        sa.UniqueConstraint(
            "uuid", name=op.f("uq_sound_event_annotation_uuid")
        ),
    )
    op.create_table(
        "sound_event_prediction",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("sound_event_id", sa.Integer(), nullable=False),
        sa.Column("clip_prediction_id", sa.Integer(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_prediction_id"],
            ["clip_prediction.id"],
            name=op.f(
                "fk_sound_event_prediction_clip_prediction_id_clip_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_id"],
            ["sound_event.id"],
            name=op.f("fk_sound_event_prediction_sound_event_id_sound_event"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_sound_event_prediction")),
        sa.UniqueConstraint(
            "sound_event_id",
            "clip_prediction_id",
            name=op.f("uq_sound_event_prediction_sound_event_id"),
        ),
        sa.UniqueConstraint(
            "uuid", name=op.f("uq_sound_event_prediction_uuid")
        ),
    )
    op.create_table(
        "user_run_prediction",
        sa.Column("user_run_id", sa.Integer(), nullable=False),
        sa.Column("clip_prediction_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_prediction_id"],
            ["clip_prediction.id"],
            name=op.f(
                "fk_user_run_prediction_clip_prediction_id_clip_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["user_run_id"],
            ["user_run.id"],
            name=op.f("fk_user_run_prediction_user_run_id_user_run"),
        ),
        sa.PrimaryKeyConstraint(
            "user_run_id",
            "clip_prediction_id",
            name=op.f("pk_user_run_prediction"),
        ),
        sa.UniqueConstraint(
            "user_run_id",
            "clip_prediction_id",
            name=op.f("uq_user_run_prediction_user_run_id"),
        ),
    )
    op.create_table(
        "annotation_status_badge",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("annotation_task_id", sa.Integer(), nullable=False),
        sa.Column(
            "user_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=True,
        ),
        sa.Column(
            "state",
            sa.Enum(
                "assigned",
                "completed",
                "verified",
                "rejected",
                name="annotationstate",
            ),
            nullable=False,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["annotation_task_id"],
            ["annotation_task.id"],
            name=op.f(
                "fk_annotation_status_badge_annotation_task_id_annotation_task"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user.id"],
            name=op.f("fk_annotation_status_badge_user_id_user"),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_annotation_status_badge")),
        sa.UniqueConstraint(
            "annotation_task_id",
            "user_id",
            "state",
            name=op.f("uq_annotation_status_badge_annotation_task_id"),
        ),
    )
    op.create_table(
        "clip_evaluation_metric",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("clip_evaluation_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_evaluation_id"],
            ["clip_evaluation.id"],
            name=op.f(
                "fk_clip_evaluation_metric_clip_evaluation_id_clip_evaluation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f(
                "fk_clip_evaluation_metric_feature_name_id_feature_name"
            ),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_clip_evaluation_metric")),
        sa.UniqueConstraint(
            "clip_evaluation_id",
            "feature_name_id",
            name=op.f("uq_clip_evaluation_metric_clip_evaluation_id"),
        ),
    )
    op.create_table(
        "sound_event_annotation_note",
        sa.Column("sound_event_annotation_id", sa.Integer(), nullable=False),
        sa.Column("note_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["note_id"],
            ["note.id"],
            name=op.f("fk_sound_event_annotation_note_note_id_note"),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_annotation_id"],
            ["sound_event_annotation.id"],
            name=op.f(
                "fk_sound_event_annotation_note_sound_event_annotation_id_sound_event_annotation"
            ),
        ),
        sa.PrimaryKeyConstraint(
            "sound_event_annotation_id",
            "note_id",
            name=op.f("pk_sound_event_annotation_note"),
        ),
        sa.UniqueConstraint(
            "sound_event_annotation_id",
            "note_id",
            name=op.f(
                "uq_sound_event_annotation_note_sound_event_annotation_id"
            ),
        ),
    )
    op.create_table(
        "sound_event_annotation_tag",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("sound_event_annotation_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column(
            "created_by_id",
            fastapi_users_db_sqlalchemy.generics.GUID(),
            nullable=True,
        ),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["created_by_id"],
            ["user.id"],
            name=op.f("fk_sound_event_annotation_tag_created_by_id_user"),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_annotation_id"],
            ["sound_event_annotation.id"],
            name=op.f(
                "fk_sound_event_annotation_tag_sound_event_annotation_id_sound_event_annotation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_sound_event_annotation_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_sound_event_annotation_tag")
        ),
        sa.UniqueConstraint(
            "sound_event_annotation_id",
            "tag_id",
            "created_by_id",
            name=op.f(
                "uq_sound_event_annotation_tag_sound_event_annotation_id"
            ),
        ),
    )
    op.create_table(
        "sound_event_evaluation",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column(
            "uuid", fastapi_users_db_sqlalchemy.generics.GUID(), nullable=False
        ),
        sa.Column("clip_evaluation_id", sa.Integer(), nullable=False),
        sa.Column("source_id", sa.Integer(), nullable=True),
        sa.Column("target_id", sa.Integer(), nullable=True),
        sa.Column("affinity", sa.Float(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["clip_evaluation_id"],
            ["clip_evaluation.id"],
            name=op.f(
                "fk_sound_event_evaluation_clip_evaluation_id_clip_evaluation"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["source_id"],
            ["sound_event_prediction.id"],
            name=op.f(
                "fk_sound_event_evaluation_source_id_sound_event_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["target_id"],
            ["sound_event_annotation.id"],
            name=op.f(
                "fk_sound_event_evaluation_target_id_sound_event_annotation"
            ),
        ),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_sound_event_evaluation")),
        sa.UniqueConstraint(
            "uuid", name=op.f("uq_sound_event_evaluation_uuid")
        ),
    )
    op.create_table(
        "sound_event_prediction_tag",
        sa.Column("sound_event_prediction_id", sa.Integer(), nullable=False),
        sa.Column("tag_id", sa.Integer(), nullable=False),
        sa.Column("score", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_prediction_id"],
            ["sound_event_prediction.id"],
            name=op.f(
                "fk_sound_event_prediction_tag_sound_event_prediction_id_sound_event_prediction"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["tag_id"],
            ["tag.id"],
            name=op.f("fk_sound_event_prediction_tag_tag_id_tag"),
        ),
        sa.PrimaryKeyConstraint(
            "sound_event_prediction_id",
            "tag_id",
            name=op.f("pk_sound_event_prediction_tag"),
        ),
        sa.UniqueConstraint(
            "sound_event_prediction_id",
            "tag_id",
            name=op.f(
                "uq_sound_event_prediction_tag_sound_event_prediction_id"
            ),
        ),
    )
    op.create_table(
        "sound_event_evaluation_metric",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("sound_event_evaluation_id", sa.Integer(), nullable=False),
        sa.Column("feature_name_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Float(), nullable=False),
        sa.Column(
            "created_on",
            sa.DateTime().with_variant(
                sa.TIMESTAMP(timezone=True), "postgresql"
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["feature_name_id"],
            ["feature_name.id"],
            name=op.f(
                "fk_sound_event_evaluation_metric_feature_name_id_feature_name"
            ),
        ),
        sa.ForeignKeyConstraint(
            ["sound_event_evaluation_id"],
            ["sound_event_evaluation.id"],
            name=op.f(
                "fk_sound_event_evaluation_metric_sound_event_evaluation_id_sound_event_evaluation"
            ),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_sound_event_evaluation_metric")
        ),
        sa.UniqueConstraint(
            "sound_event_evaluation_id",
            "feature_name_id",
            name=op.f(
                "uq_sound_event_evaluation_metric_sound_event_evaluation_id"
            ),
        ),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("sound_event_evaluation_metric")
    op.drop_table("sound_event_prediction_tag")
    op.drop_table("sound_event_evaluation")
    op.drop_table("sound_event_annotation_tag")
    op.drop_table("sound_event_annotation_note")
    op.drop_table("clip_evaluation_metric")
    op.drop_table("annotation_status_badge")
    op.drop_table("user_run_prediction")
    op.drop_table("sound_event_prediction")
    op.drop_table("sound_event_annotation")
    op.drop_table("model_run_prediction")
    op.drop_table("evaluation_set_annotation")
    op.drop_table("clip_prediction_tag")
    op.drop_table("clip_evaluation")
    op.drop_table("clip_annotation_tag")
    op.drop_table("clip_annotation_note")
    op.drop_table("annotation_task")
    op.drop_table("user_run_evaluation")
    op.drop_table("sound_event_feature")
    op.drop_table("recording_note")
    op.drop_table("evaluation_set_user_run")
    op.drop_table("clip_prediction")
    op.drop_table("clip_feature")
    op.drop_table("clip_annotation")
    op.drop_table("user_run")
    op.drop_table("sound_event")
    op.drop_table("recording_tag")
    op.drop_table("recording_owner")
    op.drop_table("recording_feature")
    op.drop_table("note")
    op.drop_table("model_run_evaluation")
    op.drop_table("evaluation_set_tag")
    op.drop_table("evaluation_set_model_run")
    op.drop_table("evaluation_metric")
    op.drop_table("dataset_recording")
    op.drop_table("clip")
    op.drop_table("annotation_project_tag")
    op.drop_table("accesstoken")
    op.drop_index(op.f("ix_user_email"), table_name="user")
    op.drop_table("user")
    op.drop_table("tag")
    op.drop_index(op.f("ix_recording_path"), table_name="recording")
    op.drop_index(op.f("ix_recording_hash"), table_name="recording")
    op.drop_table("recording")
    op.drop_table("model_run")
    op.drop_table("feature_name")
    op.drop_table("evaluation_set")
    op.drop_table("evaluation")
    op.drop_table("dataset")
    op.drop_table("annotation_project")
    # ### end Alembic commands ###
