from arkparse.classes.equipment import Armor as ArmorBps
from arkparse.logging import ArkSaveLogger
_LOGGED_WARNINGS = set()

def _get_default_hypoT(bp: str):
    resistances = {
        ArmorBps.cloth.shirt: 8,
        ArmorBps.cloth.pants: 8,
        ArmorBps.cloth.helmet: 4,
        ArmorBps.cloth.boots: 5,
        ArmorBps.cloth.gloves: 5,
        ArmorBps.chitin.shirt: 10,
        ArmorBps.chitin.pants: 10,
        ArmorBps.chitin.helmet: 6,
        ArmorBps.chitin.boots: 7,
        ArmorBps.chitin.gloves: 7,
        ArmorBps.desert.shirt: 8,
        ArmorBps.desert.pants: 8,
        ArmorBps.desert.goggles: 5,
        ArmorBps.desert.boots: 5,
        ArmorBps.desert.gloves: 5,
        ArmorBps.fur.shirt: 65,
        ArmorBps.fur.pants: 65,
        ArmorBps.fur.helmet: 52,
        ArmorBps.fur.boots: 34,
        ArmorBps.fur.gloves: 34,
        ArmorBps.leather.shirt:20,
        ArmorBps.leather.pants: 20,
        ArmorBps.leather.helmet: 15,
        ArmorBps.leather.boots: 15,
        ArmorBps.leather.gloves: 15,
        ArmorBps.ghillie.shirt: 8,
        ArmorBps.ghillie.pants: 8,
        ArmorBps.ghillie.helmet: 4,
        ArmorBps.ghillie.boots: 2,
        ArmorBps.ghillie.gloves: 2,
        ArmorBps.riot.shirt: 15,
        ArmorBps.riot.pants: 15,
        ArmorBps.riot.helmet: 10,
        ArmorBps.riot.boots: 10,
        ArmorBps.riot.gloves: 10,
        ArmorBps.flak.shirt: 15,
        ArmorBps.flak.pants: 15,
        ArmorBps.flak.helmet: 10,
        ArmorBps.flak.boots: 10,
        ArmorBps.flak.gloves: 10,
        ArmorBps.tek.helmet: 5,
        ArmorBps.tek.shirt: 15,
        ArmorBps.tek.gloves: 10,
        ArmorBps.tek.boots: 10,
        ArmorBps.tek.pants: 15,
        ArmorBps.scuba.goggles: 15,
        ArmorBps.scuba.chest: 40,
        ArmorBps.scuba.flippers: 15,
        ArmorBps.scuba.pants: 200,
        ArmorBps.hazard.boots: 10,
        ArmorBps.hazard.gloves: 10,
        ArmorBps.hazard.helmet: 10,
        ArmorBps.hazard.pants: 10,
        ArmorBps.hazard.shirt: 10,
        ArmorBps.misc.gas_mask: 10,
        ArmorBps.misc.miners_helmet: 10,
        ArmorBps.misc.night_vision_goggles: 15,
    }

    if bp in resistances:
        return resistances[bp]
    else:
        if bp not in _LOGGED_WARNINGS:
            _LOGGED_WARNINGS.add(bp)
            ArkSaveLogger.warning_log(f"No hypothermal insulation found for armor {bp}, using default value of 0")
        return 0

def _get_default_hyperT(bp: str):
    resistances = {
        ArmorBps.cloth.shirt: 15,
        ArmorBps.cloth.pants: 15,
        ArmorBps.cloth.helmet: 15,
        ArmorBps.cloth.boots: 15,
        ArmorBps.cloth.gloves: 15,
        ArmorBps.chitin.shirt: -5,
        ArmorBps.chitin.pants: -5,
        ArmorBps.chitin.helmet: -5,
        ArmorBps.chitin.boots: -5,
        ArmorBps.chitin.gloves: -5,
        ArmorBps.desert.shirt: 25,
        ArmorBps.desert.pants: 25,
        ArmorBps.desert.goggles: 30,
        ArmorBps.desert.boots: 25,
        ArmorBps.desert.gloves: 25,
        ArmorBps.fur.shirt: -30,
        ArmorBps.fur.pants: -30,
        ArmorBps.fur.helmet: -25,
        ArmorBps.fur.boots: -10,
        ArmorBps.fur.gloves: -10,
        ArmorBps.leather.shirt: -5,
        ArmorBps.leather.pants: -5,
        ArmorBps.leather.helmet: -5,
        ArmorBps.leather.boots: -5,
        ArmorBps.leather.gloves: -5,
        ArmorBps.ghillie.shirt: 30,
        ArmorBps.ghillie.pants: 30,
        ArmorBps.ghillie.helmet: 35,
        ArmorBps.ghillie.boots: 30,
        ArmorBps.ghillie.gloves: 30,
        ArmorBps.riot.shirt: -10,
        ArmorBps.riot.pants: -10,
        ArmorBps.riot.helmet: -10,
        ArmorBps.riot.boots: -10,
        ArmorBps.riot.gloves: -10,
        ArmorBps.flak.shirt: -7,
        ArmorBps.flak.pants: -7,
        ArmorBps.flak.helmet: -3,
        ArmorBps.flak.boots: -4,
        ArmorBps.flak.gloves: -4,
        ArmorBps.tek.helmet: 30,
        ArmorBps.tek.shirt: -7,
        ArmorBps.tek.gloves: -4,
        ArmorBps.tek.boots: -4,
        ArmorBps.tek.pants: -7,
        ArmorBps.scuba.goggles: -5,
        ArmorBps.scuba.chest: -5,
        ArmorBps.scuba.flippers: -5,
        ArmorBps.scuba.pants: 0,
        ArmorBps.hazard.boots: 60,
        ArmorBps.hazard.gloves: 60,
        ArmorBps.hazard.helmet: 60,
        ArmorBps.hazard.pants: 60,
        ArmorBps.hazard.shirt: 60,
        ArmorBps.misc.gas_mask: -2.0,
        ArmorBps.misc.miners_helmet: -3,
        ArmorBps.misc.night_vision_goggles: -5,
    }

    if bp in resistances:
        return resistances[bp]
    else:
        if bp not in _LOGGED_WARNINGS:
            _LOGGED_WARNINGS.add(bp)
            ArkSaveLogger.warning_log(f"No hyperthermal insulation found for armor {bp}, using default value of 0")
        return 0