# Reference Documentation

This section provides comprehensive technical documentation for Xaibo's APIs, modules, and configuration options. The reference documentation is organized by component type and provides complete specifications for all available functionality.

## Documentation Structure

### Configuration Reference
- **[Agent Configuration](agent-config.md)** - Complete specification for agent configuration files
- **[CLI Commands](cli.md)** - Command-line interface reference

### Protocol Specifications
- **[Protocols Overview](protocols/index.md)** - Introduction to Xaibo's protocol system
- **[LLM Protocol](protocols/llm.md)** - Language model integration protocol
- **[Tools Protocol](protocols/tools.md)** - Tool provider and execution protocol
- **[Memory Protocol](protocols/memory.md)** - Memory storage and retrieval protocols

### Module Reference
- **[LLM Modules](modules/llm.md)** - Language model implementations
- **[Tool Modules](modules/tools.md)** - Tool provider implementations
- **[Memory Modules](modules/memory.md)** - Memory system implementations
- **[Orchestrator Modules](modules/orchestrator.md)** - Agent orchestration modules

### API Reference
- **[Web Server API](api/server.md)** - Web server configuration and lifecycle
- **[API Adapters](api/adapters.md)** - OpenAI and MCP adapter specifications
- **[OpenAI Responses Adapter](api/openai-responses-adapter.md)** - Advanced OpenAI-compatible response management with conversation persistence

### Integration Reference
- **[LiveKit Integration](integrations/livekit.md)** - Complete API reference for using Xaibo agents in LiveKit voice assistants

### Troubleshooting
- **[Troubleshooting Reference](troubleshooting.md)** - Systematic solutions for common issues including authentication, configuration, and integration problems