# Tutorial: Getting Started with Xaibo

Welcome to the Xaibo tutorial! This hands-on guide will teach you how to build AI agents step by step. By the end of this tutorial, you'll have created your first working agent with tools and understand how Xaibo's protocol-based architecture works.

## What You'll Learn

Through practical examples, you'll discover how to:

- **Create your first agent** - Set up a basic AI agent that can respond to messages
- **Add tools to your agent** - Give your agent the ability to perform actions like checking time or weather
- **Understand protocols** - Learn how Xaibo's modular components work together
- **Master advanced orchestration** - Build agents that think step-by-step using the ReAct pattern
- **Test your agents** - Create reliable test suites for complex agent behaviors

## What You'll Build

You'll create a personal assistant agent that can:

- Answer questions using an AI language model
- Check the current time
- Look up weather information
- Access calendar entries

## Prerequisites

Before starting, make sure you have:

- Python 3.10 or higher installed
- Basic familiarity with command line operations
- A text editor for editing configuration files

## Tutorial Structure

This tutorial is organized into five progressive lessons:

### [1. Getting Started](getting-started.md)
Your first steps with Xaibo. You'll install the framework, create a new project, and run your first agent. **Start here** if you're new to Xaibo.

### [2. Building Tools](building-tools.md)
Learn how to create custom tools that give your agent new capabilities. You'll build practical tools and see how they integrate with your agent.

### [3. Understanding Protocols](understanding-protocols.md)
Discover how Xaibo's protocol-based architecture enables flexible, modular agent design. You'll learn to swap components and understand the framework's power.

### [4. Advanced Orchestration](advanced-orchestration.md)
Master the ReAct pattern for building intelligent agents that think step-by-step. Learn to create transparent, debuggable agents that handle complex multi-step tasks with explicit reasoning.

### [5. Testing Agents](testing-agents.md)
Master testing AI agents with dependency injection and event capture. Learn to replace components with test doubles, verify agent behavior, and build reliable test suites for complex agent interactions.

## Getting Help

If you encounter issues:

- Check that each step produces the expected output
- Ensure all prerequisites are installed
- Review the error messages carefully - they often contain helpful information

Ready to start building? Let's begin with [Getting Started](getting-started.md)!