# AUTOGENERATED! DO NOT EDIT! File to edit: ../../pts/api/config.pct.py.

# %% auto 0
__all__ = ['PathRef', 'PkgConfig']

# %% ../../pts/api/config.pct.py 3
from pathlib import Path
from typing import Any
from pydantic import BaseModel, model_validator, ConfigDict

# %% ../../pts/api/config.pct.py 4
class PathRef(BaseModel):
    model_config = ConfigDict(extra='forbid')
    parent: str|None = None
    path: Path
    
    @model_validator(mode='before')
    @classmethod
    def process_path(cls, data: Any) -> Any:
        if isinstance(data, str): data = {'path': data}
        data['path'] = Path(data['path'])
        if not data.get('parent') and not Path(data['path']).expanduser().is_absolute(): 
            raise ValueError(f"The '{data}' must be an absolute path if 'parent' is noe specified.")
        return data

# %% ../../pts/api/config.pct.py 5
class PkgConfig(BaseModel):
    model_config = ConfigDict(extra='forbid')

    @model_validator(mode='after')
    @classmethod
    def _post_process(cls, obj: 'PkgConfig') -> Any:
        def get_path(key) -> Path:
            val = getattr(obj, key)
            if isinstance(val, PathRef) and val.parent is None:
                val = val.path
            if isinstance(val, PathRef):
                return get_path(val.parent) / val.path
            else:
                return Path(val).expanduser().resolve()
        
        for key in cls.model_fields:
            value = getattr(obj, key)
            # Dereference PathRef instances and turn into Path objects
            if isinstance(value, PathRef):
                setattr(obj, key, get_path(key))
            # If the value is a string or Path, but the field type is PathRef, convert it to an expanded Path
            elif isinstance(value, (str, Path)) and issubclass(cls.model_fields[key].annotation, PathRef):
                setattr(obj, key, Path(value).expanduser().resolve())
        return obj
    
    @classmethod
    def from_toml(cls, toml_path: str) -> 'PkgConfig':
        import toml
        toml_config = toml.load(toml_path)
        return cls.model_validate(toml_config)
    
    def impart(self, target_obj):
        """
        Imparts the configuration values to the target object.
        The target object should have attributes matching the config keys.
        """
        for key, value in self.model_dump().items():
            setattr(target_obj, key, value)
