# coding: utf-8

"""
    Ory APIs

    # Introduction Documentation for all public and administrative Ory APIs. Administrative APIs can only be accessed with a valid Personal Access Token. Public APIs are mostly used in browsers.  ## SDKs This document describes the APIs available in the Ory Network. The APIs are available as SDKs for the following languages:  | Language       | Download SDK                                                     | Documentation                                                                        | | -------------- | ---------------------------------------------------------------- | ------------------------------------------------------------------------------------ | | Dart           | [pub.dev](https://pub.dev/packages/ory_client)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/dart/README.md)       | | .NET           | [nuget.org](https://www.nuget.org/packages/Ory.Client/)          | [README](https://github.com/ory/sdk/blob/master/clients/client/dotnet/README.md)     | | Elixir         | [hex.pm](https://hex.pm/packages/ory_client)                     | [README](https://github.com/ory/sdk/blob/master/clients/client/elixir/README.md)     | | Go             | [github.com](https://github.com/ory/client-go)                   | [README](https://github.com/ory/sdk/blob/master/clients/client/go/README.md)         | | Java           | [maven.org](https://search.maven.org/artifact/sh.ory/ory-client) | [README](https://github.com/ory/sdk/blob/master/clients/client/java/README.md)       | | JavaScript     | [npmjs.com](https://www.npmjs.com/package/@ory/client)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript/README.md) | | JavaScript (With fetch) | [npmjs.com](https://www.npmjs.com/package/@ory/client-fetch)           | [README](https://github.com/ory/sdk/blob/master/clients/client/typescript-fetch/README.md) |  | PHP            | [packagist.org](https://packagist.org/packages/ory/client)       | [README](https://github.com/ory/sdk/blob/master/clients/client/php/README.md)        | | Python         | [pypi.org](https://pypi.org/project/ory-client/)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/python/README.md)     | | Ruby           | [rubygems.org](https://rubygems.org/gems/ory-client)             | [README](https://github.com/ory/sdk/blob/master/clients/client/ruby/README.md)       | | Rust           | [crates.io](https://crates.io/crates/ory-client)                 | [README](https://github.com/ory/sdk/blob/master/clients/client/rust/README.md)       | 

    The version of the OpenAPI document: v1.21.0
    Contact: support@ory.sh
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from ory_client.models.keto_namespace import KetoNamespace
from ory_client.models.normalized_project_revision_courier_channel import NormalizedProjectRevisionCourierChannel
from ory_client.models.normalized_project_revision_hook import NormalizedProjectRevisionHook
from ory_client.models.normalized_project_revision_identity_schema import NormalizedProjectRevisionIdentitySchema
from ory_client.models.normalized_project_revision_saml_provider import NormalizedProjectRevisionSAMLProvider
from ory_client.models.normalized_project_revision_scim_client import NormalizedProjectRevisionScimClient
from ory_client.models.normalized_project_revision_third_party_provider import NormalizedProjectRevisionThirdPartyProvider
from ory_client.models.normalized_project_revision_tokenizer_template import NormalizedProjectRevisionTokenizerTemplate
from ory_client.models.organization import Organization
from typing import Optional, Set
from typing_extensions import Self

class CreateProjectNormalizedPayload(BaseModel):
    """
    Create project (normalized) request payload
    """ # noqa: E501
    account_experience_default_locale: Optional[StrictStr] = Field(default=None, description="Holds the default locale for the account experience.")
    account_experience_favicon_dark: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's dark theme favicon (currently unused).")
    account_experience_favicon_light: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's favicon.")
    account_experience_locale_behavior: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's language behavior.  Can be one of: `respect_accept_language`: Respect the `Accept-Language` header. `force_default`: Force the default language.")
    account_experience_logo_dark: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's dark theme logo (currently unused).")
    account_experience_logo_light: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's logo.")
    account_experience_theme_variables_dark: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's dark theme variables.")
    account_experience_theme_variables_light: Optional[StrictStr] = Field(default=None, description="Holds the URL to the account experience's light theme variables.")
    created_at: Optional[datetime] = Field(default=None, description="The Project's Revision Creation Date")
    disable_account_experience_welcome_screen: Optional[StrictBool] = Field(default=None, description="Whether to disable the account experience welcome screen, which is hosted under `/ui/welcome`.")
    enable_ax_v2: Optional[StrictBool] = Field(default=None, description="Whether the new account experience is enabled and reachable.")
    environment: StrictStr = Field(description=" prod Production stage Staging dev Development")
    home_region: Optional[StrictStr] = Field(default=None, description=" eu-central EUCentral asia-northeast AsiaNorthEast us-east USEast us-west USWest us US global Global")
    hydra_oauth2_allowed_top_level_claims: Optional[List[StrictStr]] = None
    hydra_oauth2_client_credentials_default_grant_allowed_scope: Optional[StrictBool] = Field(default=None, description="Automatically grant authorized OAuth2 Scope in OAuth2 Client Credentials Flow.  Each OAuth2 Client is allowed to request a predefined OAuth2 Scope (for example `read write`). If this option is enabled, the full scope is automatically granted when performing the OAuth2 Client Credentials flow.  If disabled, the OAuth2 Client has to request the scope in the OAuth2 request by providing the `scope` query parameter.  Setting this option to true is common if you need compatibility with MITREid.  This governs the \"oauth2.client_credentials.default_grant_allowed_scope\" setting.")
    hydra_oauth2_exclude_not_before_claim: Optional[StrictBool] = Field(default=None, description="Set to true if you want to exclude claim `nbf (not before)` part of access token.  This governs the \"oauth2.exclude_not_before_claim\" setting.")
    hydra_oauth2_grant_jwt_iat_optional: Optional[StrictBool] = Field(default=None, description="Configures if the issued at (`iat`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `iat` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.iat_optional\" setting.")
    hydra_oauth2_grant_jwt_jti_optional: Optional[StrictBool] = Field(default=None, description="Configures if the JSON Web Token ID (`jti`) claim is required in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523).  If set to `false`, the `jti` claim is required. Set this value to `true` only after careful consideration.  This governs the \"oauth2.grant.jwt.jti_optional\" setting.")
    hydra_oauth2_grant_jwt_max_ttl: Optional[Annotated[str, Field(strict=True)]] = Field(default='720h', description="Configures what the maximum age of a JWT assertion used in the JSON Web Token (JWT) Profile for OAuth 2.0 Client Authentication and Authorization Grants (RFC7523) can be.  This feature uses the `exp` claim and `iat` claim to calculate assertion age. Assertions exceeding the max age will be denied.  Useful as a safety measure and recommended to keep below 720h.  This governs the \"oauth2.grant.jwt.max_ttl\" setting.")
    hydra_oauth2_grant_refresh_token_rotation_grace_period: Optional[StrictStr] = Field(default=None, description="Configures the OAuth2 Grant Refresh Token Rotation Grace Period  If set to `null` or `\"0s\"`, the graceful refresh token rotation is disabled.  This governs the \"oauth2.grant.refresh_token_rotation_grace_period\" setting.")
    hydra_oauth2_mirror_top_level_claims: Optional[StrictBool] = Field(default=None, description="Set to false if you don't want to mirror custom claims under 'ext'.  This governs the \"oauth2.mirror_top_level_claims\" setting.")
    hydra_oauth2_pkce_enforced: Optional[StrictBool] = Field(default=None, description="Configures whether PKCE should be enforced for all OAuth2 Clients.  This governs the \"oauth2.pkce.enforced\" setting.")
    hydra_oauth2_pkce_enforced_for_public_clients: Optional[StrictBool] = Field(default=None, description="Configures whether PKCE should be enforced for OAuth2 Clients without a client secret (public clients).  This governs the \"oauth2.pkce.enforced_for_public_clients\" setting.")
    hydra_oauth2_refresh_token_hook: Optional[StrictStr] = Field(default=None, description="Sets the Refresh Token Hook Endpoint. If set this endpoint will be called during the OAuth2 Token Refresh grant update the OAuth2 Access Token claims.  This governs the \"oauth2.refresh_token_hook\" setting.")
    hydra_oauth2_token_hook: Optional[StrictStr] = Field(default=None, description="Sets the token hook endpoint for all grant types. If set it will be called while providing token to customize claims.  This governs the \"oauth2.token_hook.url\" setting.")
    hydra_oidc_dynamic_client_registration_default_scope: Optional[List[StrictStr]] = None
    hydra_oidc_dynamic_client_registration_enabled: Optional[StrictBool] = Field(default=None, description="Configures OpenID Connect Dynamic Client Registration.  This governs the \"oidc.dynamic_client_registration.enabled\" setting.")
    hydra_oidc_subject_identifiers_pairwise_salt: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites the pairwise algorithm  This governs the \"oidc.subject_identifiers.pairwise_salt\" setting.")
    hydra_oidc_subject_identifiers_supported_types: Optional[List[StrictStr]] = None
    hydra_secrets_cookie: Optional[List[StrictStr]] = None
    hydra_secrets_pagination: Optional[List[StrictStr]] = None
    hydra_secrets_system: Optional[List[StrictStr]] = None
    hydra_serve_cookies_same_site_legacy_workaround: Optional[StrictBool] = Field(default=None, description="Configures the Ory Hydra Cookie Same Site Legacy Workaround  This governs the \"serve.cookies.same_site_legacy_workaround\" setting.")
    hydra_serve_cookies_same_site_mode: Optional[StrictStr] = Field(default=None, description="Configures the Ory Hydra Cookie Same Site Mode  This governs the \"serve.cookies.same_site_mode\" setting.")
    hydra_strategies_access_token: Optional[StrictStr] = Field(default='opaque', description="Defines access token type  This governs the \"strategies.access_token\" setting. opaque Oauth2AccessTokenStrategyOpaque jwt Oauth2AccessTokenStrategyJwt")
    hydra_strategies_jwt_scope_claim: Optional[StrictStr] = Field(default='list', description="Define the claim to use as the scope in the access token.  This governs the \"strategies.jwt.scope_claim\" setting:  list: The scope claim is an array of strings named `scope`: `{ \"scope\": [\"read\", \"write\"] }` string: The scope claim is a space delimited list of strings named `scp`: `{ \"scp\": \"read write\" }` both: The scope claim is both a space delimited list and an array of strings named `scope` and `scp`: `{ \"scope\": [\"read\", \"write\"], \"scp\": \"read write\" }` list OAuth2JWTScopeClaimList string OAuth2JWTScopeClaimString both OAuth2JWTScopeClaimBoth")
    hydra_strategies_scope: Optional[StrictStr] = Field(default='wildcard', description="Defines how scopes are matched. For more details have a look at https://github.com/ory/fosite#scopes  This governs the \"strategies.scope\" setting. exact Oauth2ScopeStrategyExact wildcard Oauth2ScopeStrategyWildcard")
    hydra_ttl_access_token: Optional[Annotated[str, Field(strict=True)]] = Field(default='30m', description="This governs the \"ttl.access_token\" setting.")
    hydra_ttl_auth_code: Optional[Annotated[str, Field(strict=True)]] = Field(default='720h', description="Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.auth_code\" setting.")
    hydra_ttl_id_token: Optional[Annotated[str, Field(strict=True)]] = Field(default='30m', description="This governs the \"ttl.id_token\" setting.")
    hydra_ttl_login_consent_request: Optional[Annotated[str, Field(strict=True)]] = Field(default='30m', description="Configures how long a user login and consent flow may take.  This governs the \"ttl.login_consent_request\" setting.")
    hydra_ttl_refresh_token: Optional[Annotated[str, Field(strict=True)]] = Field(default='720h', description="Configures how long refresh tokens are valid.  Set to -1 for refresh tokens to never expire. This is not recommended!  This governs the \"ttl.refresh_token\" setting.")
    hydra_urls_consent: Optional[StrictStr] = Field(default=None, description="Sets the OAuth2 Consent Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to the Ory Account Experience if left empty.  This governs the \"urls.consent\" setting.")
    hydra_urls_error: Optional[StrictStr] = Field(default=None, description="Sets the OAuth2 Error URL of the OAuth2 User Login & Consent flow.  Defaults to the Ory Account Experience if left empty.  This governs the \"urls.error\" setting.")
    hydra_urls_login: Optional[StrictStr] = Field(default=None, description="Sets the OAuth2 Login Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to the Ory Account Experience if left empty.  This governs the \"urls.login\" setting.")
    hydra_urls_logout: Optional[StrictStr] = Field(default=None, description="Sets the logout endpoint.  Defaults to the Ory Account Experience if left empty.  This governs the \"urls.logout\" setting.")
    hydra_urls_post_logout_redirect: Optional[StrictStr] = Field(default=None, description="When an OAuth2-related user agent requests to log out, they will be redirected to this url afterwards per default.  Defaults to the Ory Account Experience in development and your application in production mode when a custom domain is connected.  This governs the \"urls.post_logout_redirect\" setting.")
    hydra_urls_registration: Optional[StrictStr] = Field(default=None, description="Sets the OAuth2 Registration Endpoint URL of the OAuth2 User Login & Consent flow.  Defaults to the Ory Account Experience if left empty.  This governs the \"urls.registration\" setting.")
    hydra_urls_self_issuer: Optional[StrictStr] = Field(default=None, description="This value will be used as the issuer in access and ID tokens. It must be specified and using HTTPS protocol, unless the development mode is enabled.  On the Ory Network it will be very rare that you want to modify this value. If left empty, it will default to the correct value for the Ory Network.  This governs the \"urls.self.issuer\" setting.")
    hydra_webfinger_jwks_broadcast_keys: Optional[List[StrictStr]] = None
    hydra_webfinger_oidc_discovery_auth_url: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites the OAuth2 Authorization URL.  This governs the \"webfinger.oidc.discovery.auth_url\" setting.")
    hydra_webfinger_oidc_discovery_client_registration_url: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites the OpenID Connect Dynamic Client Registration Endpoint.  This governs the \"webfinger.oidc.discovery.client_registration_url\" setting.")
    hydra_webfinger_oidc_discovery_jwks_url: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites the JWKS URL.  This governs the \"webfinger.oidc.discovery.jwks_url\" setting.")
    hydra_webfinger_oidc_discovery_supported_claims: Optional[List[StrictStr]] = None
    hydra_webfinger_oidc_discovery_supported_scope: Optional[List[StrictStr]] = None
    hydra_webfinger_oidc_discovery_token_url: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites the OAuth2 Token URL.  This governs the \"webfinger.oidc.discovery.token_url\" setting.")
    hydra_webfinger_oidc_discovery_userinfo_url: Optional[StrictStr] = Field(default=None, description="Configures OpenID Connect Discovery and overwrites userinfo endpoint to be advertised at the OpenID Connect Discovery endpoint /.well-known/openid-configuration. Defaults to Ory Hydra's userinfo endpoint at /userinfo. Set this value if you want to handle this endpoint yourself.  This governs the \"webfinger.oidc.discovery.userinfo_url\" setting.")
    id: Optional[StrictStr] = Field(default=None, description="The revision ID.")
    keto_namespace_configuration: Optional[StrictStr] = Field(default=None, description="The Revisions' Keto Namespace Configuration  The string is a URL pointing to an OPL file with the configuration.")
    keto_namespaces: Optional[List[KetoNamespace]] = None
    keto_secrets_pagination: Optional[List[StrictStr]] = None
    kratos_cookies_same_site: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Cookie SameSite Attribute  This governs the \"cookies.same_site\" setting.")
    kratos_courier_channels: Optional[List[NormalizedProjectRevisionCourierChannel]] = None
    kratos_courier_delivery_strategy: Optional[StrictStr] = Field(default='smtp', description="The delivery strategy to use when sending emails  `smtp`: Use SMTP server `http`: Use the built in HTTP client to send the email to some remote service")
    kratos_courier_http_request_config_auth_api_key_in: Optional[StrictStr] = Field(default=None, description="The location of the API key to use in the HTTP email sending service's authentication  `header`: Send the key value pair as a header `cookie`: Send the key value pair as a cookie This governs the \"courier.http.auth.config.in\" setting")
    kratos_courier_http_request_config_auth_api_key_name: Optional[StrictStr] = Field(default=None, description="The name of the API key to use in the HTTP email sending service's authentication  This governs the \"courier.http.auth.config.name\" setting")
    kratos_courier_http_request_config_auth_api_key_value: Optional[StrictStr] = Field(default=None, description="The value of the API key to use in the HTTP email sending service's authentication  This governs the \"courier.http.auth.config.value\" setting")
    kratos_courier_http_request_config_auth_basic_auth_password: Optional[StrictStr] = Field(default=None, description="The password to use for basic auth in the HTTP email sending service's authentication  This governs the \"courier.http.auth.config.password\" setting")
    kratos_courier_http_request_config_auth_basic_auth_user: Optional[StrictStr] = Field(default=None, description="The user to use for basic auth in the HTTP email sending service's authentication  This governs the \"courier.http.auth.config.user\" setting")
    kratos_courier_http_request_config_auth_type: Optional[StrictStr] = Field(default='empty (no authentication)', description="The authentication type to use while contacting the remote HTTP email sending service  `basic_auth`: Use Basic Authentication `api_key`: Use API Key Authentication in a header or cookie")
    kratos_courier_http_request_config_body: Optional[StrictStr] = Field(default=None, description="The Jsonnet template to generate the body to send to the remote HTTP email sending service  Should be valid Jsonnet and base64 encoded  This governs the \"courier.http.body\" setting")
    kratos_courier_http_request_config_headers: Optional[Dict[str, Any]] = Field(default=None, description="NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-")
    kratos_courier_http_request_config_method: Optional[StrictStr] = Field(default='POST', description="The http METHOD to use when calling the remote HTTP email sending service")
    kratos_courier_http_request_config_url: Optional[StrictStr] = Field(default=None, description="The URL of the remote HTTP email sending service  This governs the \"courier.http.url\" setting")
    kratos_courier_smtp_connection_uri: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos SMTP Connection URI  This governs the \"courier.smtp.connection_uri\" setting.")
    kratos_courier_smtp_from_address: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos SMTP From Address  This governs the \"courier.smtp.from_address\" setting.")
    kratos_courier_smtp_from_name: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos SMTP From Name  This governs the \"courier.smtp.from_name\" setting.")
    kratos_courier_smtp_headers: Optional[Dict[str, Any]] = Field(default=None, description="NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-")
    kratos_courier_smtp_local_name: Optional[StrictStr] = Field(default=None, description="Configures the local_name to use in SMTP connections  This governs the \"courier.smtp.local_name\" setting.")
    kratos_courier_templates_login_code_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Login via Code Email Body HTML Template  This governs the \"courier.smtp.templates.login_code.valid.email.body.html\" setting.")
    kratos_courier_templates_login_code_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Login via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.login_code.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_login_code_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Login via Code Email Subject Template  This governs the \"courier.smtp.templates.login_code.valid.email.subject\" setting.")
    kratos_courier_templates_login_code_valid_sms_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Login via Code SMS plain text body  This governs the \"courier.smtp.templates.login_code.valid.sms.plaintext\" setting.")
    kratos_courier_templates_recovery_code_invalid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery via Code Email Body HTML Template  This governs the \"courier.smtp.templates.recovery_code.invalid.email.body.html\" setting.")
    kratos_courier_templates_recovery_code_invalid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery_code.invalid.email.body.plaintext\" setting.")
    kratos_courier_templates_recovery_code_invalid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery via Code Email Subject Template  This governs the \"courier.smtp.templates.recovery_code.invalid.email.body.html\" setting.")
    kratos_courier_templates_recovery_code_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery via Code Email Body HTML Template  This governs the \"courier.smtp.templates.recovery_code.valid.email.body.html\" setting.")
    kratos_courier_templates_recovery_code_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery_code.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_recovery_code_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery via Code Email Subject Template  This governs the \"courier.smtp.templates.recovery_code.valid.email.subject\" setting.")
    kratos_courier_templates_recovery_invalid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.")
    kratos_courier_templates_recovery_invalid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.plaintext\" setting.")
    kratos_courier_templates_recovery_invalid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.invalid.email.body.html\" setting.")
    kratos_courier_templates_recovery_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery Email Body HTML Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.html\" setting.")
    kratos_courier_templates_recovery_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery Email Body Plaintext Template  This governs the \"courier.smtp.templates.recovery.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_recovery_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Recovery Email Subject Template  This governs the \"courier.smtp.templates.recovery.valid.email.subject\" setting.")
    kratos_courier_templates_registration_code_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Registration via Code Email Body HTML Template  This governs the \"courier.smtp.templates.registration_code.valid.email.body.html\" setting.")
    kratos_courier_templates_registration_code_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Registration via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.registration_code.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_registration_code_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Registration via Code Email Subject Template  This governs the \"courier.smtp.templates.registration_code.valid.email.subject\" setting.")
    kratos_courier_templates_registration_code_valid_sms_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Registration via Code Email Subject Template  This governs the \"courier.smtp.templates.registration_code.valid.sms.body.plaintext\" setting.")
    kratos_courier_templates_verification_code_invalid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification via Code Email Body HTML Template  This governs the \"courier.smtp.templates.verification_code.invalid.email.body.html\" setting.")
    kratos_courier_templates_verification_code_invalid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.verification_code.invalid.email.body.plaintext\" setting.")
    kratos_courier_templates_verification_code_invalid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification via Code Email Subject Template  This governs the \"courier.smtp.templates.verification_code.invalid.email.subject\" setting.")
    kratos_courier_templates_verification_code_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification via Code Email Body HTML Template  This governs the \"courier.smtp.templates.verification_code.valid.email.body.html\" setting.")
    kratos_courier_templates_verification_code_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification via Code Email Body Plaintext Template  This governs the \"courier.smtp.templates.verification_code.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_verification_code_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification via Code Email Subject Template  This governs the \"courier.smtp.templates.verification_code.valid.email.subject\" setting.")
    kratos_courier_templates_verification_code_valid_sms_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification via Code SMS Body Plaintext  This governs the \"courier.smtp.templates.verification_code.valid.sms.body.plaintext\" setting.")
    kratos_courier_templates_verification_invalid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.html\" setting.")
    kratos_courier_templates_verification_invalid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.verification.invalid.email.body.plaintext\" setting.")
    kratos_courier_templates_verification_invalid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Invalid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.invalid.email.subject\" setting.")
    kratos_courier_templates_verification_valid_email_body_html: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification Email Body HTML Template  This governs the \"courier.smtp.templates.verification.valid.email.body.html\" setting.")
    kratos_courier_templates_verification_valid_email_body_plaintext: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification Email Body Plaintext Template  This governs the \"courier.smtp.templates.verification.valid.email.body.plaintext\" setting.")
    kratos_courier_templates_verification_valid_email_subject: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Valid Verification Email Subject Template  This governs the \"courier.smtp.templates.verification.valid.email.subject\" setting.")
    kratos_feature_flags_cacheable_sessions: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Session caching feature flag  This governs the \"feature_flags.cacheable_sessions\" setting.")
    kratos_feature_flags_cacheable_sessions_max_age: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Session caching max-age feature flag  This governs the \"feature_flags.cacheable_sessions_max_age\" setting.")
    kratos_feature_flags_choose_recovery_address: Optional[StrictBool] = Field(default=None, description="This governs the \"feature_flags.choose_recovery_address\" setting.")
    kratos_feature_flags_faster_session_extend: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Faster Session Extend setting  If enabled allows faster session extension by skipping the session lookup and returning 201 instead of 200. Disabling this feature will be deprecated in the future.  This governs the \"feature_flags.faster_session_extend\" setting.")
    kratos_feature_flags_legacy_continue_with_verification_ui: Optional[StrictBool] = Field(default=None, description="Always include show_verification_ui in continue_with  If true, restores the legacy behavior of always including `show_verification_ui` in the registration flow's `continue_with` when verification is enabled. If set to false, `show_verification_ui` is only set in `continue_with` if the `show_verification_ui` hook is used. This flag will be removed in the future.  This governs the \"feature_flags.legacy_continue_with_verification_ui\" setting.")
    kratos_feature_flags_legacy_oidc_registration_node_group: Optional[StrictBool] = Field(default=None, description="Controls whether the UI nodes in an OIDC registration flow have group \"oidc\" in case required fields are not returned by the OIDC provider.  If set to true, the UI nodes will have group \"oidc\" and the flow will be considered successful if the user completes the flow. This is the legacy behavior.  This governs the \"feature_flags.legacy_oidc_registration_node_group\" setting.")
    kratos_feature_flags_legacy_require_verified_login_error: Optional[StrictBool] = Field(default=None, description="Return a form error if the login identifier is not verified  If true, the login flow will return a form error if the login identifier is not verified, which restores legacy behavior. If this value is false, the `continue_with` array will contain a `show_verification_ui` hook instead.  This flag is deprecated and will be removed in the future.  This governs the \"feature_flags.legacy_require_verified_login_error\" setting.")
    kratos_feature_flags_password_profile_registration_node_group: Optional[StrictBool] = Field(default=None, description="Configures the group for the password method in the registration flow.  If true, it sets the password method group value to \"password\" if it is the only method available. This is the legacy behavior. If false is, it sets the password method group value to \"default\".")
    kratos_feature_flags_use_continue_with_transitions: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Session use_continue_with_transitions flag  This governs the \"feature_flags.use_continue_with_transitions\" setting.")
    kratos_identity_schemas: Optional[List[NormalizedProjectRevisionIdentitySchema]] = None
    kratos_oauth2_provider_headers: Optional[Dict[str, Any]] = Field(default=None, description="NullJSONRawMessage represents a json.RawMessage that works well with JSON, SQL, and Swagger and is NULLable-")
    kratos_oauth2_provider_override_return_to: Optional[StrictBool] = Field(default=None, description="Kratos OAuth2 Provider Override Return To  Enabling this allows Kratos to set the return_to parameter automatically to the OAuth2 request URL on the login flow, allowing complex flows such as recovery to continue to the initial OAuth2 flow.")
    kratos_oauth2_provider_url: Optional[StrictStr] = Field(default=None, description="The Revisions' OAuth2 Provider Integration URL  This governs the \"oauth2_provider.url\" setting.")
    kratos_preview_default_read_consistency_level: Optional[StrictStr] = Field(default=None, description="Configures the default read consistency level for identity APIs  This governs the `preview.default_read_consistency_level` setting.  The read consistency level determines the consistency guarantee for reads:  strong (slow): The read is guaranteed to return the most recent data committed at the start of the read. eventual (very fast): The result will return data that is about 4.8 seconds old.  Setting the default consistency level to `eventual` may cause regressions in the future as we add consistency controls to more APIs. Currently, the following APIs will be affected by this setting:  `GET /admin/identities`  Defaults to \"strong\" for new and existing projects. This feature is in preview. Use with caution.")
    kratos_secrets_cipher: Optional[List[StrictStr]] = None
    kratos_secrets_cookie: Optional[List[StrictStr]] = None
    kratos_secrets_default: Optional[List[StrictStr]] = None
    kratos_security_account_enumeration_mitigate: Optional[StrictBool] = Field(default=None, description="Configures if account enumeration should be mitigated when using identifier first login.")
    kratos_selfservice_allowed_return_urls: Optional[List[StrictStr]] = None
    kratos_selfservice_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Default Return URL  This governs the \"selfservice.allowed_return_urls\" setting.")
    kratos_selfservice_flows_error_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Error UI URL  This governs the \"selfservice.flows.error.ui_url\" setting.")
    kratos_selfservice_flows_login_after_code_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.code.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login Default Return URL  This governs the \"selfservice.flows.login.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_lookup_secret_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.lookup_secret.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_oidc_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After OIDC Default Return URL  This governs the \"selfservice.flows.login.after.oidc.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_passkey_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After Passkey Default Return URL  This governs the \"selfservice.flows.login.after.passkey.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_password_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.login.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_totp_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After Password Default Return URL  This governs the \"selfservice.flows.totp.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_after_webauthn_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login After WebAuthn Default Return URL  This governs the \"selfservice.flows.login.after.webauthn.default_browser_return_url\" setting.")
    kratos_selfservice_flows_login_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login Lifespan  This governs the \"selfservice.flows.login.lifespan\" setting.")
    kratos_selfservice_flows_login_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Login UI URL  This governs the \"selfservice.flows.login.ui_url\" setting.")
    kratos_selfservice_flows_logout_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Logout Default Return URL  This governs the \"selfservice.flows.logout.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_recovery_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Recovery Default Return URL  This governs the \"selfservice.flows.recovery.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_recovery_enabled: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Recovery Enabled Setting  This governs the \"selfservice.flows.recovery.enabled\" setting.")
    kratos_selfservice_flows_recovery_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Recovery Lifespan  This governs the \"selfservice.flows.recovery.lifespan\" setting.")
    kratos_selfservice_flows_recovery_notify_unknown_recipients: Optional[StrictBool] = Field(default=None, description="Configures whether to notify unknown recipients of a Ory Kratos recovery flow  This governs the \"selfservice.flows.recovery.notify_unknown_recipients\" setting.")
    kratos_selfservice_flows_recovery_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Recovery UI URL  This governs the \"selfservice.flows.recovery.ui_url\" setting.")
    kratos_selfservice_flows_recovery_use: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Recovery strategy to use (\"link\" or \"code\")  This governs the \"selfservice.flows.recovery.use\" setting. link SelfServiceMessageVerificationStrategyLink code SelfServiceMessageVerificationStrategyCode")
    kratos_selfservice_flows_registration_after_code_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration After Code Default Return URL  This governs the \"selfservice.flows.registration.after.code.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration Default Return URL  This governs the \"selfservice.flows.registration.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_after_oidc_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration After OIDC Default Return URL  This governs the \"selfservice.flows.registration.after.oidc.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_after_passkey_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration After Passkey Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_after_password_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration After Password Default Return URL  This governs the \"selfservice.flows.registration.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration After Webauthn Default Return URL  This governs the \"selfservice.flows.registration.after.webauthn.default_browser_return_url\" setting.")
    kratos_selfservice_flows_registration_enable_legacy_one_step: Optional[StrictBool] = Field(default=None, description="Disable two-step registration  Two-step registration is a significantly improved sign up flow and recommended when using more than one sign up methods. To revert to one-step registration, set this to `true`.  This governs the \"selfservice.flows.registration.enable_legacy_one_step\" setting.")
    kratos_selfservice_flows_registration_enabled: Optional[StrictBool] = Field(default=None, description="Configures the Whether Ory Kratos Registration is Enabled  This governs the \"selfservice.flows.registration.enabled\" setting.0")
    kratos_selfservice_flows_registration_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration Lifespan  This governs the \"selfservice.flows.registration.lifespan\" setting.")
    kratos_selfservice_flows_registration_login_hints: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Registration Login Hints  Shows helpful information when a user tries to sign up with a duplicate account.  This governs the \"selfservice.flows.registration.login_hints\" setting.")
    kratos_selfservice_flows_registration_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Registration UI URL  This governs the \"selfservice.flows.registration.ui_url\" setting.")
    kratos_selfservice_flows_settings_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL  This governs the \"selfservice.flows.settings.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_lookup_secret_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating Lookup Secrets  This governs the \"selfservice.flows.settings.after.lookup_secret.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_oidc_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating Social Sign In  This governs the \"selfservice.flows.settings.after.oidc.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_passkey_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating Passkey  This governs the \"selfservice.flows.settings.after.passkey.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_password_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating Passwords  This governs the \"selfservice.flows.settings.after.password.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_profile_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating Profiles  This governs the \"selfservice.flows.settings.after.profile.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_totp_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating TOTP  This governs the \"selfservice.flows.settings.after.totp.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_after_webauthn_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Default Return URL After Updating WebAuthn  This governs the \"selfservice.flows.settings.after.webauthn.default_browser_return_url\" setting.")
    kratos_selfservice_flows_settings_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Lifespan  This governs the \"selfservice.flows.settings.lifespan\" setting.")
    kratos_selfservice_flows_settings_privileged_session_max_age: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Privileged Session Max Age  This governs the \"selfservice.flows.settings.privileged_session_max_age\" setting.")
    kratos_selfservice_flows_settings_required_aal: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings Required AAL  This governs the \"selfservice.flows.settings.required_aal\" setting.")
    kratos_selfservice_flows_settings_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Settings UI URL  This governs the \"selfservice.flows.settings.ui_url\" setting.")
    kratos_selfservice_flows_verification_after_default_browser_return_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Verification Default Return URL  This governs the \"selfservice.flows.verification.after.default_browser_return_url\" setting.")
    kratos_selfservice_flows_verification_enabled: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Verification Enabled Setting  This governs the \"selfservice.flows.verification.enabled\" setting.")
    kratos_selfservice_flows_verification_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Verification Lifespan  This governs the \"selfservice.flows.verification.lifespan\" setting.")
    kratos_selfservice_flows_verification_notify_unknown_recipients: Optional[StrictBool] = Field(default=None, description="Configures whether to notify unknown recipients of a Ory Kratos verification flow  This governs the \"selfservice.flows.verification.notify_unknown_recipients\" setting.")
    kratos_selfservice_flows_verification_ui_url: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Verification UI URL  This governs the \"selfservice.flows.verification.ui_url\" setting.")
    kratos_selfservice_flows_verification_use: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Strategy to use for Verification  This governs the \"selfservice.flows.verification.use\" setting. link SelfServiceMessageVerificationStrategyLink code SelfServiceMessageVerificationStrategyCode")
    kratos_selfservice_methods_captcha_config_cf_turnstile_secret: Optional[StrictStr] = Field(default=None, description="Configures the Cloudflare Turnstile site secret for CAPTCHA protection  The site secret is private and will be never be shared with the client. This key is write only and the value will not be returned in response to a read request.  Reach out to your account manager to enable this feature.")
    kratos_selfservice_methods_captcha_config_cf_turnstile_sitekey: Optional[StrictStr] = Field(default=None, description="Configures the Cloudflare Turnstile site key for CAPTCHA protection  The site key is public and will be shared with the client.  Reach out to your account manager to enable this feature.")
    kratos_selfservice_methods_captcha_config_legacy_inject_node: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Self-Service Methods' Captcha Enabled Setting  Reach out to your account manager to enable this feature.")
    kratos_selfservice_methods_captcha_enabled: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Self-Service Methods' Captcha Enabled Setting  Reach out to your account manager to enable this feature.")
    kratos_selfservice_methods_code_config_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Code Method's lifespan  This governs the \"selfservice.methods.code.config.lifespan\" setting.")
    kratos_selfservice_methods_code_config_max_submissions: Optional[StrictInt] = None
    kratos_selfservice_methods_code_config_missing_credential_fallback_enabled: Optional[StrictBool] = Field(default=None, description="Enables a fallback method required in certain legacy use cases.  This governs the \"selfservice.methods.code.config.missing_credential_fallback_enabled\" setting.")
    kratos_selfservice_methods_code_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Code Method is enabled  This governs the \"selfservice.methods.code.enabled\" setting.")
    kratos_selfservice_methods_code_mfa_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether the code method can be used to fulfil MFA flows  This governs the \"selfservice.methods.code.mfa_enabled\" setting.")
    kratos_selfservice_methods_code_passwordless_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Passwordless should use the Code Method  This governs the \"selfservice.methods.code.passwordless_enabled\" setting.")
    kratos_selfservice_methods_code_passwordless_login_fallback_enabled: Optional[StrictBool] = Field(default=None, description="This setting allows the code method to always login a user with code if they have registered with another authentication method such as password or social sign in.  This governs the \"selfservice.methods.code.passwordless_login_fallback_enabled\" setting.")
    kratos_selfservice_methods_link_config_base_url: Optional[StrictStr] = Field(default=None, description="Configures the Base URL which Recovery, Verification, and Login Links Point to  It is recommended to leave this value empty. It will be appropriately configured to the best matching domain (e.g. when using custom domains) automatically.  This governs the \"selfservice.methods.link.config.base_url\" setting.")
    kratos_selfservice_methods_link_config_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Link Method's lifespan  This governs the \"selfservice.methods.link.config.lifespan\" setting.")
    kratos_selfservice_methods_link_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Link Method is enabled  This governs the \"selfservice.methods.link.enabled\" setting.")
    kratos_selfservice_methods_lookup_secret_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos TOTP Lookup Secret is enabled  This governs the \"selfservice.methods.lookup_secret.enabled\" setting.")
    kratos_selfservice_methods_oidc_config_base_redirect_uri: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Third Party / OpenID Connect base redirect URI  This governs the \"selfservice.methods.oidc.config.base_redirect_uri\" setting.")
    kratos_selfservice_methods_oidc_config_providers: Optional[List[NormalizedProjectRevisionThirdPartyProvider]] = None
    kratos_selfservice_methods_oidc_enable_auto_link_policy: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos allows auto-linking of OIDC credentials without a subject  This governs the \"selfservice.methods.oidc.enable_auto_link_policy\" setting.")
    kratos_selfservice_methods_oidc_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Third Party / OpenID Connect Login is enabled  This governs the \"selfservice.methods.oidc.enabled\" setting.")
    kratos_selfservice_methods_passkey_config_rp_display_name: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Passkey RP Display Name  This governs the \"selfservice.methods.passkey.config.rp.display_name\" setting.")
    kratos_selfservice_methods_passkey_config_rp_id: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Passkey RP ID  This governs the \"selfservice.methods.passkey.config.rp.id\" setting.")
    kratos_selfservice_methods_passkey_config_rp_origins: Optional[List[StrictStr]] = None
    kratos_selfservice_methods_passkey_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Passkey authentication is enabled  This governs the \"selfservice.methods.passkey.enabled\" setting.")
    kratos_selfservice_methods_password_config_haveibeenpwned_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Password HIBP Checks is enabled  This governs the \"selfservice.methods.password.config.haveibeenpwned_enabled\" setting.")
    kratos_selfservice_methods_password_config_identifier_similarity_check_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Password should disable the similarity policy.  This governs the \"selfservice.methods.password.config.identifier_similarity_check_enabled\" setting.")
    kratos_selfservice_methods_password_config_ignore_network_errors: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Password Should ignore HIBPWND Network Errors  This governs the \"selfservice.methods.password.config.ignore_network_errors\" setting.")
    kratos_selfservice_methods_password_config_max_breaches: Optional[StrictInt] = Field(default=None, description="Configures Ory Kratos Password Max Breaches Detection  This governs the \"selfservice.methods.password.config.max_breaches\" setting.")
    kratos_selfservice_methods_password_config_min_password_length: Optional[StrictInt] = Field(default=None, description="Configures the minimum length of passwords.  This governs the \"selfservice.methods.password.config.min_password_length\" setting.")
    kratos_selfservice_methods_password_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Password Method is enabled  This governs the \"selfservice.methods.password.enabled\" setting.")
    kratos_selfservice_methods_profile_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Profile Method is enabled  This governs the \"selfservice.methods.profile.enabled\" setting.")
    kratos_selfservice_methods_saml_config_providers: Optional[List[NormalizedProjectRevisionSAMLProvider]] = None
    kratos_selfservice_methods_saml_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos SAML Login is enabled  This governs the \"selfservice.methods.saml.enabled\" setting.")
    kratos_selfservice_methods_totp_config_issuer: Optional[StrictStr] = Field(default=None, description="Configures Ory Kratos TOTP Issuer  This governs the \"selfservice.methods.totp.config.issuer\" setting.")
    kratos_selfservice_methods_totp_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos TOTP Method is enabled  This governs the \"selfservice.methods.totp.enabled\" setting.")
    kratos_selfservice_methods_webauthn_config_passwordless: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Webauthn is used for passwordless flows  This governs the \"selfservice.methods.webauthn.config.passwordless\" setting.")
    kratos_selfservice_methods_webauthn_config_rp_display_name: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Webauthn RP Display Name  This governs the \"selfservice.methods.webauthn.config.rp.display_name\" setting.")
    kratos_selfservice_methods_webauthn_config_rp_icon: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Webauthn RP Icon  This governs the \"selfservice.methods.webauthn.config.rp.icon\" setting. Deprecated: This value will be ignored due to security considerations.")
    kratos_selfservice_methods_webauthn_config_rp_id: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Webauthn RP ID  This governs the \"selfservice.methods.webauthn.config.rp.id\" setting.")
    kratos_selfservice_methods_webauthn_config_rp_origins: Optional[List[StrictStr]] = None
    kratos_selfservice_methods_webauthn_enabled: Optional[StrictBool] = Field(default=None, description="Configures whether Ory Kratos Webauthn is enabled  This governs the \"selfservice.methods.webauthn.enabled\" setting.")
    kratos_session_cookie_persistent: Optional[StrictBool] = Field(default=None, description="Configures the Ory Kratos Session Cookie Persistent Attribute  This governs the \"session.cookie.persistent\" setting.")
    kratos_session_cookie_same_site: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Session Cookie SameSite Attribute  This governs the \"session.cookie.same_site\" setting.")
    kratos_session_lifespan: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Session Lifespan  This governs the \"session.lifespan\" setting.")
    kratos_session_whoami_required_aal: Optional[StrictStr] = Field(default=None, description="Configures the Ory Kratos Session Whoami AAL requirement  This governs the \"session.whoami.required_aal\" setting.")
    kratos_session_whoami_tokenizer_templates: Optional[List[NormalizedProjectRevisionTokenizerTemplate]] = None
    name: StrictStr = Field(description="The project's name.")
    organizations: Optional[List[Organization]] = None
    project_id: Optional[StrictStr] = Field(default=None, description="The Revision's Project ID")
    project_revision_hooks: Optional[List[NormalizedProjectRevisionHook]] = None
    scim_clients: Optional[List[NormalizedProjectRevisionScimClient]] = None
    serve_admin_cors_allowed_origins: Optional[List[StrictStr]] = None
    serve_admin_cors_enabled: Optional[StrictBool] = Field(default=None, description="Enable CORS headers on all admin APIs  This governs the \"serve.admin.cors.enabled\" setting.")
    serve_public_cors_allowed_origins: Optional[List[StrictStr]] = None
    serve_public_cors_enabled: Optional[StrictBool] = Field(default=None, description="Enable CORS headers on all public APIs  This governs the \"serve.public.cors.enabled\" setting.")
    strict_security: Optional[StrictBool] = Field(default=None, description="Whether the project should employ strict security measures. Setting this to true is recommended for going into production.")
    updated_at: Optional[datetime] = Field(default=None, description="Last Time Project's Revision was Updated")
    workspace_id: Optional[StrictStr] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["account_experience_default_locale", "account_experience_favicon_dark", "account_experience_favicon_light", "account_experience_locale_behavior", "account_experience_logo_dark", "account_experience_logo_light", "account_experience_theme_variables_dark", "account_experience_theme_variables_light", "created_at", "disable_account_experience_welcome_screen", "enable_ax_v2", "environment", "home_region", "hydra_oauth2_allowed_top_level_claims", "hydra_oauth2_client_credentials_default_grant_allowed_scope", "hydra_oauth2_exclude_not_before_claim", "hydra_oauth2_grant_jwt_iat_optional", "hydra_oauth2_grant_jwt_jti_optional", "hydra_oauth2_grant_jwt_max_ttl", "hydra_oauth2_grant_refresh_token_rotation_grace_period", "hydra_oauth2_mirror_top_level_claims", "hydra_oauth2_pkce_enforced", "hydra_oauth2_pkce_enforced_for_public_clients", "hydra_oauth2_refresh_token_hook", "hydra_oauth2_token_hook", "hydra_oidc_dynamic_client_registration_default_scope", "hydra_oidc_dynamic_client_registration_enabled", "hydra_oidc_subject_identifiers_pairwise_salt", "hydra_oidc_subject_identifiers_supported_types", "hydra_secrets_cookie", "hydra_secrets_pagination", "hydra_secrets_system", "hydra_serve_cookies_same_site_legacy_workaround", "hydra_serve_cookies_same_site_mode", "hydra_strategies_access_token", "hydra_strategies_jwt_scope_claim", "hydra_strategies_scope", "hydra_ttl_access_token", "hydra_ttl_auth_code", "hydra_ttl_id_token", "hydra_ttl_login_consent_request", "hydra_ttl_refresh_token", "hydra_urls_consent", "hydra_urls_error", "hydra_urls_login", "hydra_urls_logout", "hydra_urls_post_logout_redirect", "hydra_urls_registration", "hydra_urls_self_issuer", "hydra_webfinger_jwks_broadcast_keys", "hydra_webfinger_oidc_discovery_auth_url", "hydra_webfinger_oidc_discovery_client_registration_url", "hydra_webfinger_oidc_discovery_jwks_url", "hydra_webfinger_oidc_discovery_supported_claims", "hydra_webfinger_oidc_discovery_supported_scope", "hydra_webfinger_oidc_discovery_token_url", "hydra_webfinger_oidc_discovery_userinfo_url", "id", "keto_namespace_configuration", "keto_namespaces", "keto_secrets_pagination", "kratos_cookies_same_site", "kratos_courier_channels", "kratos_courier_delivery_strategy", "kratos_courier_http_request_config_auth_api_key_in", "kratos_courier_http_request_config_auth_api_key_name", "kratos_courier_http_request_config_auth_api_key_value", "kratos_courier_http_request_config_auth_basic_auth_password", "kratos_courier_http_request_config_auth_basic_auth_user", "kratos_courier_http_request_config_auth_type", "kratos_courier_http_request_config_body", "kratos_courier_http_request_config_headers", "kratos_courier_http_request_config_method", "kratos_courier_http_request_config_url", "kratos_courier_smtp_connection_uri", "kratos_courier_smtp_from_address", "kratos_courier_smtp_from_name", "kratos_courier_smtp_headers", "kratos_courier_smtp_local_name", "kratos_courier_templates_login_code_valid_email_body_html", "kratos_courier_templates_login_code_valid_email_body_plaintext", "kratos_courier_templates_login_code_valid_email_subject", "kratos_courier_templates_login_code_valid_sms_body_plaintext", "kratos_courier_templates_recovery_code_invalid_email_body_html", "kratos_courier_templates_recovery_code_invalid_email_body_plaintext", "kratos_courier_templates_recovery_code_invalid_email_subject", "kratos_courier_templates_recovery_code_valid_email_body_html", "kratos_courier_templates_recovery_code_valid_email_body_plaintext", "kratos_courier_templates_recovery_code_valid_email_subject", "kratos_courier_templates_recovery_invalid_email_body_html", "kratos_courier_templates_recovery_invalid_email_body_plaintext", "kratos_courier_templates_recovery_invalid_email_subject", "kratos_courier_templates_recovery_valid_email_body_html", "kratos_courier_templates_recovery_valid_email_body_plaintext", "kratos_courier_templates_recovery_valid_email_subject", "kratos_courier_templates_registration_code_valid_email_body_html", "kratos_courier_templates_registration_code_valid_email_body_plaintext", "kratos_courier_templates_registration_code_valid_email_subject", "kratos_courier_templates_registration_code_valid_sms_body_plaintext", "kratos_courier_templates_verification_code_invalid_email_body_html", "kratos_courier_templates_verification_code_invalid_email_body_plaintext", "kratos_courier_templates_verification_code_invalid_email_subject", "kratos_courier_templates_verification_code_valid_email_body_html", "kratos_courier_templates_verification_code_valid_email_body_plaintext", "kratos_courier_templates_verification_code_valid_email_subject", "kratos_courier_templates_verification_code_valid_sms_body_plaintext", "kratos_courier_templates_verification_invalid_email_body_html", "kratos_courier_templates_verification_invalid_email_body_plaintext", "kratos_courier_templates_verification_invalid_email_subject", "kratos_courier_templates_verification_valid_email_body_html", "kratos_courier_templates_verification_valid_email_body_plaintext", "kratos_courier_templates_verification_valid_email_subject", "kratos_feature_flags_cacheable_sessions", "kratos_feature_flags_cacheable_sessions_max_age", "kratos_feature_flags_choose_recovery_address", "kratos_feature_flags_faster_session_extend", "kratos_feature_flags_legacy_continue_with_verification_ui", "kratos_feature_flags_legacy_oidc_registration_node_group", "kratos_feature_flags_legacy_require_verified_login_error", "kratos_feature_flags_password_profile_registration_node_group", "kratos_feature_flags_use_continue_with_transitions", "kratos_identity_schemas", "kratos_oauth2_provider_headers", "kratos_oauth2_provider_override_return_to", "kratos_oauth2_provider_url", "kratos_preview_default_read_consistency_level", "kratos_secrets_cipher", "kratos_secrets_cookie", "kratos_secrets_default", "kratos_security_account_enumeration_mitigate", "kratos_selfservice_allowed_return_urls", "kratos_selfservice_default_browser_return_url", "kratos_selfservice_flows_error_ui_url", "kratos_selfservice_flows_login_after_code_default_browser_return_url", "kratos_selfservice_flows_login_after_default_browser_return_url", "kratos_selfservice_flows_login_after_lookup_secret_default_browser_return_url", "kratos_selfservice_flows_login_after_oidc_default_browser_return_url", "kratos_selfservice_flows_login_after_passkey_default_browser_return_url", "kratos_selfservice_flows_login_after_password_default_browser_return_url", "kratos_selfservice_flows_login_after_totp_default_browser_return_url", "kratos_selfservice_flows_login_after_webauthn_default_browser_return_url", "kratos_selfservice_flows_login_lifespan", "kratos_selfservice_flows_login_ui_url", "kratos_selfservice_flows_logout_after_default_browser_return_url", "kratos_selfservice_flows_recovery_after_default_browser_return_url", "kratos_selfservice_flows_recovery_enabled", "kratos_selfservice_flows_recovery_lifespan", "kratos_selfservice_flows_recovery_notify_unknown_recipients", "kratos_selfservice_flows_recovery_ui_url", "kratos_selfservice_flows_recovery_use", "kratos_selfservice_flows_registration_after_code_default_browser_return_url", "kratos_selfservice_flows_registration_after_default_browser_return_url", "kratos_selfservice_flows_registration_after_oidc_default_browser_return_url", "kratos_selfservice_flows_registration_after_passkey_default_browser_return_url", "kratos_selfservice_flows_registration_after_password_default_browser_return_url", "kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url", "kratos_selfservice_flows_registration_enable_legacy_one_step", "kratos_selfservice_flows_registration_enabled", "kratos_selfservice_flows_registration_lifespan", "kratos_selfservice_flows_registration_login_hints", "kratos_selfservice_flows_registration_ui_url", "kratos_selfservice_flows_settings_after_default_browser_return_url", "kratos_selfservice_flows_settings_after_lookup_secret_default_browser_return_url", "kratos_selfservice_flows_settings_after_oidc_default_browser_return_url", "kratos_selfservice_flows_settings_after_passkey_default_browser_return_url", "kratos_selfservice_flows_settings_after_password_default_browser_return_url", "kratos_selfservice_flows_settings_after_profile_default_browser_return_url", "kratos_selfservice_flows_settings_after_totp_default_browser_return_url", "kratos_selfservice_flows_settings_after_webauthn_default_browser_return_url", "kratos_selfservice_flows_settings_lifespan", "kratos_selfservice_flows_settings_privileged_session_max_age", "kratos_selfservice_flows_settings_required_aal", "kratos_selfservice_flows_settings_ui_url", "kratos_selfservice_flows_verification_after_default_browser_return_url", "kratos_selfservice_flows_verification_enabled", "kratos_selfservice_flows_verification_lifespan", "kratos_selfservice_flows_verification_notify_unknown_recipients", "kratos_selfservice_flows_verification_ui_url", "kratos_selfservice_flows_verification_use", "kratos_selfservice_methods_captcha_config_cf_turnstile_secret", "kratos_selfservice_methods_captcha_config_cf_turnstile_sitekey", "kratos_selfservice_methods_captcha_config_legacy_inject_node", "kratos_selfservice_methods_captcha_enabled", "kratos_selfservice_methods_code_config_lifespan", "kratos_selfservice_methods_code_config_max_submissions", "kratos_selfservice_methods_code_config_missing_credential_fallback_enabled", "kratos_selfservice_methods_code_enabled", "kratos_selfservice_methods_code_mfa_enabled", "kratos_selfservice_methods_code_passwordless_enabled", "kratos_selfservice_methods_code_passwordless_login_fallback_enabled", "kratos_selfservice_methods_link_config_base_url", "kratos_selfservice_methods_link_config_lifespan", "kratos_selfservice_methods_link_enabled", "kratos_selfservice_methods_lookup_secret_enabled", "kratos_selfservice_methods_oidc_config_base_redirect_uri", "kratos_selfservice_methods_oidc_config_providers", "kratos_selfservice_methods_oidc_enable_auto_link_policy", "kratos_selfservice_methods_oidc_enabled", "kratos_selfservice_methods_passkey_config_rp_display_name", "kratos_selfservice_methods_passkey_config_rp_id", "kratos_selfservice_methods_passkey_config_rp_origins", "kratos_selfservice_methods_passkey_enabled", "kratos_selfservice_methods_password_config_haveibeenpwned_enabled", "kratos_selfservice_methods_password_config_identifier_similarity_check_enabled", "kratos_selfservice_methods_password_config_ignore_network_errors", "kratos_selfservice_methods_password_config_max_breaches", "kratos_selfservice_methods_password_config_min_password_length", "kratos_selfservice_methods_password_enabled", "kratos_selfservice_methods_profile_enabled", "kratos_selfservice_methods_saml_config_providers", "kratos_selfservice_methods_saml_enabled", "kratos_selfservice_methods_totp_config_issuer", "kratos_selfservice_methods_totp_enabled", "kratos_selfservice_methods_webauthn_config_passwordless", "kratos_selfservice_methods_webauthn_config_rp_display_name", "kratos_selfservice_methods_webauthn_config_rp_icon", "kratos_selfservice_methods_webauthn_config_rp_id", "kratos_selfservice_methods_webauthn_config_rp_origins", "kratos_selfservice_methods_webauthn_enabled", "kratos_session_cookie_persistent", "kratos_session_cookie_same_site", "kratos_session_lifespan", "kratos_session_whoami_required_aal", "kratos_session_whoami_tokenizer_templates", "name", "organizations", "project_id", "project_revision_hooks", "scim_clients", "serve_admin_cors_allowed_origins", "serve_admin_cors_enabled", "serve_public_cors_allowed_origins", "serve_public_cors_enabled", "strict_security", "updated_at", "workspace_id"]

    @field_validator('environment')
    def environment_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['prod', 'stage', 'dev']):
            raise ValueError("must be one of enum values ('prod', 'stage', 'dev')")
        return value

    @field_validator('home_region')
    def home_region_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['eu-central', 'asia-northeast', 'us-east', 'us-west', 'us', 'global']):
            raise ValueError("must be one of enum values ('eu-central', 'asia-northeast', 'us-east', 'us-west', 'us', 'global')")
        return value

    @field_validator('hydra_oauth2_grant_jwt_max_ttl')
    def hydra_oauth2_grant_jwt_max_ttl_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+(ns|us|ms|s|m|h)$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+(ns|us|ms|s|m|h)$/")
        return value

    @field_validator('hydra_strategies_access_token')
    def hydra_strategies_access_token_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['opaque', 'jwt']):
            raise ValueError("must be one of enum values ('opaque', 'jwt')")
        return value

    @field_validator('hydra_strategies_jwt_scope_claim')
    def hydra_strategies_jwt_scope_claim_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['list', 'string', 'both']):
            raise ValueError("must be one of enum values ('list', 'string', 'both')")
        return value

    @field_validator('hydra_strategies_scope')
    def hydra_strategies_scope_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['exact', 'wildcard']):
            raise ValueError("must be one of enum values ('exact', 'wildcard')")
        return value

    @field_validator('hydra_ttl_access_token')
    def hydra_ttl_access_token_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+(ns|us|ms|s|m|h)$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+(ns|us|ms|s|m|h)$/")
        return value

    @field_validator('hydra_ttl_auth_code')
    def hydra_ttl_auth_code_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+(ns|us|ms|s|m|h)$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+(ns|us|ms|s|m|h)$/")
        return value

    @field_validator('hydra_ttl_id_token')
    def hydra_ttl_id_token_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+(ns|us|ms|s|m|h)$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+(ns|us|ms|s|m|h)$/")
        return value

    @field_validator('hydra_ttl_login_consent_request')
    def hydra_ttl_login_consent_request_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[0-9]+(ns|us|ms|s|m|h)$", value):
            raise ValueError(r"must validate the regular expression /^[0-9]+(ns|us|ms|s|m|h)$/")
        return value

    @field_validator('hydra_ttl_refresh_token')
    def hydra_ttl_refresh_token_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^([0-9]+(ns|us|ms|s|m|h)|-1)$", value):
            raise ValueError(r"must validate the regular expression /^([0-9]+(ns|us|ms|s|m|h)|-1)$/")
        return value

    @field_validator('kratos_selfservice_flows_recovery_use')
    def kratos_selfservice_flows_recovery_use_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['link', 'code']):
            raise ValueError("must be one of enum values ('link', 'code')")
        return value

    @field_validator('kratos_selfservice_flows_verification_use')
    def kratos_selfservice_flows_verification_use_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['link', 'code']):
            raise ValueError("must be one of enum values ('link', 'code')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateProjectNormalizedPayload from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "created_at",
            "id",
            "updated_at",
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in keto_namespaces (list)
        _items = []
        if self.keto_namespaces:
            for _item_keto_namespaces in self.keto_namespaces:
                if _item_keto_namespaces:
                    _items.append(_item_keto_namespaces.to_dict())
            _dict['keto_namespaces'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kratos_courier_channels (list)
        _items = []
        if self.kratos_courier_channels:
            for _item_kratos_courier_channels in self.kratos_courier_channels:
                if _item_kratos_courier_channels:
                    _items.append(_item_kratos_courier_channels.to_dict())
            _dict['kratos_courier_channels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kratos_identity_schemas (list)
        _items = []
        if self.kratos_identity_schemas:
            for _item_kratos_identity_schemas in self.kratos_identity_schemas:
                if _item_kratos_identity_schemas:
                    _items.append(_item_kratos_identity_schemas.to_dict())
            _dict['kratos_identity_schemas'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kratos_selfservice_methods_oidc_config_providers (list)
        _items = []
        if self.kratos_selfservice_methods_oidc_config_providers:
            for _item_kratos_selfservice_methods_oidc_config_providers in self.kratos_selfservice_methods_oidc_config_providers:
                if _item_kratos_selfservice_methods_oidc_config_providers:
                    _items.append(_item_kratos_selfservice_methods_oidc_config_providers.to_dict())
            _dict['kratos_selfservice_methods_oidc_config_providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kratos_selfservice_methods_saml_config_providers (list)
        _items = []
        if self.kratos_selfservice_methods_saml_config_providers:
            for _item_kratos_selfservice_methods_saml_config_providers in self.kratos_selfservice_methods_saml_config_providers:
                if _item_kratos_selfservice_methods_saml_config_providers:
                    _items.append(_item_kratos_selfservice_methods_saml_config_providers.to_dict())
            _dict['kratos_selfservice_methods_saml_config_providers'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in kratos_session_whoami_tokenizer_templates (list)
        _items = []
        if self.kratos_session_whoami_tokenizer_templates:
            for _item_kratos_session_whoami_tokenizer_templates in self.kratos_session_whoami_tokenizer_templates:
                if _item_kratos_session_whoami_tokenizer_templates:
                    _items.append(_item_kratos_session_whoami_tokenizer_templates.to_dict())
            _dict['kratos_session_whoami_tokenizer_templates'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in organizations (list)
        _items = []
        if self.organizations:
            for _item_organizations in self.organizations:
                if _item_organizations:
                    _items.append(_item_organizations.to_dict())
            _dict['organizations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in project_revision_hooks (list)
        _items = []
        if self.project_revision_hooks:
            for _item_project_revision_hooks in self.project_revision_hooks:
                if _item_project_revision_hooks:
                    _items.append(_item_project_revision_hooks.to_dict())
            _dict['project_revision_hooks'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in scim_clients (list)
        _items = []
        if self.scim_clients:
            for _item_scim_clients in self.scim_clients:
                if _item_scim_clients:
                    _items.append(_item_scim_clients.to_dict())
            _dict['scim_clients'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if kratos_courier_http_request_config_headers (nullable) is None
        # and model_fields_set contains the field
        if self.kratos_courier_http_request_config_headers is None and "kratos_courier_http_request_config_headers" in self.model_fields_set:
            _dict['kratos_courier_http_request_config_headers'] = None

        # set to None if kratos_courier_smtp_headers (nullable) is None
        # and model_fields_set contains the field
        if self.kratos_courier_smtp_headers is None and "kratos_courier_smtp_headers" in self.model_fields_set:
            _dict['kratos_courier_smtp_headers'] = None

        # set to None if kratos_oauth2_provider_headers (nullable) is None
        # and model_fields_set contains the field
        if self.kratos_oauth2_provider_headers is None and "kratos_oauth2_provider_headers" in self.model_fields_set:
            _dict['kratos_oauth2_provider_headers'] = None

        # set to None if kratos_selfservice_methods_code_config_max_submissions (nullable) is None
        # and model_fields_set contains the field
        if self.kratos_selfservice_methods_code_config_max_submissions is None and "kratos_selfservice_methods_code_config_max_submissions" in self.model_fields_set:
            _dict['kratos_selfservice_methods_code_config_max_submissions'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateProjectNormalizedPayload from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "account_experience_default_locale": obj.get("account_experience_default_locale"),
            "account_experience_favicon_dark": obj.get("account_experience_favicon_dark"),
            "account_experience_favicon_light": obj.get("account_experience_favicon_light"),
            "account_experience_locale_behavior": obj.get("account_experience_locale_behavior"),
            "account_experience_logo_dark": obj.get("account_experience_logo_dark"),
            "account_experience_logo_light": obj.get("account_experience_logo_light"),
            "account_experience_theme_variables_dark": obj.get("account_experience_theme_variables_dark"),
            "account_experience_theme_variables_light": obj.get("account_experience_theme_variables_light"),
            "created_at": obj.get("created_at"),
            "disable_account_experience_welcome_screen": obj.get("disable_account_experience_welcome_screen"),
            "enable_ax_v2": obj.get("enable_ax_v2"),
            "environment": obj.get("environment"),
            "home_region": obj.get("home_region"),
            "hydra_oauth2_allowed_top_level_claims": obj.get("hydra_oauth2_allowed_top_level_claims"),
            "hydra_oauth2_client_credentials_default_grant_allowed_scope": obj.get("hydra_oauth2_client_credentials_default_grant_allowed_scope"),
            "hydra_oauth2_exclude_not_before_claim": obj.get("hydra_oauth2_exclude_not_before_claim"),
            "hydra_oauth2_grant_jwt_iat_optional": obj.get("hydra_oauth2_grant_jwt_iat_optional"),
            "hydra_oauth2_grant_jwt_jti_optional": obj.get("hydra_oauth2_grant_jwt_jti_optional"),
            "hydra_oauth2_grant_jwt_max_ttl": obj.get("hydra_oauth2_grant_jwt_max_ttl") if obj.get("hydra_oauth2_grant_jwt_max_ttl") is not None else '720h',
            "hydra_oauth2_grant_refresh_token_rotation_grace_period": obj.get("hydra_oauth2_grant_refresh_token_rotation_grace_period"),
            "hydra_oauth2_mirror_top_level_claims": obj.get("hydra_oauth2_mirror_top_level_claims"),
            "hydra_oauth2_pkce_enforced": obj.get("hydra_oauth2_pkce_enforced"),
            "hydra_oauth2_pkce_enforced_for_public_clients": obj.get("hydra_oauth2_pkce_enforced_for_public_clients"),
            "hydra_oauth2_refresh_token_hook": obj.get("hydra_oauth2_refresh_token_hook"),
            "hydra_oauth2_token_hook": obj.get("hydra_oauth2_token_hook"),
            "hydra_oidc_dynamic_client_registration_default_scope": obj.get("hydra_oidc_dynamic_client_registration_default_scope"),
            "hydra_oidc_dynamic_client_registration_enabled": obj.get("hydra_oidc_dynamic_client_registration_enabled"),
            "hydra_oidc_subject_identifiers_pairwise_salt": obj.get("hydra_oidc_subject_identifiers_pairwise_salt"),
            "hydra_oidc_subject_identifiers_supported_types": obj.get("hydra_oidc_subject_identifiers_supported_types"),
            "hydra_secrets_cookie": obj.get("hydra_secrets_cookie"),
            "hydra_secrets_pagination": obj.get("hydra_secrets_pagination"),
            "hydra_secrets_system": obj.get("hydra_secrets_system"),
            "hydra_serve_cookies_same_site_legacy_workaround": obj.get("hydra_serve_cookies_same_site_legacy_workaround"),
            "hydra_serve_cookies_same_site_mode": obj.get("hydra_serve_cookies_same_site_mode"),
            "hydra_strategies_access_token": obj.get("hydra_strategies_access_token") if obj.get("hydra_strategies_access_token") is not None else 'opaque',
            "hydra_strategies_jwt_scope_claim": obj.get("hydra_strategies_jwt_scope_claim") if obj.get("hydra_strategies_jwt_scope_claim") is not None else 'list',
            "hydra_strategies_scope": obj.get("hydra_strategies_scope") if obj.get("hydra_strategies_scope") is not None else 'wildcard',
            "hydra_ttl_access_token": obj.get("hydra_ttl_access_token") if obj.get("hydra_ttl_access_token") is not None else '30m',
            "hydra_ttl_auth_code": obj.get("hydra_ttl_auth_code") if obj.get("hydra_ttl_auth_code") is not None else '720h',
            "hydra_ttl_id_token": obj.get("hydra_ttl_id_token") if obj.get("hydra_ttl_id_token") is not None else '30m',
            "hydra_ttl_login_consent_request": obj.get("hydra_ttl_login_consent_request") if obj.get("hydra_ttl_login_consent_request") is not None else '30m',
            "hydra_ttl_refresh_token": obj.get("hydra_ttl_refresh_token") if obj.get("hydra_ttl_refresh_token") is not None else '720h',
            "hydra_urls_consent": obj.get("hydra_urls_consent"),
            "hydra_urls_error": obj.get("hydra_urls_error"),
            "hydra_urls_login": obj.get("hydra_urls_login"),
            "hydra_urls_logout": obj.get("hydra_urls_logout"),
            "hydra_urls_post_logout_redirect": obj.get("hydra_urls_post_logout_redirect"),
            "hydra_urls_registration": obj.get("hydra_urls_registration"),
            "hydra_urls_self_issuer": obj.get("hydra_urls_self_issuer"),
            "hydra_webfinger_jwks_broadcast_keys": obj.get("hydra_webfinger_jwks_broadcast_keys"),
            "hydra_webfinger_oidc_discovery_auth_url": obj.get("hydra_webfinger_oidc_discovery_auth_url"),
            "hydra_webfinger_oidc_discovery_client_registration_url": obj.get("hydra_webfinger_oidc_discovery_client_registration_url"),
            "hydra_webfinger_oidc_discovery_jwks_url": obj.get("hydra_webfinger_oidc_discovery_jwks_url"),
            "hydra_webfinger_oidc_discovery_supported_claims": obj.get("hydra_webfinger_oidc_discovery_supported_claims"),
            "hydra_webfinger_oidc_discovery_supported_scope": obj.get("hydra_webfinger_oidc_discovery_supported_scope"),
            "hydra_webfinger_oidc_discovery_token_url": obj.get("hydra_webfinger_oidc_discovery_token_url"),
            "hydra_webfinger_oidc_discovery_userinfo_url": obj.get("hydra_webfinger_oidc_discovery_userinfo_url"),
            "id": obj.get("id"),
            "keto_namespace_configuration": obj.get("keto_namespace_configuration"),
            "keto_namespaces": [KetoNamespace.from_dict(_item) for _item in obj["keto_namespaces"]] if obj.get("keto_namespaces") is not None else None,
            "keto_secrets_pagination": obj.get("keto_secrets_pagination"),
            "kratos_cookies_same_site": obj.get("kratos_cookies_same_site"),
            "kratos_courier_channels": [NormalizedProjectRevisionCourierChannel.from_dict(_item) for _item in obj["kratos_courier_channels"]] if obj.get("kratos_courier_channels") is not None else None,
            "kratos_courier_delivery_strategy": obj.get("kratos_courier_delivery_strategy") if obj.get("kratos_courier_delivery_strategy") is not None else 'smtp',
            "kratos_courier_http_request_config_auth_api_key_in": obj.get("kratos_courier_http_request_config_auth_api_key_in"),
            "kratos_courier_http_request_config_auth_api_key_name": obj.get("kratos_courier_http_request_config_auth_api_key_name"),
            "kratos_courier_http_request_config_auth_api_key_value": obj.get("kratos_courier_http_request_config_auth_api_key_value"),
            "kratos_courier_http_request_config_auth_basic_auth_password": obj.get("kratos_courier_http_request_config_auth_basic_auth_password"),
            "kratos_courier_http_request_config_auth_basic_auth_user": obj.get("kratos_courier_http_request_config_auth_basic_auth_user"),
            "kratos_courier_http_request_config_auth_type": obj.get("kratos_courier_http_request_config_auth_type") if obj.get("kratos_courier_http_request_config_auth_type") is not None else 'empty (no authentication)',
            "kratos_courier_http_request_config_body": obj.get("kratos_courier_http_request_config_body"),
            "kratos_courier_http_request_config_headers": obj.get("kratos_courier_http_request_config_headers"),
            "kratos_courier_http_request_config_method": obj.get("kratos_courier_http_request_config_method") if obj.get("kratos_courier_http_request_config_method") is not None else 'POST',
            "kratos_courier_http_request_config_url": obj.get("kratos_courier_http_request_config_url"),
            "kratos_courier_smtp_connection_uri": obj.get("kratos_courier_smtp_connection_uri"),
            "kratos_courier_smtp_from_address": obj.get("kratos_courier_smtp_from_address"),
            "kratos_courier_smtp_from_name": obj.get("kratos_courier_smtp_from_name"),
            "kratos_courier_smtp_headers": obj.get("kratos_courier_smtp_headers"),
            "kratos_courier_smtp_local_name": obj.get("kratos_courier_smtp_local_name"),
            "kratos_courier_templates_login_code_valid_email_body_html": obj.get("kratos_courier_templates_login_code_valid_email_body_html"),
            "kratos_courier_templates_login_code_valid_email_body_plaintext": obj.get("kratos_courier_templates_login_code_valid_email_body_plaintext"),
            "kratos_courier_templates_login_code_valid_email_subject": obj.get("kratos_courier_templates_login_code_valid_email_subject"),
            "kratos_courier_templates_login_code_valid_sms_body_plaintext": obj.get("kratos_courier_templates_login_code_valid_sms_body_plaintext"),
            "kratos_courier_templates_recovery_code_invalid_email_body_html": obj.get("kratos_courier_templates_recovery_code_invalid_email_body_html"),
            "kratos_courier_templates_recovery_code_invalid_email_body_plaintext": obj.get("kratos_courier_templates_recovery_code_invalid_email_body_plaintext"),
            "kratos_courier_templates_recovery_code_invalid_email_subject": obj.get("kratos_courier_templates_recovery_code_invalid_email_subject"),
            "kratos_courier_templates_recovery_code_valid_email_body_html": obj.get("kratos_courier_templates_recovery_code_valid_email_body_html"),
            "kratos_courier_templates_recovery_code_valid_email_body_plaintext": obj.get("kratos_courier_templates_recovery_code_valid_email_body_plaintext"),
            "kratos_courier_templates_recovery_code_valid_email_subject": obj.get("kratos_courier_templates_recovery_code_valid_email_subject"),
            "kratos_courier_templates_recovery_invalid_email_body_html": obj.get("kratos_courier_templates_recovery_invalid_email_body_html"),
            "kratos_courier_templates_recovery_invalid_email_body_plaintext": obj.get("kratos_courier_templates_recovery_invalid_email_body_plaintext"),
            "kratos_courier_templates_recovery_invalid_email_subject": obj.get("kratos_courier_templates_recovery_invalid_email_subject"),
            "kratos_courier_templates_recovery_valid_email_body_html": obj.get("kratos_courier_templates_recovery_valid_email_body_html"),
            "kratos_courier_templates_recovery_valid_email_body_plaintext": obj.get("kratos_courier_templates_recovery_valid_email_body_plaintext"),
            "kratos_courier_templates_recovery_valid_email_subject": obj.get("kratos_courier_templates_recovery_valid_email_subject"),
            "kratos_courier_templates_registration_code_valid_email_body_html": obj.get("kratos_courier_templates_registration_code_valid_email_body_html"),
            "kratos_courier_templates_registration_code_valid_email_body_plaintext": obj.get("kratos_courier_templates_registration_code_valid_email_body_plaintext"),
            "kratos_courier_templates_registration_code_valid_email_subject": obj.get("kratos_courier_templates_registration_code_valid_email_subject"),
            "kratos_courier_templates_registration_code_valid_sms_body_plaintext": obj.get("kratos_courier_templates_registration_code_valid_sms_body_plaintext"),
            "kratos_courier_templates_verification_code_invalid_email_body_html": obj.get("kratos_courier_templates_verification_code_invalid_email_body_html"),
            "kratos_courier_templates_verification_code_invalid_email_body_plaintext": obj.get("kratos_courier_templates_verification_code_invalid_email_body_plaintext"),
            "kratos_courier_templates_verification_code_invalid_email_subject": obj.get("kratos_courier_templates_verification_code_invalid_email_subject"),
            "kratos_courier_templates_verification_code_valid_email_body_html": obj.get("kratos_courier_templates_verification_code_valid_email_body_html"),
            "kratos_courier_templates_verification_code_valid_email_body_plaintext": obj.get("kratos_courier_templates_verification_code_valid_email_body_plaintext"),
            "kratos_courier_templates_verification_code_valid_email_subject": obj.get("kratos_courier_templates_verification_code_valid_email_subject"),
            "kratos_courier_templates_verification_code_valid_sms_body_plaintext": obj.get("kratos_courier_templates_verification_code_valid_sms_body_plaintext"),
            "kratos_courier_templates_verification_invalid_email_body_html": obj.get("kratos_courier_templates_verification_invalid_email_body_html"),
            "kratos_courier_templates_verification_invalid_email_body_plaintext": obj.get("kratos_courier_templates_verification_invalid_email_body_plaintext"),
            "kratos_courier_templates_verification_invalid_email_subject": obj.get("kratos_courier_templates_verification_invalid_email_subject"),
            "kratos_courier_templates_verification_valid_email_body_html": obj.get("kratos_courier_templates_verification_valid_email_body_html"),
            "kratos_courier_templates_verification_valid_email_body_plaintext": obj.get("kratos_courier_templates_verification_valid_email_body_plaintext"),
            "kratos_courier_templates_verification_valid_email_subject": obj.get("kratos_courier_templates_verification_valid_email_subject"),
            "kratos_feature_flags_cacheable_sessions": obj.get("kratos_feature_flags_cacheable_sessions"),
            "kratos_feature_flags_cacheable_sessions_max_age": obj.get("kratos_feature_flags_cacheable_sessions_max_age"),
            "kratos_feature_flags_choose_recovery_address": obj.get("kratos_feature_flags_choose_recovery_address"),
            "kratos_feature_flags_faster_session_extend": obj.get("kratos_feature_flags_faster_session_extend"),
            "kratos_feature_flags_legacy_continue_with_verification_ui": obj.get("kratos_feature_flags_legacy_continue_with_verification_ui"),
            "kratos_feature_flags_legacy_oidc_registration_node_group": obj.get("kratos_feature_flags_legacy_oidc_registration_node_group"),
            "kratos_feature_flags_legacy_require_verified_login_error": obj.get("kratos_feature_flags_legacy_require_verified_login_error"),
            "kratos_feature_flags_password_profile_registration_node_group": obj.get("kratos_feature_flags_password_profile_registration_node_group"),
            "kratos_feature_flags_use_continue_with_transitions": obj.get("kratos_feature_flags_use_continue_with_transitions"),
            "kratos_identity_schemas": [NormalizedProjectRevisionIdentitySchema.from_dict(_item) for _item in obj["kratos_identity_schemas"]] if obj.get("kratos_identity_schemas") is not None else None,
            "kratos_oauth2_provider_headers": obj.get("kratos_oauth2_provider_headers"),
            "kratos_oauth2_provider_override_return_to": obj.get("kratos_oauth2_provider_override_return_to"),
            "kratos_oauth2_provider_url": obj.get("kratos_oauth2_provider_url"),
            "kratos_preview_default_read_consistency_level": obj.get("kratos_preview_default_read_consistency_level"),
            "kratos_secrets_cipher": obj.get("kratos_secrets_cipher"),
            "kratos_secrets_cookie": obj.get("kratos_secrets_cookie"),
            "kratos_secrets_default": obj.get("kratos_secrets_default"),
            "kratos_security_account_enumeration_mitigate": obj.get("kratos_security_account_enumeration_mitigate"),
            "kratos_selfservice_allowed_return_urls": obj.get("kratos_selfservice_allowed_return_urls"),
            "kratos_selfservice_default_browser_return_url": obj.get("kratos_selfservice_default_browser_return_url"),
            "kratos_selfservice_flows_error_ui_url": obj.get("kratos_selfservice_flows_error_ui_url"),
            "kratos_selfservice_flows_login_after_code_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_code_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_lookup_secret_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_lookup_secret_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_oidc_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_oidc_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_passkey_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_passkey_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_password_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_password_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_totp_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_totp_default_browser_return_url"),
            "kratos_selfservice_flows_login_after_webauthn_default_browser_return_url": obj.get("kratos_selfservice_flows_login_after_webauthn_default_browser_return_url"),
            "kratos_selfservice_flows_login_lifespan": obj.get("kratos_selfservice_flows_login_lifespan"),
            "kratos_selfservice_flows_login_ui_url": obj.get("kratos_selfservice_flows_login_ui_url"),
            "kratos_selfservice_flows_logout_after_default_browser_return_url": obj.get("kratos_selfservice_flows_logout_after_default_browser_return_url"),
            "kratos_selfservice_flows_recovery_after_default_browser_return_url": obj.get("kratos_selfservice_flows_recovery_after_default_browser_return_url"),
            "kratos_selfservice_flows_recovery_enabled": obj.get("kratos_selfservice_flows_recovery_enabled"),
            "kratos_selfservice_flows_recovery_lifespan": obj.get("kratos_selfservice_flows_recovery_lifespan"),
            "kratos_selfservice_flows_recovery_notify_unknown_recipients": obj.get("kratos_selfservice_flows_recovery_notify_unknown_recipients"),
            "kratos_selfservice_flows_recovery_ui_url": obj.get("kratos_selfservice_flows_recovery_ui_url"),
            "kratos_selfservice_flows_recovery_use": obj.get("kratos_selfservice_flows_recovery_use"),
            "kratos_selfservice_flows_registration_after_code_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_code_default_browser_return_url"),
            "kratos_selfservice_flows_registration_after_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_default_browser_return_url"),
            "kratos_selfservice_flows_registration_after_oidc_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_oidc_default_browser_return_url"),
            "kratos_selfservice_flows_registration_after_passkey_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_passkey_default_browser_return_url"),
            "kratos_selfservice_flows_registration_after_password_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_password_default_browser_return_url"),
            "kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url": obj.get("kratos_selfservice_flows_registration_after_webauthn_default_browser_return_url"),
            "kratos_selfservice_flows_registration_enable_legacy_one_step": obj.get("kratos_selfservice_flows_registration_enable_legacy_one_step"),
            "kratos_selfservice_flows_registration_enabled": obj.get("kratos_selfservice_flows_registration_enabled"),
            "kratos_selfservice_flows_registration_lifespan": obj.get("kratos_selfservice_flows_registration_lifespan"),
            "kratos_selfservice_flows_registration_login_hints": obj.get("kratos_selfservice_flows_registration_login_hints"),
            "kratos_selfservice_flows_registration_ui_url": obj.get("kratos_selfservice_flows_registration_ui_url"),
            "kratos_selfservice_flows_settings_after_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_lookup_secret_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_lookup_secret_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_oidc_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_oidc_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_passkey_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_passkey_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_password_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_password_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_profile_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_profile_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_totp_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_totp_default_browser_return_url"),
            "kratos_selfservice_flows_settings_after_webauthn_default_browser_return_url": obj.get("kratos_selfservice_flows_settings_after_webauthn_default_browser_return_url"),
            "kratos_selfservice_flows_settings_lifespan": obj.get("kratos_selfservice_flows_settings_lifespan"),
            "kratos_selfservice_flows_settings_privileged_session_max_age": obj.get("kratos_selfservice_flows_settings_privileged_session_max_age"),
            "kratos_selfservice_flows_settings_required_aal": obj.get("kratos_selfservice_flows_settings_required_aal"),
            "kratos_selfservice_flows_settings_ui_url": obj.get("kratos_selfservice_flows_settings_ui_url"),
            "kratos_selfservice_flows_verification_after_default_browser_return_url": obj.get("kratos_selfservice_flows_verification_after_default_browser_return_url"),
            "kratos_selfservice_flows_verification_enabled": obj.get("kratos_selfservice_flows_verification_enabled"),
            "kratos_selfservice_flows_verification_lifespan": obj.get("kratos_selfservice_flows_verification_lifespan"),
            "kratos_selfservice_flows_verification_notify_unknown_recipients": obj.get("kratos_selfservice_flows_verification_notify_unknown_recipients"),
            "kratos_selfservice_flows_verification_ui_url": obj.get("kratos_selfservice_flows_verification_ui_url"),
            "kratos_selfservice_flows_verification_use": obj.get("kratos_selfservice_flows_verification_use"),
            "kratos_selfservice_methods_captcha_config_cf_turnstile_secret": obj.get("kratos_selfservice_methods_captcha_config_cf_turnstile_secret"),
            "kratos_selfservice_methods_captcha_config_cf_turnstile_sitekey": obj.get("kratos_selfservice_methods_captcha_config_cf_turnstile_sitekey"),
            "kratos_selfservice_methods_captcha_config_legacy_inject_node": obj.get("kratos_selfservice_methods_captcha_config_legacy_inject_node"),
            "kratos_selfservice_methods_captcha_enabled": obj.get("kratos_selfservice_methods_captcha_enabled"),
            "kratos_selfservice_methods_code_config_lifespan": obj.get("kratos_selfservice_methods_code_config_lifespan"),
            "kratos_selfservice_methods_code_config_max_submissions": obj.get("kratos_selfservice_methods_code_config_max_submissions"),
            "kratos_selfservice_methods_code_config_missing_credential_fallback_enabled": obj.get("kratos_selfservice_methods_code_config_missing_credential_fallback_enabled"),
            "kratos_selfservice_methods_code_enabled": obj.get("kratos_selfservice_methods_code_enabled"),
            "kratos_selfservice_methods_code_mfa_enabled": obj.get("kratos_selfservice_methods_code_mfa_enabled"),
            "kratos_selfservice_methods_code_passwordless_enabled": obj.get("kratos_selfservice_methods_code_passwordless_enabled"),
            "kratos_selfservice_methods_code_passwordless_login_fallback_enabled": obj.get("kratos_selfservice_methods_code_passwordless_login_fallback_enabled"),
            "kratos_selfservice_methods_link_config_base_url": obj.get("kratos_selfservice_methods_link_config_base_url"),
            "kratos_selfservice_methods_link_config_lifespan": obj.get("kratos_selfservice_methods_link_config_lifespan"),
            "kratos_selfservice_methods_link_enabled": obj.get("kratos_selfservice_methods_link_enabled"),
            "kratos_selfservice_methods_lookup_secret_enabled": obj.get("kratos_selfservice_methods_lookup_secret_enabled"),
            "kratos_selfservice_methods_oidc_config_base_redirect_uri": obj.get("kratos_selfservice_methods_oidc_config_base_redirect_uri"),
            "kratos_selfservice_methods_oidc_config_providers": [NormalizedProjectRevisionThirdPartyProvider.from_dict(_item) for _item in obj["kratos_selfservice_methods_oidc_config_providers"]] if obj.get("kratos_selfservice_methods_oidc_config_providers") is not None else None,
            "kratos_selfservice_methods_oidc_enable_auto_link_policy": obj.get("kratos_selfservice_methods_oidc_enable_auto_link_policy"),
            "kratos_selfservice_methods_oidc_enabled": obj.get("kratos_selfservice_methods_oidc_enabled"),
            "kratos_selfservice_methods_passkey_config_rp_display_name": obj.get("kratos_selfservice_methods_passkey_config_rp_display_name"),
            "kratos_selfservice_methods_passkey_config_rp_id": obj.get("kratos_selfservice_methods_passkey_config_rp_id"),
            "kratos_selfservice_methods_passkey_config_rp_origins": obj.get("kratos_selfservice_methods_passkey_config_rp_origins"),
            "kratos_selfservice_methods_passkey_enabled": obj.get("kratos_selfservice_methods_passkey_enabled"),
            "kratos_selfservice_methods_password_config_haveibeenpwned_enabled": obj.get("kratos_selfservice_methods_password_config_haveibeenpwned_enabled"),
            "kratos_selfservice_methods_password_config_identifier_similarity_check_enabled": obj.get("kratos_selfservice_methods_password_config_identifier_similarity_check_enabled"),
            "kratos_selfservice_methods_password_config_ignore_network_errors": obj.get("kratos_selfservice_methods_password_config_ignore_network_errors"),
            "kratos_selfservice_methods_password_config_max_breaches": obj.get("kratos_selfservice_methods_password_config_max_breaches"),
            "kratos_selfservice_methods_password_config_min_password_length": obj.get("kratos_selfservice_methods_password_config_min_password_length"),
            "kratos_selfservice_methods_password_enabled": obj.get("kratos_selfservice_methods_password_enabled"),
            "kratos_selfservice_methods_profile_enabled": obj.get("kratos_selfservice_methods_profile_enabled"),
            "kratos_selfservice_methods_saml_config_providers": [NormalizedProjectRevisionSAMLProvider.from_dict(_item) for _item in obj["kratos_selfservice_methods_saml_config_providers"]] if obj.get("kratos_selfservice_methods_saml_config_providers") is not None else None,
            "kratos_selfservice_methods_saml_enabled": obj.get("kratos_selfservice_methods_saml_enabled"),
            "kratos_selfservice_methods_totp_config_issuer": obj.get("kratos_selfservice_methods_totp_config_issuer"),
            "kratos_selfservice_methods_totp_enabled": obj.get("kratos_selfservice_methods_totp_enabled"),
            "kratos_selfservice_methods_webauthn_config_passwordless": obj.get("kratos_selfservice_methods_webauthn_config_passwordless"),
            "kratos_selfservice_methods_webauthn_config_rp_display_name": obj.get("kratos_selfservice_methods_webauthn_config_rp_display_name"),
            "kratos_selfservice_methods_webauthn_config_rp_icon": obj.get("kratos_selfservice_methods_webauthn_config_rp_icon"),
            "kratos_selfservice_methods_webauthn_config_rp_id": obj.get("kratos_selfservice_methods_webauthn_config_rp_id"),
            "kratos_selfservice_methods_webauthn_config_rp_origins": obj.get("kratos_selfservice_methods_webauthn_config_rp_origins"),
            "kratos_selfservice_methods_webauthn_enabled": obj.get("kratos_selfservice_methods_webauthn_enabled"),
            "kratos_session_cookie_persistent": obj.get("kratos_session_cookie_persistent"),
            "kratos_session_cookie_same_site": obj.get("kratos_session_cookie_same_site"),
            "kratos_session_lifespan": obj.get("kratos_session_lifespan"),
            "kratos_session_whoami_required_aal": obj.get("kratos_session_whoami_required_aal"),
            "kratos_session_whoami_tokenizer_templates": [NormalizedProjectRevisionTokenizerTemplate.from_dict(_item) for _item in obj["kratos_session_whoami_tokenizer_templates"]] if obj.get("kratos_session_whoami_tokenizer_templates") is not None else None,
            "name": obj.get("name"),
            "organizations": [Organization.from_dict(_item) for _item in obj["organizations"]] if obj.get("organizations") is not None else None,
            "project_id": obj.get("project_id"),
            "project_revision_hooks": [NormalizedProjectRevisionHook.from_dict(_item) for _item in obj["project_revision_hooks"]] if obj.get("project_revision_hooks") is not None else None,
            "scim_clients": [NormalizedProjectRevisionScimClient.from_dict(_item) for _item in obj["scim_clients"]] if obj.get("scim_clients") is not None else None,
            "serve_admin_cors_allowed_origins": obj.get("serve_admin_cors_allowed_origins"),
            "serve_admin_cors_enabled": obj.get("serve_admin_cors_enabled"),
            "serve_public_cors_allowed_origins": obj.get("serve_public_cors_allowed_origins"),
            "serve_public_cors_enabled": obj.get("serve_public_cors_enabled"),
            "strict_security": obj.get("strict_security"),
            "updated_at": obj.get("updated_at"),
            "workspace_id": obj.get("workspace_id")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


