# mypy-boto3-macie

[![PyPI - mypy-boto3-macie](https://img.shields.io/pypi/v/mypy-boto3-macie.svg?color=blue)](https://pypi.org/project/mypy-boto3-macie)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-macie.svg?color=blue)](https://pypi.org/project/mypy-boto3-macie)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Macie 1.15.9](https://boto3.amazonaws.com/v1/documentation/api/1.15.9/reference/services/macie.html#Macie) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-macie](#mypy-boto3-macie)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Macie` service.

```bash
python -m pip install boto3-stubs[macie]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[macie]` in your environment: `python -m pip install 'boto3-stubs[macie]'`

Both type checking and auto-complete should work for `Macie` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[macie]` in your environment: `python -m pip install 'boto3-stubs[macie]'`

Both type checking and auto-complete should work for `Macie` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[macie]` in your environment: `python -m pip install 'boto3-stubs[macie]'`
- Run `mypy` as usual

Type checking should work for `Macie` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[macie]` in your environment: `python -m pip install 'boto3-stubs[macie]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Macie` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`MacieClient` provides annotations for `boto3.client("macie")`.

```python
import boto3

from mypy_boto3_macie import MacieClient

client: MacieClient = boto3.client("macie")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MacieClient = session.client("macie")
```

### Paginators annotations

`mypy_boto3_macie.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_macie import MacieClient
from mypy_boto3_macie.paginator import ListMemberAccountsPaginator, ListS3ResourcesPaginator

client: MacieClient = boto3.client("macie")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_member_accounts_paginator: ListMemberAccountsPaginator = client.get_paginator("list_member_accounts")
list_s3_resources_paginator: ListS3ResourcesPaginator = client.get_paginator("list_s3_resources")
```







### Typed dictionations

`mypy_boto3_macie.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_macie.type_defs import (
    AssociateS3ResourcesResultTypeDef,
    ClassificationTypeTypeDef,
    ClassificationTypeUpdateTypeDef,
    DisassociateS3ResourcesResultTypeDef,
    FailedS3ResourceTypeDef,
    ListMemberAccountsResultTypeDef,
    ListS3ResourcesResultTypeDef,
    MemberAccountTypeDef,
    PaginatorConfigTypeDef,
    S3ResourceClassificationTypeDef,
    S3ResourceClassificationUpdateTypeDef,
    S3ResourceTypeDef,
    UpdateS3ResourcesResultTypeDef,
)

def get_structure() -> ClassificationTypeTypeDef:
    return {
      ...
    }
```
