# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ArcadeProviders,
    AuthenticationServiceTypes,
    ConnectorTypes,
    EntityState,
    IntegrationServiceTypes,
    MCPServerTypes,
    OAuthProviders,
)


class GetConnector(BaseModel):
    connector: Optional["GetConnectorConnector"]


class GetConnectorConnector(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "GetConnectorConnectorOwner"
    state: EntityState
    type: Optional[ConnectorTypes]
    authentication: Optional["GetConnectorConnectorAuthentication"]
    integration: Optional["GetConnectorConnectorIntegration"]


class GetConnectorConnectorOwner(BaseModel):
    id: str


class GetConnectorConnectorAuthentication(BaseModel):
    type: AuthenticationServiceTypes
    microsoft: Optional["GetConnectorConnectorAuthenticationMicrosoft"]
    google: Optional["GetConnectorConnectorAuthenticationGoogle"]
    oauth: Optional["GetConnectorConnectorAuthenticationOauth"]
    arcade: Optional["GetConnectorConnectorAuthenticationArcade"]


class GetConnectorConnectorAuthenticationMicrosoft(BaseModel):
    tenant_id: str = Field(alias="tenantId")
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class GetConnectorConnectorAuthenticationGoogle(BaseModel):
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class GetConnectorConnectorAuthenticationOauth(BaseModel):
    refresh_token: str = Field(alias="refreshToken")
    provider: OAuthProviders
    metadata: Optional[str]


class GetConnectorConnectorAuthenticationArcade(BaseModel):
    authorization_id: str = Field(alias="authorizationId")
    provider: ArcadeProviders
    metadata: Optional[str]


class GetConnectorConnectorIntegration(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["GetConnectorConnectorIntegrationSlack"]
    email: Optional["GetConnectorConnectorIntegrationEmail"]
    twitter: Optional["GetConnectorConnectorIntegrationTwitter"]
    mcp: Optional["GetConnectorConnectorIntegrationMcp"]


class GetConnectorConnectorIntegrationSlack(BaseModel):
    token: str
    channel: str


class GetConnectorConnectorIntegrationEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class GetConnectorConnectorIntegrationTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class GetConnectorConnectorIntegrationMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


GetConnector.model_rebuild()
GetConnectorConnector.model_rebuild()
GetConnectorConnectorAuthentication.model_rebuild()
GetConnectorConnectorIntegration.model_rebuild()
