# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    CalendarAttendeeResponseStatus,
    CalendarEventStatus,
    CalendarEventVisibility,
    CalendarRecurrencePattern,
    CalendarReminderMethod,
    ContentTypes,
    EntityState,
    FileTypes,
    ImageProjectionTypes,
    LinkTypes,
    MailImportance,
    MailPriority,
    MailSensitivity,
    ObservableTypes,
    OccurrenceTypes,
    OrientationTypes,
    TextRoles,
)


class GetContent(BaseModel):
    content: Optional["GetContentContent"]


class GetContentContent(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    owner: "GetContentContentOwner"
    state: EntityState
    original_date: Optional[Any] = Field(alias="originalDate")
    finished_date: Optional[Any] = Field(alias="finishedDate")
    file_creation_date: Optional[Any] = Field(alias="fileCreationDate")
    file_modified_date: Optional[Any] = Field(alias="fileModifiedDate")
    workflow_duration: Optional[Any] = Field(alias="workflowDuration")
    uri: Optional[Any]
    description: Optional[str]
    identifier: Optional[str]
    markdown: Optional[str]
    address: Optional["GetContentContentAddress"]
    location: Optional["GetContentContentLocation"]
    h_3: Optional["GetContentContentH3"] = Field(alias="h3")
    boundary: Optional[str]
    epsg_code: Optional[int] = Field(alias="epsgCode")
    path: Optional[str]
    features: Optional[str]
    c_4_id: Optional[str] = Field(alias="c4id")
    type: Optional[ContentTypes]
    file_type: Optional[FileTypes] = Field(alias="fileType")
    mime_type: Optional[str] = Field(alias="mimeType")
    format: Optional[str]
    format_name: Optional[str] = Field(alias="formatName")
    file_extension: Optional[str] = Field(alias="fileExtension")
    file_name: Optional[str] = Field(alias="fileName")
    file_size: Optional[Any] = Field(alias="fileSize")
    master_uri: Optional[Any] = Field(alias="masterUri")
    image_uri: Optional[Any] = Field(alias="imageUri")
    text_uri: Optional[Any] = Field(alias="textUri")
    audio_uri: Optional[Any] = Field(alias="audioUri")
    transcript_uri: Optional[Any] = Field(alias="transcriptUri")
    summary: Optional[str]
    custom_summary: Optional[str] = Field(alias="customSummary")
    keywords: Optional[List[str]]
    bullets: Optional[List[str]]
    headlines: Optional[List[str]]
    posts: Optional[List[str]]
    chapters: Optional[List[str]]
    questions: Optional[List[str]]
    quotes: Optional[List[str]]
    video: Optional["GetContentContentVideo"]
    audio: Optional["GetContentContentAudio"]
    image: Optional["GetContentContentImage"]
    document: Optional["GetContentContentDocument"]
    email: Optional["GetContentContentEmail"]
    event: Optional["GetContentContentEvent"]
    issue: Optional["GetContentContentIssue"]
    package: Optional["GetContentContentPackage"]
    language: Optional["GetContentContentLanguage"]
    parent: Optional["GetContentContentParent"]
    children: Optional[List[Optional["GetContentContentChildren"]]]
    feed: Optional["GetContentContentFeed"]
    collections: Optional[List[Optional["GetContentContentCollections"]]]
    links: Optional[List["GetContentContentLinks"]]
    observations: Optional[List[Optional["GetContentContentObservations"]]]
    workflow: Optional["GetContentContentWorkflow"]
    pages: Optional[List["GetContentContentPages"]]
    segments: Optional[List["GetContentContentSegments"]]
    frames: Optional[List["GetContentContentFrames"]]
    error: Optional[str]


class GetContentContentOwner(BaseModel):
    id: str


class GetContentContentAddress(BaseModel):
    street_address: Optional[str] = Field(alias="streetAddress")
    city: Optional[str]
    region: Optional[str]
    country: Optional[str]
    postal_code: Optional[str] = Field(alias="postalCode")


class GetContentContentLocation(BaseModel):
    latitude: Optional[float]
    longitude: Optional[float]


class GetContentContentH3(BaseModel):
    h_3_r_0: Optional[str] = Field(alias="h3r0")
    h_3_r_1: Optional[str] = Field(alias="h3r1")
    h_3_r_2: Optional[str] = Field(alias="h3r2")
    h_3_r_3: Optional[str] = Field(alias="h3r3")
    h_3_r_4: Optional[str] = Field(alias="h3r4")
    h_3_r_5: Optional[str] = Field(alias="h3r5")
    h_3_r_6: Optional[str] = Field(alias="h3r6")
    h_3_r_7: Optional[str] = Field(alias="h3r7")
    h_3_r_8: Optional[str] = Field(alias="h3r8")
    h_3_r_9: Optional[str] = Field(alias="h3r9")
    h_3_r_10: Optional[str] = Field(alias="h3r10")
    h_3_r_11: Optional[str] = Field(alias="h3r11")
    h_3_r_12: Optional[str] = Field(alias="h3r12")
    h_3_r_13: Optional[str] = Field(alias="h3r13")
    h_3_r_14: Optional[str] = Field(alias="h3r14")
    h_3_r_15: Optional[str] = Field(alias="h3r15")


class GetContentContentVideo(BaseModel):
    width: Optional[int]
    height: Optional[int]
    duration: Optional[Any]
    make: Optional[str]
    model: Optional[str]
    software: Optional[str]
    title: Optional[str]
    description: Optional[str]
    keywords: Optional[List[Optional[str]]]
    author: Optional[str]


class GetContentContentAudio(BaseModel):
    keywords: Optional[List[Optional[str]]]
    author: Optional[str]
    series: Optional[str]
    episode: Optional[str]
    episode_type: Optional[str] = Field(alias="episodeType")
    season: Optional[str]
    publisher: Optional[str]
    copyright: Optional[str]
    genre: Optional[str]
    title: Optional[str]
    description: Optional[str]
    bitrate: Optional[int]
    channels: Optional[int]
    sample_rate: Optional[int] = Field(alias="sampleRate")
    bits_per_sample: Optional[int] = Field(alias="bitsPerSample")
    duration: Optional[Any]


class GetContentContentImage(BaseModel):
    width: Optional[int]
    height: Optional[int]
    resolution_x: Optional[int] = Field(alias="resolutionX")
    resolution_y: Optional[int] = Field(alias="resolutionY")
    bits_per_component: Optional[int] = Field(alias="bitsPerComponent")
    components: Optional[int]
    projection_type: Optional[ImageProjectionTypes] = Field(alias="projectionType")
    orientation: Optional[OrientationTypes]
    description: Optional[str]
    make: Optional[str]
    model: Optional[str]
    software: Optional[str]
    lens: Optional[str]
    focal_length: Optional[float] = Field(alias="focalLength")
    exposure_time: Optional[str] = Field(alias="exposureTime")
    f_number: Optional[str] = Field(alias="fNumber")
    iso: Optional[str]
    heading: Optional[float]
    pitch: Optional[float]


class GetContentContentDocument(BaseModel):
    title: Optional[str]
    subject: Optional[str]
    summary: Optional[str]
    author: Optional[str]
    publisher: Optional[str]
    description: Optional[str]
    keywords: Optional[List[Optional[str]]]
    page_count: Optional[int] = Field(alias="pageCount")
    worksheet_count: Optional[int] = Field(alias="worksheetCount")
    slide_count: Optional[int] = Field(alias="slideCount")
    word_count: Optional[int] = Field(alias="wordCount")
    line_count: Optional[int] = Field(alias="lineCount")
    paragraph_count: Optional[int] = Field(alias="paragraphCount")
    is_encrypted: Optional[bool] = Field(alias="isEncrypted")
    has_digital_signature: Optional[bool] = Field(alias="hasDigitalSignature")


class GetContentContentEmail(BaseModel):
    identifier: Optional[str]
    thread_identifier: Optional[str] = Field(alias="threadIdentifier")
    subject: Optional[str]
    labels: Optional[List[Optional[str]]]
    sensitivity: Optional[MailSensitivity]
    priority: Optional[MailPriority]
    importance: Optional[MailImportance]
    from_: Optional[List[Optional["GetContentContentEmailFrom"]]] = Field(alias="from")
    to: Optional[List[Optional["GetContentContentEmailTo"]]]
    cc: Optional[List[Optional["GetContentContentEmailCc"]]]
    bcc: Optional[List[Optional["GetContentContentEmailBcc"]]]


class GetContentContentEmailFrom(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class GetContentContentEmailTo(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class GetContentContentEmailCc(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class GetContentContentEmailBcc(BaseModel):
    name: Optional[str]
    email: Optional[str]
    given_name: Optional[str] = Field(alias="givenName")
    family_name: Optional[str] = Field(alias="familyName")


class GetContentContentEvent(BaseModel):
    event_identifier: Optional[str] = Field(alias="eventIdentifier")
    calendar_identifier: Optional[str] = Field(alias="calendarIdentifier")
    subject: Optional[str]
    start_date_time: Optional[Any] = Field(alias="startDateTime")
    end_date_time: Optional[Any] = Field(alias="endDateTime")
    is_all_day: Optional[bool] = Field(alias="isAllDay")
    timezone: Optional[str]
    status: Optional[CalendarEventStatus]
    visibility: Optional[CalendarEventVisibility]
    meeting_link: Optional[str] = Field(alias="meetingLink")
    organizer: Optional["GetContentContentEventOrganizer"]
    attendees: Optional[List[Optional["GetContentContentEventAttendees"]]]
    categories: Optional[List[Optional[str]]]
    reminders: Optional[List[Optional["GetContentContentEventReminders"]]]
    recurrence: Optional["GetContentContentEventRecurrence"]
    recurring_event_identifier: Optional[str] = Field(alias="recurringEventIdentifier")
    is_recurring: Optional[bool] = Field(alias="isRecurring")


class GetContentContentEventOrganizer(BaseModel):
    name: Optional[str]
    email: Optional[str]
    is_optional: Optional[bool] = Field(alias="isOptional")
    is_organizer: Optional[bool] = Field(alias="isOrganizer")
    response_status: Optional[CalendarAttendeeResponseStatus] = Field(
        alias="responseStatus"
    )


class GetContentContentEventAttendees(BaseModel):
    name: Optional[str]
    email: Optional[str]
    is_optional: Optional[bool] = Field(alias="isOptional")
    is_organizer: Optional[bool] = Field(alias="isOrganizer")
    response_status: Optional[CalendarAttendeeResponseStatus] = Field(
        alias="responseStatus"
    )


class GetContentContentEventReminders(BaseModel):
    minutes_before: Optional[int] = Field(alias="minutesBefore")
    method: Optional[CalendarReminderMethod]


class GetContentContentEventRecurrence(BaseModel):
    pattern: Optional[CalendarRecurrencePattern]
    interval: Optional[int]
    count: Optional[int]
    until: Optional[Any]
    days_of_week: Optional[List[Optional[str]]] = Field(alias="daysOfWeek")
    day_of_month: Optional[int] = Field(alias="dayOfMonth")
    month_of_year: Optional[int] = Field(alias="monthOfYear")


class GetContentContentIssue(BaseModel):
    identifier: Optional[str]
    title: Optional[str]
    project: Optional[str]
    team: Optional[str]
    status: Optional[str]
    priority: Optional[str]
    type: Optional[str]
    labels: Optional[List[Optional[str]]]


class GetContentContentPackage(BaseModel):
    file_count: Optional[int] = Field(alias="fileCount")
    folder_count: Optional[int] = Field(alias="folderCount")
    is_encrypted: Optional[bool] = Field(alias="isEncrypted")


class GetContentContentLanguage(BaseModel):
    languages: Optional[List[Optional[str]]]


class GetContentContentParent(BaseModel):
    id: str
    name: str


class GetContentContentChildren(BaseModel):
    id: str
    name: str


class GetContentContentFeed(BaseModel):
    id: str
    name: str


class GetContentContentCollections(BaseModel):
    id: str
    name: str


class GetContentContentLinks(BaseModel):
    uri: Optional[Any]
    link_type: Optional[LinkTypes] = Field(alias="linkType")


class GetContentContentObservations(BaseModel):
    id: str
    type: ObservableTypes
    observable: "GetContentContentObservationsObservable"
    related: Optional["GetContentContentObservationsRelated"]
    related_type: Optional[ObservableTypes] = Field(alias="relatedType")
    relation: Optional[str]
    occurrences: Optional[List[Optional["GetContentContentObservationsOccurrences"]]]
    state: EntityState


class GetContentContentObservationsObservable(BaseModel):
    id: str
    name: Optional[str]


class GetContentContentObservationsRelated(BaseModel):
    id: str
    name: Optional[str]


class GetContentContentObservationsOccurrences(BaseModel):
    type: Optional[OccurrenceTypes]
    confidence: Optional[float]
    start_time: Optional[Any] = Field(alias="startTime")
    end_time: Optional[Any] = Field(alias="endTime")
    page_index: Optional[int] = Field(alias="pageIndex")
    bounding_box: Optional["GetContentContentObservationsOccurrencesBoundingBox"] = (
        Field(alias="boundingBox")
    )


class GetContentContentObservationsOccurrencesBoundingBox(BaseModel):
    left: Optional[float]
    top: Optional[float]
    width: Optional[float]
    height: Optional[float]


class GetContentContentWorkflow(BaseModel):
    id: str
    name: str


class GetContentContentPages(BaseModel):
    index: Optional[int]
    text: Optional[str]
    relevance: Optional[float]
    images: Optional[List[Optional["GetContentContentPagesImages"]]]
    chunks: Optional[List[Optional["GetContentContentPagesChunks"]]]


class GetContentContentPagesImages(BaseModel):
    id: Optional[str]
    mime_type: Optional[str] = Field(alias="mimeType")
    data: Optional[str]
    left: Optional[int]
    right: Optional[int]
    top: Optional[int]
    bottom: Optional[int]


class GetContentContentPagesChunks(BaseModel):
    index: Optional[int]
    page_index: Optional[int] = Field(alias="pageIndex")
    row_index: Optional[int] = Field(alias="rowIndex")
    column_index: Optional[int] = Field(alias="columnIndex")
    confidence: Optional[float]
    text: Optional[str]
    role: Optional[TextRoles]
    language: Optional[str]
    relevance: Optional[float]


class GetContentContentSegments(BaseModel):
    start_time: Optional[Any] = Field(alias="startTime")
    end_time: Optional[Any] = Field(alias="endTime")
    text: Optional[str]
    relevance: Optional[float]


class GetContentContentFrames(BaseModel):
    index: Optional[int]
    description: Optional[str]
    text: Optional[str]
    relevance: Optional[float]


GetContent.model_rebuild()
GetContentContent.model_rebuild()
GetContentContentEmail.model_rebuild()
GetContentContentEvent.model_rebuild()
GetContentContentObservations.model_rebuild()
GetContentContentObservationsOccurrences.model_rebuild()
GetContentContentPages.model_rebuild()
