# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ArcadeProviders,
    AuthenticationServiceTypes,
    ConnectorTypes,
    EntityState,
    IntegrationServiceTypes,
    MCPServerTypes,
    OAuthProviders,
    UserTypes,
)


class GetUser(BaseModel):
    user: Optional["GetUserUser"]


class GetUserUser(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "GetUserUserOwner"
    state: EntityState
    type: Optional[UserTypes]
    identifier: str
    description: Optional[str]
    connectors: Optional[List[Optional["GetUserUserConnectors"]]]


class GetUserUserOwner(BaseModel):
    id: str


class GetUserUserConnectors(BaseModel):
    id: str
    name: str
    state: EntityState
    type: Optional[ConnectorTypes]
    authentication: Optional["GetUserUserConnectorsAuthentication"]
    integration: Optional["GetUserUserConnectorsIntegration"]


class GetUserUserConnectorsAuthentication(BaseModel):
    type: AuthenticationServiceTypes
    microsoft: Optional["GetUserUserConnectorsAuthenticationMicrosoft"]
    google: Optional["GetUserUserConnectorsAuthenticationGoogle"]
    oauth: Optional["GetUserUserConnectorsAuthenticationOauth"]
    arcade: Optional["GetUserUserConnectorsAuthenticationArcade"]


class GetUserUserConnectorsAuthenticationMicrosoft(BaseModel):
    tenant_id: str = Field(alias="tenantId")
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class GetUserUserConnectorsAuthenticationGoogle(BaseModel):
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class GetUserUserConnectorsAuthenticationOauth(BaseModel):
    refresh_token: str = Field(alias="refreshToken")
    provider: OAuthProviders
    metadata: Optional[str]


class GetUserUserConnectorsAuthenticationArcade(BaseModel):
    authorization_id: str = Field(alias="authorizationId")
    provider: ArcadeProviders
    metadata: Optional[str]


class GetUserUserConnectorsIntegration(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["GetUserUserConnectorsIntegrationSlack"]
    email: Optional["GetUserUserConnectorsIntegrationEmail"]
    twitter: Optional["GetUserUserConnectorsIntegrationTwitter"]
    mcp: Optional["GetUserUserConnectorsIntegrationMcp"]


class GetUserUserConnectorsIntegrationSlack(BaseModel):
    token: str
    channel: str


class GetUserUserConnectorsIntegrationEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class GetUserUserConnectorsIntegrationTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class GetUserUserConnectorsIntegrationMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


GetUser.model_rebuild()
GetUserUser.model_rebuild()
GetUserUserConnectors.model_rebuild()
GetUserUserConnectorsAuthentication.model_rebuild()
GetUserUserConnectorsIntegration.model_rebuild()
