# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    AssemblyAIModels,
    AzureDocumentIntelligenceModels,
    AzureDocumentIntelligenceVersions,
    ContentClassificationServiceTypes,
    ContentIndexingServiceTypes,
    ContentTypes,
    DeepgramModels,
    EntityEnrichmentServiceTypes,
    EntityExtractionServiceTypes,
    EntityState,
    FilePreparationServiceTypes,
    FileTypes,
    IntegrationServiceTypes,
    LinkTypes,
    MCPServerTypes,
    ObservableTypes,
    ReductoEnrichmentModes,
    ReductoExtractionModes,
    ReductoOcrModes,
    ReductoOcrSystems,
    RegexSourceTypes,
    StoragePolicyTypes,
    SummarizationTypes,
)


class GetWorkflow(BaseModel):
    workflow: Optional["GetWorkflowWorkflow"]


class GetWorkflowWorkflow(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "GetWorkflowWorkflowOwner"
    state: EntityState
    ingestion: Optional["GetWorkflowWorkflowIngestion"]
    indexing: Optional["GetWorkflowWorkflowIndexing"]
    preparation: Optional["GetWorkflowWorkflowPreparation"]
    extraction: Optional["GetWorkflowWorkflowExtraction"]
    classification: Optional["GetWorkflowWorkflowClassification"]
    enrichment: Optional["GetWorkflowWorkflowEnrichment"]
    storage: Optional["GetWorkflowWorkflowStorage"]
    actions: Optional[List[Optional["GetWorkflowWorkflowActions"]]]


class GetWorkflowWorkflowOwner(BaseModel):
    id: str


class GetWorkflowWorkflowIngestion(BaseModel):
    if_: Optional["GetWorkflowWorkflowIngestionIf"] = Field(alias="if")
    collections: Optional[List[Optional["GetWorkflowWorkflowIngestionCollections"]]]
    observations: Optional[List[Optional["GetWorkflowWorkflowIngestionObservations"]]]
    enable_email_collections: Optional[bool] = Field(alias="enableEmailCollections")


class GetWorkflowWorkflowIngestionIf(BaseModel):
    types: Optional[List[ContentTypes]]
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    formats: Optional[List[Optional[str]]]
    file_extensions: Optional[List[str]] = Field(alias="fileExtensions")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")


class GetWorkflowWorkflowIngestionCollections(BaseModel):
    id: str


class GetWorkflowWorkflowIngestionObservations(BaseModel):
    type: ObservableTypes
    observable: "GetWorkflowWorkflowIngestionObservationsObservable"


class GetWorkflowWorkflowIngestionObservationsObservable(BaseModel):
    id: str
    name: Optional[str]


class GetWorkflowWorkflowIndexing(BaseModel):
    jobs: Optional[List[Optional["GetWorkflowWorkflowIndexingJobs"]]]


class GetWorkflowWorkflowIndexingJobs(BaseModel):
    connector: Optional["GetWorkflowWorkflowIndexingJobsConnector"]


class GetWorkflowWorkflowIndexingJobsConnector(BaseModel):
    type: Optional[ContentIndexingServiceTypes]
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")


class GetWorkflowWorkflowPreparation(BaseModel):
    enable_unblocked_capture: Optional[bool] = Field(alias="enableUnblockedCapture")
    disable_smart_capture: Optional[bool] = Field(alias="disableSmartCapture")
    summarizations: Optional[
        List[Optional["GetWorkflowWorkflowPreparationSummarizations"]]
    ]
    jobs: Optional[List[Optional["GetWorkflowWorkflowPreparationJobs"]]]


class GetWorkflowWorkflowPreparationSummarizations(BaseModel):
    type: SummarizationTypes
    specification: Optional["GetWorkflowWorkflowPreparationSummarizationsSpecification"]
    tokens: Optional[int]
    items: Optional[int]
    prompt: Optional[str]


class GetWorkflowWorkflowPreparationSummarizationsSpecification(BaseModel):
    id: str


class GetWorkflowWorkflowPreparationJobs(BaseModel):
    connector: Optional["GetWorkflowWorkflowPreparationJobsConnector"]


class GetWorkflowWorkflowPreparationJobsConnector(BaseModel):
    type: FilePreparationServiceTypes
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    azure_document: Optional[
        "GetWorkflowWorkflowPreparationJobsConnectorAzureDocument"
    ] = Field(alias="azureDocument")
    deepgram: Optional["GetWorkflowWorkflowPreparationJobsConnectorDeepgram"]
    assembly_ai: Optional["GetWorkflowWorkflowPreparationJobsConnectorAssemblyAi"] = (
        Field(alias="assemblyAI")
    )
    page: Optional["GetWorkflowWorkflowPreparationJobsConnectorPage"]
    document: Optional["GetWorkflowWorkflowPreparationJobsConnectorDocument"]
    email: Optional["GetWorkflowWorkflowPreparationJobsConnectorEmail"]
    model_document: Optional[
        "GetWorkflowWorkflowPreparationJobsConnectorModelDocument"
    ] = Field(alias="modelDocument")
    reducto: Optional["GetWorkflowWorkflowPreparationJobsConnectorReducto"]
    mistral: Optional["GetWorkflowWorkflowPreparationJobsConnectorMistral"]


class GetWorkflowWorkflowPreparationJobsConnectorAzureDocument(BaseModel):
    version: Optional[AzureDocumentIntelligenceVersions]
    model: Optional[AzureDocumentIntelligenceModels]
    endpoint: Optional[Any]
    key: Optional[str]


class GetWorkflowWorkflowPreparationJobsConnectorDeepgram(BaseModel):
    model: Optional[DeepgramModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class GetWorkflowWorkflowPreparationJobsConnectorAssemblyAi(BaseModel):
    model: Optional[AssemblyAIModels]
    key: Optional[str]
    enable_redaction: Optional[bool] = Field(alias="enableRedaction")
    enable_speaker_diarization: Optional[bool] = Field(alias="enableSpeakerDiarization")
    detect_language: Optional[bool] = Field(alias="detectLanguage")
    language: Optional[str]


class GetWorkflowWorkflowPreparationJobsConnectorPage(BaseModel):
    enable_screenshot: Optional[bool] = Field(alias="enableScreenshot")


class GetWorkflowWorkflowPreparationJobsConnectorDocument(BaseModel):
    include_images: Optional[bool] = Field(alias="includeImages")


class GetWorkflowWorkflowPreparationJobsConnectorEmail(BaseModel):
    include_attachments: Optional[bool] = Field(alias="includeAttachments")


class GetWorkflowWorkflowPreparationJobsConnectorModelDocument(BaseModel):
    specification: Optional[
        "GetWorkflowWorkflowPreparationJobsConnectorModelDocumentSpecification"
    ]


class GetWorkflowWorkflowPreparationJobsConnectorModelDocumentSpecification(BaseModel):
    id: str


class GetWorkflowWorkflowPreparationJobsConnectorReducto(BaseModel):
    ocr_mode: Optional[ReductoOcrModes] = Field(alias="ocrMode")
    ocr_system: Optional[ReductoOcrSystems] = Field(alias="ocrSystem")
    extraction_mode: Optional[ReductoExtractionModes] = Field(alias="extractionMode")
    enable_enrichment: Optional[bool] = Field(alias="enableEnrichment")
    enrichment_mode: Optional[ReductoEnrichmentModes] = Field(alias="enrichmentMode")
    key: Optional[str]


class GetWorkflowWorkflowPreparationJobsConnectorMistral(BaseModel):
    key: Optional[str]


class GetWorkflowWorkflowExtraction(BaseModel):
    jobs: Optional[List[Optional["GetWorkflowWorkflowExtractionJobs"]]]


class GetWorkflowWorkflowExtractionJobs(BaseModel):
    connector: Optional["GetWorkflowWorkflowExtractionJobsConnector"]


class GetWorkflowWorkflowExtractionJobsConnector(BaseModel):
    type: EntityExtractionServiceTypes
    content_types: Optional[List[ContentTypes]] = Field(alias="contentTypes")
    file_types: Optional[List[FileTypes]] = Field(alias="fileTypes")
    extracted_types: Optional[List[ObservableTypes]] = Field(alias="extractedTypes")
    extracted_count: Optional[int] = Field(alias="extractedCount")
    azure_text: Optional["GetWorkflowWorkflowExtractionJobsConnectorAzureText"] = Field(
        alias="azureText"
    )
    azure_image: Optional["GetWorkflowWorkflowExtractionJobsConnectorAzureImage"] = (
        Field(alias="azureImage")
    )
    model_image: Optional["GetWorkflowWorkflowExtractionJobsConnectorModelImage"] = (
        Field(alias="modelImage")
    )
    model_text: Optional["GetWorkflowWorkflowExtractionJobsConnectorModelText"] = Field(
        alias="modelText"
    )


class GetWorkflowWorkflowExtractionJobsConnectorAzureText(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")
    enable_pii: Optional[bool] = Field(alias="enablePII")


class GetWorkflowWorkflowExtractionJobsConnectorAzureImage(BaseModel):
    confidence_threshold: Optional[float] = Field(alias="confidenceThreshold")


class GetWorkflowWorkflowExtractionJobsConnectorModelImage(BaseModel):
    specification: Optional[
        "GetWorkflowWorkflowExtractionJobsConnectorModelImageSpecification"
    ]


class GetWorkflowWorkflowExtractionJobsConnectorModelImageSpecification(BaseModel):
    id: str


class GetWorkflowWorkflowExtractionJobsConnectorModelText(BaseModel):
    specification: Optional[
        "GetWorkflowWorkflowExtractionJobsConnectorModelTextSpecification"
    ]


class GetWorkflowWorkflowExtractionJobsConnectorModelTextSpecification(BaseModel):
    id: str


class GetWorkflowWorkflowClassification(BaseModel):
    jobs: Optional[List[Optional["GetWorkflowWorkflowClassificationJobs"]]]


class GetWorkflowWorkflowClassificationJobs(BaseModel):
    connector: Optional["GetWorkflowWorkflowClassificationJobsConnector"]


class GetWorkflowWorkflowClassificationJobsConnector(BaseModel):
    type: ContentClassificationServiceTypes
    content_type: Optional[ContentTypes] = Field(alias="contentType")
    file_type: Optional[FileTypes] = Field(alias="fileType")
    model: Optional["GetWorkflowWorkflowClassificationJobsConnectorModel"]
    regex: Optional["GetWorkflowWorkflowClassificationJobsConnectorRegex"]


class GetWorkflowWorkflowClassificationJobsConnectorModel(BaseModel):
    specification: Optional[
        "GetWorkflowWorkflowClassificationJobsConnectorModelSpecification"
    ]
    rules: Optional[
        List[Optional["GetWorkflowWorkflowClassificationJobsConnectorModelRules"]]
    ]


class GetWorkflowWorkflowClassificationJobsConnectorModelSpecification(BaseModel):
    id: str


class GetWorkflowWorkflowClassificationJobsConnectorModelRules(BaseModel):
    then: Optional[str]
    if_: Optional[str] = Field(alias="if")


class GetWorkflowWorkflowClassificationJobsConnectorRegex(BaseModel):
    rules: Optional[
        List[Optional["GetWorkflowWorkflowClassificationJobsConnectorRegexRules"]]
    ]


class GetWorkflowWorkflowClassificationJobsConnectorRegexRules(BaseModel):
    then: Optional[str]
    type: Optional[RegexSourceTypes]
    path: Optional[str]
    matches: Optional[str]


class GetWorkflowWorkflowEnrichment(BaseModel):
    link: Optional["GetWorkflowWorkflowEnrichmentLink"]
    jobs: Optional[List[Optional["GetWorkflowWorkflowEnrichmentJobs"]]]


class GetWorkflowWorkflowEnrichmentLink(BaseModel):
    enable_crawling: Optional[bool] = Field(alias="enableCrawling")
    allowed_domains: Optional[List[str]] = Field(alias="allowedDomains")
    excluded_domains: Optional[List[str]] = Field(alias="excludedDomains")
    allowed_paths: Optional[List[str]] = Field(alias="allowedPaths")
    excluded_paths: Optional[List[str]] = Field(alias="excludedPaths")
    allowed_links: Optional[List[LinkTypes]] = Field(alias="allowedLinks")
    excluded_links: Optional[List[LinkTypes]] = Field(alias="excludedLinks")
    allowed_files: Optional[List[FileTypes]] = Field(alias="allowedFiles")
    excluded_files: Optional[List[FileTypes]] = Field(alias="excludedFiles")
    allowed_content_types: Optional[List[ContentTypes]] = Field(
        alias="allowedContentTypes"
    )
    excluded_content_types: Optional[List[ContentTypes]] = Field(
        alias="excludedContentTypes"
    )
    allow_content_domain: Optional[bool] = Field(alias="allowContentDomain")
    maximum_links: Optional[int] = Field(alias="maximumLinks")


class GetWorkflowWorkflowEnrichmentJobs(BaseModel):
    connector: Optional["GetWorkflowWorkflowEnrichmentJobsConnector"]


class GetWorkflowWorkflowEnrichmentJobsConnector(BaseModel):
    type: Optional[EntityEnrichmentServiceTypes]
    enriched_types: Optional[List[Optional[ObservableTypes]]] = Field(
        alias="enrichedTypes"
    )
    fhir: Optional["GetWorkflowWorkflowEnrichmentJobsConnectorFhir"]
    diffbot: Optional["GetWorkflowWorkflowEnrichmentJobsConnectorDiffbot"]


class GetWorkflowWorkflowEnrichmentJobsConnectorFhir(BaseModel):
    endpoint: Optional[Any]


class GetWorkflowWorkflowEnrichmentJobsConnectorDiffbot(BaseModel):
    key: Optional[Any]


class GetWorkflowWorkflowStorage(BaseModel):
    policy: Optional["GetWorkflowWorkflowStoragePolicy"]


class GetWorkflowWorkflowStoragePolicy(BaseModel):
    type: Optional[StoragePolicyTypes]
    allow_duplicates: Optional[bool] = Field(alias="allowDuplicates")


class GetWorkflowWorkflowActions(BaseModel):
    connector: Optional["GetWorkflowWorkflowActionsConnector"]


class GetWorkflowWorkflowActionsConnector(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["GetWorkflowWorkflowActionsConnectorSlack"]
    email: Optional["GetWorkflowWorkflowActionsConnectorEmail"]
    twitter: Optional["GetWorkflowWorkflowActionsConnectorTwitter"]
    mcp: Optional["GetWorkflowWorkflowActionsConnectorMcp"]


class GetWorkflowWorkflowActionsConnectorSlack(BaseModel):
    token: str
    channel: str


class GetWorkflowWorkflowActionsConnectorEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class GetWorkflowWorkflowActionsConnectorTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class GetWorkflowWorkflowActionsConnectorMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


GetWorkflow.model_rebuild()
GetWorkflowWorkflow.model_rebuild()
GetWorkflowWorkflowIngestion.model_rebuild()
GetWorkflowWorkflowIngestionObservations.model_rebuild()
GetWorkflowWorkflowIndexing.model_rebuild()
GetWorkflowWorkflowIndexingJobs.model_rebuild()
GetWorkflowWorkflowPreparation.model_rebuild()
GetWorkflowWorkflowPreparationSummarizations.model_rebuild()
GetWorkflowWorkflowPreparationJobs.model_rebuild()
GetWorkflowWorkflowPreparationJobsConnector.model_rebuild()
GetWorkflowWorkflowPreparationJobsConnectorModelDocument.model_rebuild()
GetWorkflowWorkflowExtraction.model_rebuild()
GetWorkflowWorkflowExtractionJobs.model_rebuild()
GetWorkflowWorkflowExtractionJobsConnector.model_rebuild()
GetWorkflowWorkflowExtractionJobsConnectorModelImage.model_rebuild()
GetWorkflowWorkflowExtractionJobsConnectorModelText.model_rebuild()
GetWorkflowWorkflowClassification.model_rebuild()
GetWorkflowWorkflowClassificationJobs.model_rebuild()
GetWorkflowWorkflowClassificationJobsConnector.model_rebuild()
GetWorkflowWorkflowClassificationJobsConnectorModel.model_rebuild()
GetWorkflowWorkflowClassificationJobsConnectorRegex.model_rebuild()
GetWorkflowWorkflowEnrichment.model_rebuild()
GetWorkflowWorkflowEnrichmentJobs.model_rebuild()
GetWorkflowWorkflowEnrichmentJobsConnector.model_rebuild()
GetWorkflowWorkflowStorage.model_rebuild()
GetWorkflowWorkflowActions.model_rebuild()
GetWorkflowWorkflowActionsConnector.model_rebuild()
