# Generated by ariadne-codegen
# Source: ./documents

from typing import Any, List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import (
    ArcadeProviders,
    AuthenticationServiceTypes,
    ConnectorTypes,
    EntityState,
    IntegrationServiceTypes,
    MCPServerTypes,
    OAuthProviders,
    UserTypes,
)


class QueryUsers(BaseModel):
    users: Optional["QueryUsersUsers"]


class QueryUsersUsers(BaseModel):
    results: Optional[List["QueryUsersUsersResults"]]


class QueryUsersUsersResults(BaseModel):
    id: str
    name: str
    creation_date: Any = Field(alias="creationDate")
    relevance: Optional[float]
    owner: "QueryUsersUsersResultsOwner"
    state: EntityState
    type: Optional[UserTypes]
    identifier: str
    description: Optional[str]
    connectors: Optional[List[Optional["QueryUsersUsersResultsConnectors"]]]


class QueryUsersUsersResultsOwner(BaseModel):
    id: str


class QueryUsersUsersResultsConnectors(BaseModel):
    id: str
    name: str
    state: EntityState
    type: Optional[ConnectorTypes]
    authentication: Optional["QueryUsersUsersResultsConnectorsAuthentication"]
    integration: Optional["QueryUsersUsersResultsConnectorsIntegration"]


class QueryUsersUsersResultsConnectorsAuthentication(BaseModel):
    type: AuthenticationServiceTypes
    microsoft: Optional["QueryUsersUsersResultsConnectorsAuthenticationMicrosoft"]
    google: Optional["QueryUsersUsersResultsConnectorsAuthenticationGoogle"]
    oauth: Optional["QueryUsersUsersResultsConnectorsAuthenticationOauth"]
    arcade: Optional["QueryUsersUsersResultsConnectorsAuthenticationArcade"]


class QueryUsersUsersResultsConnectorsAuthenticationMicrosoft(BaseModel):
    tenant_id: str = Field(alias="tenantId")
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class QueryUsersUsersResultsConnectorsAuthenticationGoogle(BaseModel):
    client_id: str = Field(alias="clientId")
    client_secret: str = Field(alias="clientSecret")


class QueryUsersUsersResultsConnectorsAuthenticationOauth(BaseModel):
    refresh_token: str = Field(alias="refreshToken")
    provider: OAuthProviders
    metadata: Optional[str]


class QueryUsersUsersResultsConnectorsAuthenticationArcade(BaseModel):
    authorization_id: str = Field(alias="authorizationId")
    provider: ArcadeProviders
    metadata: Optional[str]


class QueryUsersUsersResultsConnectorsIntegration(BaseModel):
    type: IntegrationServiceTypes
    uri: Optional[str]
    slack: Optional["QueryUsersUsersResultsConnectorsIntegrationSlack"]
    email: Optional["QueryUsersUsersResultsConnectorsIntegrationEmail"]
    twitter: Optional["QueryUsersUsersResultsConnectorsIntegrationTwitter"]
    mcp: Optional["QueryUsersUsersResultsConnectorsIntegrationMcp"]


class QueryUsersUsersResultsConnectorsIntegrationSlack(BaseModel):
    token: str
    channel: str


class QueryUsersUsersResultsConnectorsIntegrationEmail(BaseModel):
    from_: str = Field(alias="from")
    subject: str
    to: List[str]


class QueryUsersUsersResultsConnectorsIntegrationTwitter(BaseModel):
    consumer_key: str = Field(alias="consumerKey")
    consumer_secret: str = Field(alias="consumerSecret")
    access_token_key: str = Field(alias="accessTokenKey")
    access_token_secret: str = Field(alias="accessTokenSecret")


class QueryUsersUsersResultsConnectorsIntegrationMcp(BaseModel):
    token: Optional[str]
    type: MCPServerTypes


QueryUsers.model_rebuild()
QueryUsersUsers.model_rebuild()
QueryUsersUsersResults.model_rebuild()
QueryUsersUsersResultsConnectors.model_rebuild()
QueryUsersUsersResultsConnectorsAuthentication.model_rebuild()
QueryUsersUsersResultsConnectorsIntegration.model_rebuild()
