# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from .types import (
        After,
        Ascending,
        Before,
        Count,
        ErrorName,
        ErrorResponse,
        Labels,
        Limit,
        OrganizationId,
        PageToken,
        ValidationErrorResponse,
    )
    from .errors import IsTakenError, NotFoundError, ValidationError
    from . import attachments, domains, drafts, events, inboxes, messages, metrics, threads, webhooks, websockets
    from .attachments import (
        Attachment,
        AttachmentContent,
        AttachmentContentType,
        AttachmentFilename,
        AttachmentId,
        AttachmentInline,
        AttachmentSize,
        SendAttachment,
    )
    from .client import AgentMail, AsyncAgentMail
    from .domains import (
        CreateDomainRequest,
        CreateDomainResponse,
        Domain,
        DomainId,
        DomainName,
        DomainSummary,
        ListDomainsResponse,
        RecordStatus,
        RecordType,
        VerificationRecord,
        VerificationStatus,
    )
    from .drafts import (
        CreateDraftRequest,
        Draft,
        DraftAttachments,
        DraftBcc,
        DraftCc,
        DraftHtml,
        DraftId,
        DraftInReplyTo,
        DraftItem,
        DraftLabels,
        DraftPreview,
        DraftReplyTo,
        DraftSendAt,
        DraftSendStatus,
        DraftSubject,
        DraftText,
        DraftTo,
        DraftUpdatedAt,
        ListDraftsResponse,
    )
    from .environment import AgentMailEnvironment
    from .events import (
        Bounce,
        Complaint,
        Delivery,
        EventId,
        MessageBouncedEvent,
        MessageComplainedEvent,
        MessageDeliveredEvent,
        MessageReceivedEvent,
        MessageRejectedEvent,
        MessageSentEvent,
        Recipient,
        Reject,
        Send,
        Timestamp,
    )
    from .messages import (
        Addresses,
        ListMessagesResponse,
        Message,
        MessageAttachments,
        MessageBcc,
        MessageCc,
        MessageCreatedAt,
        MessageFrom,
        MessageHtml,
        MessageId,
        MessageInReplyTo,
        MessageItem,
        MessageLabels,
        MessagePreview,
        MessageReferences,
        MessageRejectedError,
        MessageReplyTo,
        MessageSize,
        MessageSubject,
        MessageText,
        MessageTimestamp,
        MessageTo,
        MessageUpdatedAt,
        ReplyToMessageRequest,
        SendMessageAttachments,
        SendMessageBcc,
        SendMessageCc,
        SendMessageReplyTo,
        SendMessageRequest,
        SendMessageResponse,
        SendMessageTo,
        UpdateMessageRequest,
    )
    from .metrics import (
        ListMetricsResponse,
        MessageMetrics,
        MetricEndTimestamp,
        MetricEventType,
        MetricEventTypes,
        MetricStartTimestamp,
        MetricTimestamp,
    )
    from .threads import (
        ListThreadsResponse,
        Thread,
        ThreadAttachments,
        ThreadCreatedAt,
        ThreadId,
        ThreadItem,
        ThreadLabels,
        ThreadLastMessageId,
        ThreadMessageCount,
        ThreadPreview,
        ThreadReceivedTimestamp,
        ThreadRecipients,
        ThreadSenders,
        ThreadSentTimestamp,
        ThreadSize,
        ThreadSubject,
        ThreadTimestamp,
        ThreadUpdatedAt,
    )
    from .version import __version__
    from .websockets import Subscribe, Subscribed
_dynamic_imports: typing.Dict[str, str] = {
    "Addresses": ".messages",
    "After": ".types",
    "AgentMail": ".client",
    "AgentMailEnvironment": ".environment",
    "Ascending": ".types",
    "AsyncAgentMail": ".client",
    "Attachment": ".attachments",
    "AttachmentContent": ".attachments",
    "AttachmentContentType": ".attachments",
    "AttachmentFilename": ".attachments",
    "AttachmentId": ".attachments",
    "AttachmentInline": ".attachments",
    "AttachmentSize": ".attachments",
    "Before": ".types",
    "Bounce": ".events",
    "Complaint": ".events",
    "Count": ".types",
    "CreateDomainRequest": ".domains",
    "CreateDomainResponse": ".domains",
    "CreateDraftRequest": ".drafts",
    "Delivery": ".events",
    "Domain": ".domains",
    "DomainId": ".domains",
    "DomainName": ".domains",
    "DomainSummary": ".domains",
    "Draft": ".drafts",
    "DraftAttachments": ".drafts",
    "DraftBcc": ".drafts",
    "DraftCc": ".drafts",
    "DraftHtml": ".drafts",
    "DraftId": ".drafts",
    "DraftInReplyTo": ".drafts",
    "DraftItem": ".drafts",
    "DraftLabels": ".drafts",
    "DraftPreview": ".drafts",
    "DraftReplyTo": ".drafts",
    "DraftSendAt": ".drafts",
    "DraftSendStatus": ".drafts",
    "DraftSubject": ".drafts",
    "DraftText": ".drafts",
    "DraftTo": ".drafts",
    "DraftUpdatedAt": ".drafts",
    "ErrorName": ".types",
    "ErrorResponse": ".types",
    "EventId": ".events",
    "IsTakenError": ".errors",
    "Labels": ".types",
    "Limit": ".types",
    "ListDomainsResponse": ".domains",
    "ListDraftsResponse": ".drafts",
    "ListMessagesResponse": ".messages",
    "ListMetricsResponse": ".metrics",
    "ListThreadsResponse": ".threads",
    "Message": ".messages",
    "MessageAttachments": ".messages",
    "MessageBcc": ".messages",
    "MessageBouncedEvent": ".events",
    "MessageCc": ".messages",
    "MessageComplainedEvent": ".events",
    "MessageCreatedAt": ".messages",
    "MessageDeliveredEvent": ".events",
    "MessageFrom": ".messages",
    "MessageHtml": ".messages",
    "MessageId": ".messages",
    "MessageInReplyTo": ".messages",
    "MessageItem": ".messages",
    "MessageLabels": ".messages",
    "MessageMetrics": ".metrics",
    "MessagePreview": ".messages",
    "MessageReceivedEvent": ".events",
    "MessageReferences": ".messages",
    "MessageRejectedError": ".messages",
    "MessageRejectedEvent": ".events",
    "MessageReplyTo": ".messages",
    "MessageSentEvent": ".events",
    "MessageSize": ".messages",
    "MessageSubject": ".messages",
    "MessageText": ".messages",
    "MessageTimestamp": ".messages",
    "MessageTo": ".messages",
    "MessageUpdatedAt": ".messages",
    "MetricEndTimestamp": ".metrics",
    "MetricEventType": ".metrics",
    "MetricEventTypes": ".metrics",
    "MetricStartTimestamp": ".metrics",
    "MetricTimestamp": ".metrics",
    "NotFoundError": ".errors",
    "OrganizationId": ".types",
    "PageToken": ".types",
    "Recipient": ".events",
    "RecordStatus": ".domains",
    "RecordType": ".domains",
    "Reject": ".events",
    "ReplyToMessageRequest": ".messages",
    "Send": ".events",
    "SendAttachment": ".attachments",
    "SendMessageAttachments": ".messages",
    "SendMessageBcc": ".messages",
    "SendMessageCc": ".messages",
    "SendMessageReplyTo": ".messages",
    "SendMessageRequest": ".messages",
    "SendMessageResponse": ".messages",
    "SendMessageTo": ".messages",
    "Subscribe": ".websockets",
    "Subscribed": ".websockets",
    "Thread": ".threads",
    "ThreadAttachments": ".threads",
    "ThreadCreatedAt": ".threads",
    "ThreadId": ".threads",
    "ThreadItem": ".threads",
    "ThreadLabels": ".threads",
    "ThreadLastMessageId": ".threads",
    "ThreadMessageCount": ".threads",
    "ThreadPreview": ".threads",
    "ThreadReceivedTimestamp": ".threads",
    "ThreadRecipients": ".threads",
    "ThreadSenders": ".threads",
    "ThreadSentTimestamp": ".threads",
    "ThreadSize": ".threads",
    "ThreadSubject": ".threads",
    "ThreadTimestamp": ".threads",
    "ThreadUpdatedAt": ".threads",
    "Timestamp": ".events",
    "UpdateMessageRequest": ".messages",
    "ValidationError": ".errors",
    "ValidationErrorResponse": ".types",
    "VerificationRecord": ".domains",
    "VerificationStatus": ".domains",
    "__version__": ".version",
    "attachments": ".attachments",
    "domains": ".domains",
    "drafts": ".drafts",
    "events": ".events",
    "inboxes": ".inboxes",
    "messages": ".messages",
    "metrics": ".metrics",
    "threads": ".threads",
    "webhooks": ".webhooks",
    "websockets": ".websockets",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "Addresses",
    "After",
    "AgentMail",
    "AgentMailEnvironment",
    "Ascending",
    "AsyncAgentMail",
    "Attachment",
    "AttachmentContent",
    "AttachmentContentType",
    "AttachmentFilename",
    "AttachmentId",
    "AttachmentInline",
    "AttachmentSize",
    "Before",
    "Bounce",
    "Complaint",
    "Count",
    "CreateDomainRequest",
    "CreateDomainResponse",
    "CreateDraftRequest",
    "Delivery",
    "Domain",
    "DomainId",
    "DomainName",
    "DomainSummary",
    "Draft",
    "DraftAttachments",
    "DraftBcc",
    "DraftCc",
    "DraftHtml",
    "DraftId",
    "DraftInReplyTo",
    "DraftItem",
    "DraftLabels",
    "DraftPreview",
    "DraftReplyTo",
    "DraftSendAt",
    "DraftSendStatus",
    "DraftSubject",
    "DraftText",
    "DraftTo",
    "DraftUpdatedAt",
    "ErrorName",
    "ErrorResponse",
    "EventId",
    "IsTakenError",
    "Labels",
    "Limit",
    "ListDomainsResponse",
    "ListDraftsResponse",
    "ListMessagesResponse",
    "ListMetricsResponse",
    "ListThreadsResponse",
    "Message",
    "MessageAttachments",
    "MessageBcc",
    "MessageBouncedEvent",
    "MessageCc",
    "MessageComplainedEvent",
    "MessageCreatedAt",
    "MessageDeliveredEvent",
    "MessageFrom",
    "MessageHtml",
    "MessageId",
    "MessageInReplyTo",
    "MessageItem",
    "MessageLabels",
    "MessageMetrics",
    "MessagePreview",
    "MessageReceivedEvent",
    "MessageReferences",
    "MessageRejectedError",
    "MessageRejectedEvent",
    "MessageReplyTo",
    "MessageSentEvent",
    "MessageSize",
    "MessageSubject",
    "MessageText",
    "MessageTimestamp",
    "MessageTo",
    "MessageUpdatedAt",
    "MetricEndTimestamp",
    "MetricEventType",
    "MetricEventTypes",
    "MetricStartTimestamp",
    "MetricTimestamp",
    "NotFoundError",
    "OrganizationId",
    "PageToken",
    "Recipient",
    "RecordStatus",
    "RecordType",
    "Reject",
    "ReplyToMessageRequest",
    "Send",
    "SendAttachment",
    "SendMessageAttachments",
    "SendMessageBcc",
    "SendMessageCc",
    "SendMessageReplyTo",
    "SendMessageRequest",
    "SendMessageResponse",
    "SendMessageTo",
    "Subscribe",
    "Subscribed",
    "Thread",
    "ThreadAttachments",
    "ThreadCreatedAt",
    "ThreadId",
    "ThreadItem",
    "ThreadLabels",
    "ThreadLastMessageId",
    "ThreadMessageCount",
    "ThreadPreview",
    "ThreadReceivedTimestamp",
    "ThreadRecipients",
    "ThreadSenders",
    "ThreadSentTimestamp",
    "ThreadSize",
    "ThreadSubject",
    "ThreadTimestamp",
    "ThreadUpdatedAt",
    "Timestamp",
    "UpdateMessageRequest",
    "ValidationError",
    "ValidationErrorResponse",
    "VerificationRecord",
    "VerificationStatus",
    "__version__",
    "attachments",
    "domains",
    "drafts",
    "events",
    "inboxes",
    "messages",
    "metrics",
    "threads",
    "webhooks",
    "websockets",
]
