# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import AgentMailEnvironment

if typing.TYPE_CHECKING:
    from .domains.client import AsyncDomainsClient, DomainsClient
    from .drafts.client import AsyncDraftsClient, DraftsClient
    from .inboxes.client import AsyncInboxesClient, InboxesClient
    from .metrics.client import AsyncMetricsClient, MetricsClient
    from .threads.client import AsyncThreadsClient, ThreadsClient
    from .webhooks.client import AsyncWebhooksClient, WebhooksClient


class AgentMail:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : AgentMailEnvironment
        The environment to use for requests from the client. from .environment import AgentMailEnvironment



        Defaults to AgentMailEnvironment.PRODUCTION



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agentmail import AgentMail

    client = AgentMail(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: AgentMailEnvironment = AgentMailEnvironment.PRODUCTION,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("AGENTMAIL_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting AGENTMAIL_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._inboxes: typing.Optional[InboxesClient] = None
        self._webhooks: typing.Optional[WebhooksClient] = None
        self._domains: typing.Optional[DomainsClient] = None
        self._drafts: typing.Optional[DraftsClient] = None
        self._metrics: typing.Optional[MetricsClient] = None
        self._threads: typing.Optional[ThreadsClient] = None

    @property
    def inboxes(self):
        if self._inboxes is None:
            from .inboxes.client import InboxesClient  # noqa: E402

            self._inboxes = InboxesClient(client_wrapper=self._client_wrapper)
        return self._inboxes

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import WebhooksClient  # noqa: E402

            self._webhooks = WebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks

    @property
    def domains(self):
        if self._domains is None:
            from .domains.client import DomainsClient  # noqa: E402

            self._domains = DomainsClient(client_wrapper=self._client_wrapper)
        return self._domains

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import DraftsClient  # noqa: E402

            self._drafts = DraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import MetricsClient  # noqa: E402

            self._metrics = MetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import ThreadsClient  # noqa: E402

            self._threads = ThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads


class AsyncAgentMail:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : AgentMailEnvironment
        The environment to use for requests from the client. from .environment import AgentMailEnvironment



        Defaults to AgentMailEnvironment.PRODUCTION



    api_key : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from agentmail import AsyncAgentMail

    client = AsyncAgentMail(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: AgentMailEnvironment = AgentMailEnvironment.PRODUCTION,
        api_key: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("AGENTMAIL_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if api_key is None:
            raise ApiError(
                body="The client must be instantiated be either passing in api_key or setting AGENTMAIL_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._inboxes: typing.Optional[AsyncInboxesClient] = None
        self._webhooks: typing.Optional[AsyncWebhooksClient] = None
        self._domains: typing.Optional[AsyncDomainsClient] = None
        self._drafts: typing.Optional[AsyncDraftsClient] = None
        self._metrics: typing.Optional[AsyncMetricsClient] = None
        self._threads: typing.Optional[AsyncThreadsClient] = None

    @property
    def inboxes(self):
        if self._inboxes is None:
            from .inboxes.client import AsyncInboxesClient  # noqa: E402

            self._inboxes = AsyncInboxesClient(client_wrapper=self._client_wrapper)
        return self._inboxes

    @property
    def webhooks(self):
        if self._webhooks is None:
            from .webhooks.client import AsyncWebhooksClient  # noqa: E402

            self._webhooks = AsyncWebhooksClient(client_wrapper=self._client_wrapper)
        return self._webhooks

    @property
    def domains(self):
        if self._domains is None:
            from .domains.client import AsyncDomainsClient  # noqa: E402

            self._domains = AsyncDomainsClient(client_wrapper=self._client_wrapper)
        return self._domains

    @property
    def drafts(self):
        if self._drafts is None:
            from .drafts.client import AsyncDraftsClient  # noqa: E402

            self._drafts = AsyncDraftsClient(client_wrapper=self._client_wrapper)
        return self._drafts

    @property
    def metrics(self):
        if self._metrics is None:
            from .metrics.client import AsyncMetricsClient  # noqa: E402

            self._metrics = AsyncMetricsClient(client_wrapper=self._client_wrapper)
        return self._metrics

    @property
    def threads(self):
        if self._threads is None:
            from .threads.client import AsyncThreadsClient  # noqa: E402

            self._threads = AsyncThreadsClient(client_wrapper=self._client_wrapper)
        return self._threads
