# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.organization_id import OrganizationId
from .domain_id import DomainId
from .verification_record import VerificationRecord
from .verification_status import VerificationStatus


class CreateDomainResponse(UncheckedBaseModel):
    domain_id: DomainId
    organization_id: OrganizationId
    status: VerificationStatus = pydantic.Field()
    """
    The verification status of the domain.
    """

    feedback_enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether bounce and complaint notifications are forwarded to your domain.
    """

    records: typing.List[VerificationRecord] = pydantic.Field()
    """
    A list of DNS records required to verify the domain.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which the domain was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
