# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...drafts.types.draft import Draft
from ...drafts.types.draft_bcc import DraftBcc
from ...drafts.types.draft_cc import DraftCc
from ...drafts.types.draft_html import DraftHtml
from ...drafts.types.draft_id import DraftId
from ...drafts.types.draft_in_reply_to import DraftInReplyTo
from ...drafts.types.draft_item import DraftItem
from ...drafts.types.draft_labels import DraftLabels
from ...drafts.types.draft_reply_to import DraftReplyTo
from ...drafts.types.draft_send_at import DraftSendAt
from ...drafts.types.draft_subject import DraftSubject
from ...drafts.types.draft_text import DraftText
from ...drafts.types.draft_to import DraftTo
from ...messages.types.send_message_response import SendMessageResponse
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ..types.inbox_id import InboxId
from .raw_client import AsyncRawDraftsClient, RawDraftsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DraftsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDraftsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDraftsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDraftsClient
        """
        return self._raw_client

    def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DraftItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DraftItem]

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        response = client.inboxes.drafts.list(
            inbox_id="inbox_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(
            inbox_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Draft:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.drafts.get(
            inbox_id="inbox_id",
            draft_id="draft_id",
        )
        """
        _response = self._raw_client.get(inbox_id, draft_id, request_options=request_options)
        return _response.data

    def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        in_reply_to: typing.Optional[DraftInReplyTo] = OMIT,
        send_at: typing.Optional[DraftSendAt] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Draft:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        in_reply_to : typing.Optional[DraftInReplyTo]

        send_at : typing.Optional[DraftSendAt]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.drafts.create(
            inbox_id="inbox_id",
        )
        """
        _response = self._raw_client.create(
            inbox_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            in_reply_to=in_reply_to,
            send_at=send_at,
            request_options=request_options,
        )
        return _response.data

    def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.drafts.send(
            inbox_id="inbox_id",
            draft_id="draft_id",
        )
        """
        _response = self._raw_client.send(
            inbox_id, draft_id, add_labels=add_labels, remove_labels=remove_labels, request_options=request_options
        )
        return _response.data

    def delete(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from agentmail import AgentMail

        client = AgentMail(
            api_key="YOUR_API_KEY",
        )
        client.inboxes.drafts.delete(
            inbox_id="inbox_id",
            draft_id="draft_id",
        )
        """
        _response = self._raw_client.delete(inbox_id, draft_id, request_options=request_options)
        return _response.data


class AsyncDraftsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDraftsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDraftsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDraftsClient
        """
        return self._raw_client

    async def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DraftItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DraftItem]

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            response = await client.inboxes.drafts.list(
                inbox_id="inbox_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(
            inbox_id,
            limit=limit,
            page_token=page_token,
            labels=labels,
            before=before,
            after=after,
            ascending=ascending,
            request_options=request_options,
        )

    async def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Draft:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.drafts.get(
                inbox_id="inbox_id",
                draft_id="draft_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(inbox_id, draft_id, request_options=request_options)
        return _response.data

    async def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        in_reply_to: typing.Optional[DraftInReplyTo] = OMIT,
        send_at: typing.Optional[DraftSendAt] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Draft:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        in_reply_to : typing.Optional[DraftInReplyTo]

        send_at : typing.Optional[DraftSendAt]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Draft

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.drafts.create(
                inbox_id="inbox_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            inbox_id,
            labels=labels,
            reply_to=reply_to,
            to=to,
            cc=cc,
            bcc=bcc,
            subject=subject,
            text=text,
            html=html,
            in_reply_to=in_reply_to,
            send_at=send_at,
            request_options=request_options,
        )
        return _response.data

    async def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SendMessageResponse:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SendMessageResponse

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.drafts.send(
                inbox_id="inbox_id",
                draft_id="draft_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.send(
            inbox_id, draft_id, add_labels=add_labels, remove_labels=remove_labels, request_options=request_options
        )
        return _response.data

    async def delete(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from agentmail import AsyncAgentMail

        client = AsyncAgentMail(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.inboxes.drafts.delete(
                inbox_id="inbox_id",
                draft_id="draft_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(inbox_id, draft_id, request_options=request_options)
        return _response.data
