# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.datetime_utils import serialize_datetime
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.pagination import AsyncPager, BaseHttpResponse, SyncPager
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ...drafts.types.draft import Draft
from ...drafts.types.draft_bcc import DraftBcc
from ...drafts.types.draft_cc import DraftCc
from ...drafts.types.draft_html import DraftHtml
from ...drafts.types.draft_id import DraftId
from ...drafts.types.draft_in_reply_to import DraftInReplyTo
from ...drafts.types.draft_item import DraftItem
from ...drafts.types.draft_labels import DraftLabels
from ...drafts.types.draft_reply_to import DraftReplyTo
from ...drafts.types.draft_send_at import DraftSendAt
from ...drafts.types.draft_subject import DraftSubject
from ...drafts.types.draft_text import DraftText
from ...drafts.types.draft_to import DraftTo
from ...drafts.types.list_drafts_response import ListDraftsResponse
from ...errors.not_found_error import NotFoundError
from ...errors.validation_error import ValidationError
from ...messages.errors.message_rejected_error import MessageRejectedError
from ...messages.types.send_message_response import SendMessageResponse
from ...types.after import After
from ...types.ascending import Ascending
from ...types.before import Before
from ...types.error_response import ErrorResponse
from ...types.labels import Labels
from ...types.limit import Limit
from ...types.page_token import PageToken
from ...types.validation_error_response import ValidationErrorResponse
from ..types.inbox_id import InboxId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawDraftsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[DraftItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[DraftItem]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.drafts
                _parsed_next = _parsed_response.next_page_token
                _has_next = _parsed_next is not None and _parsed_next != ""
                _get_next = lambda: self.list(
                    inbox_id,
                    limit=limit,
                    page_token=_parsed_next,
                    labels=labels,
                    before=before,
                    after=after,
                    ascending=ascending,
                    request_options=request_options,
                )
                return SyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Draft]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        in_reply_to: typing.Optional[DraftInReplyTo] = OMIT,
        send_at: typing.Optional[DraftSendAt] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        in_reply_to : typing.Optional[DraftInReplyTo]

        send_at : typing.Optional[DraftSendAt]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Draft]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": reply_to,
                "to": to,
                "cc": cc,
                "bcc": bcc,
                "subject": subject,
                "text": text,
                "html": html,
                "in_reply_to": in_reply_to,
                "send_at": send_at,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SendMessageResponse]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawDraftsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        inbox_id: InboxId,
        *,
        limit: typing.Optional[Limit] = None,
        page_token: typing.Optional[PageToken] = None,
        labels: typing.Optional[Labels] = None,
        before: typing.Optional[Before] = None,
        after: typing.Optional[After] = None,
        ascending: typing.Optional[Ascending] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[DraftItem]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        limit : typing.Optional[Limit]

        page_token : typing.Optional[PageToken]

        labels : typing.Optional[Labels]

        before : typing.Optional[Before]

        after : typing.Optional[After]

        ascending : typing.Optional[Ascending]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[DraftItem]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            params={
                "limit": limit,
                "page_token": page_token,
                "labels": labels,
                "before": serialize_datetime(before) if before is not None else None,
                "after": serialize_datetime(after) if after is not None else None,
                "ascending": ascending,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ListDraftsResponse,
                    construct_type(
                        type_=ListDraftsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.drafts
                _parsed_next = _parsed_response.next_page_token
                _has_next = _parsed_next is not None and _parsed_next != ""

                async def _get_next():
                    return await self.list(
                        inbox_id,
                        limit=limit,
                        page_token=_parsed_next,
                        labels=labels,
                        before=before,
                        after=after,
                        ascending=ascending,
                        request_options=request_options,
                    )

                return AsyncPager(
                    has_next=_has_next, items=_items, get_next=_get_next, response=BaseHttpResponse(response=_response)
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Draft]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        inbox_id: InboxId,
        *,
        labels: typing.Optional[DraftLabels] = OMIT,
        reply_to: typing.Optional[DraftReplyTo] = OMIT,
        to: typing.Optional[DraftTo] = OMIT,
        cc: typing.Optional[DraftCc] = OMIT,
        bcc: typing.Optional[DraftBcc] = OMIT,
        subject: typing.Optional[DraftSubject] = OMIT,
        text: typing.Optional[DraftText] = OMIT,
        html: typing.Optional[DraftHtml] = OMIT,
        in_reply_to: typing.Optional[DraftInReplyTo] = OMIT,
        send_at: typing.Optional[DraftSendAt] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Draft]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        labels : typing.Optional[DraftLabels]

        reply_to : typing.Optional[DraftReplyTo]

        to : typing.Optional[DraftTo]

        cc : typing.Optional[DraftCc]

        bcc : typing.Optional[DraftBcc]

        subject : typing.Optional[DraftSubject]

        text : typing.Optional[DraftText]

        html : typing.Optional[DraftHtml]

        in_reply_to : typing.Optional[DraftInReplyTo]

        send_at : typing.Optional[DraftSendAt]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Draft]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "labels": labels,
                "reply_to": reply_to,
                "to": to,
                "cc": cc,
                "bcc": bcc,
                "subject": subject,
                "text": text,
                "html": html,
                "in_reply_to": in_reply_to,
                "send_at": send_at,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Draft,
                    construct_type(
                        type_=Draft,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def send(
        self,
        inbox_id: InboxId,
        draft_id: DraftId,
        *,
        add_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        remove_labels: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SendMessageResponse]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        add_labels : typing.Optional[typing.Sequence[str]]
            Labels to add to message.

        remove_labels : typing.Optional[typing.Sequence[str]]
            Labels to remove from message.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SendMessageResponse]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}/send",
            base_url=self._client_wrapper.get_environment().http,
            method="POST",
            json={
                "add_labels": add_labels,
                "remove_labels": remove_labels,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SendMessageResponse,
                    construct_type(
                        type_=SendMessageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 400:
                raise ValidationError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ValidationErrorResponse,
                        construct_type(
                            type_=ValidationErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 403:
                raise MessageRejectedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, inbox_id: InboxId, draft_id: DraftId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        inbox_id : InboxId

        draft_id : DraftId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v0/inboxes/{jsonable_encoder(inbox_id)}/drafts/{jsonable_encoder(draft_id)}",
            base_url=self._client_wrapper.get_environment().http,
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ErrorResponse,
                        construct_type(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
