# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .client_id import ClientId
from .inbox_id import InboxId


class Inbox(UncheckedBaseModel):
    inbox_id: InboxId
    display_name: str = pydantic.Field()
    """
    Display name: `Display Name <username@domain.com>`.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    Time at which inbox was last updated.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Time at which inbox was created.
    """

    client_id: typing.Optional[ClientId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
