# Generated by Django 4.2.8 on 2024-01-03 08:53

from contextlib import suppress

from django.contrib.contenttypes.models import ContentType
from django.db import migrations


def migrate_content_type(apps, schema_editor):
    Publication = apps.get_model("wbwriter", "Publication")

    for model_name in [
        "Classification",
        "Instrument",
        "ClassificationGroup",
        "Deal",
        "Exchange",
        "InstrumentClassificationRelatedInstrument",
        "InstrumentClassificationThroughModel",
        "InstrumentFavoriteGroup",
        "InstrumentList",
        "InstrumentListThroughModel",
        "InstrumentRequest",
        "RelatedInstrumentThroughModel",
        "InstrumentPrice",
    ]:
        with suppress(ContentType.DoesNotExist):
            old_ct = ContentType.objects.get(app_label="wbportfolio", model=model_name.lower())
            new_ct = ContentType.objects.get(app_label="wbfdm", model=model_name.lower())
            Publication.objects.filter(content_type_id=old_ct.id).update(content_type_id=new_ct.id)


class Migration(migrations.Migration):
    dependencies = [
        ("wbwriter", "0010_alter_article_options"),
        ("wbfdm", "0012_instrumentprice_created_instrumentprice_modified"),
    ]

    operations = [migrations.RunPython(migrate_content_type)]
