import uuid

from sqlalchemy import Column, DateTime, String
from sqlalchemy.orm import as_declarative

from architectonics.utils import get_current_datetime


@as_declarative()
class AbstractBaseModel:
    __abstract__ = True

    id = Column(
        String,
        primary_key=True,
        default=lambda: str(uuid.uuid4()),
    )

    created_at = Column(
        DateTime,
        default=get_current_datetime,
    )

    updated_at = Column(
        DateTime,
        default=get_current_datetime,
        onupdate=get_current_datetime,
    )

    PK_FIELD = "id"
