"""
Contains constants used by cellmaps vnn
"""

PRHO_SCORE = 'P_rho'
"""
P rho score
"""

P_PVAL_SCORE = 'P_pval'
"""
P pval score
"""

CRHO_SCORE = 'C_rho'
"""
C rho score
"""

C_PVAL_SCORE = 'C_pval'
"""
C pval score
"""

RLIPP_SCORE = 'RLIPP'
"""
RLIPP score
"""

RLIPP_OUTPUT_FILE = 'rlipp.out'
"""
Output file from rlipp algorithm
"""

HIERARCHY_FILENAME = 'hierarchy.cx2'
"""
Hierarchy filename.
"""

ORIGINAL_HIERARCHY_FILENAME = 'original_hierarchy.cx2'
"""
Original hierarchy filename.
"""

PARENT_NETWORK_NAME = 'hierarchy_parent.cx2'
"""
Parent network of hierarchy filename.
"""

GENE_SET_COLUMN_NAME = 'CD_MemberList'
"""
Name of the node attribute of the hierarchy with list of genes/ proteins of this node.
"""
